/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.AnimationSettings;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.impl.DelegatingMarker;
import com.androidmapsextensions.impl.GridClusteringStrategy;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ClusterMarker
implements Marker {
    private int lastCount = -1;
    private GridClusteringStrategy strategy;
    private com.google.android.gms.maps.model.Marker virtual;
    private List<DelegatingMarker> markers = new ArrayList<DelegatingMarker>();

    public ClusterMarker(GridClusteringStrategy strategy) {
        this.strategy = strategy;
    }

    com.google.android.gms.maps.model.Marker getVirtual() {
        return this.virtual;
    }

    void add(DelegatingMarker marker) {
        this.markers.add(marker);
    }

    void remove(DelegatingMarker marker) {
        this.markers.remove(marker);
    }

    void refresh() {
        int count = this.markers.size();
        if (count == 0) {
            this.removeVirtual();
        } else if (count < this.strategy.getMinMarkersCount()) {
            this.removeVirtual();
            for (DelegatingMarker m : this.markers) {
                m.changeVisible(true);
            }
        } else {
            for (DelegatingMarker m : this.markers) {
                m.changeVisible(false);
            }
            LatLng position = this.calculateClusterPosition();
            if (this.virtual == null || this.lastCount != count) {
                this.removeVirtual();
                this.lastCount = count;
                this.virtual = this.strategy.createMarker(new ArrayList<Marker>(this.markers), position);
            } else {
                this.virtual.setPosition(position);
            }
        }
    }

    private LatLng calculateClusterPosition() {
        LatLngBounds.Builder builder = LatLngBounds.builder();
        for (DelegatingMarker m : this.markers) {
            builder.include(m.getPosition());
        }
        return builder.build().getCenter();
    }

    List<? extends Marker> getDisplayedMarkers() {
        int count = this.markers.size();
        if (count == 0) {
            return null;
        }
        if (count < this.strategy.getMinMarkersCount()) {
            return this.markers;
        }
        return Collections.singletonList(this);
    }

    void removeVirtual() {
        if (this.virtual != null) {
            this.virtual.remove();
            this.virtual = null;
        }
    }

    void cleanup() {
        if (this.virtual != null) {
            this.virtual.remove();
        }
    }

    List<DelegatingMarker> getMarkersInternal() {
        return new ArrayList<DelegatingMarker>(this.markers);
    }

    @Override
    public void animatePosition(LatLng target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void animatePosition(LatLng target, AnimationSettings settings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void animatePosition(LatLng target, Marker.AnimationCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void animatePosition(LatLng target, AnimationSettings settings, Marker.AnimationCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getAlpha() {
        if (this.virtual != null) {
            return this.virtual.getAlpha();
        }
        return 1.0f;
    }

    @Override
    public int getClusterGroup() {
        if (this.markers.size() > 0) {
            return this.markers.get(0).getClusterGroup();
        }
        throw new IllegalStateException();
    }

    public Object getData() {
        return null;
    }

    @Override
    @Deprecated
    public String getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Marker> getMarkers() {
        return new ArrayList<Marker>(this.markers);
    }

    @Override
    public LatLng getPosition() {
        if (this.virtual != null) {
            return this.virtual.getPosition();
        }
        LatLng position = this.calculateClusterPosition();
        return position;
    }

    @Override
    public float getRotation() {
        if (this.virtual != null) {
            return this.virtual.getRotation();
        }
        return 0.0f;
    }

    @Override
    public String getSnippet() {
        return null;
    }

    @Override
    @Deprecated
    public Object getTag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public float getZIndex() {
        if (this.virtual != null) {
            return this.virtual.getZIndex();
        }
        return 0.0f;
    }

    @Override
    public void hideInfoWindow() {
        if (this.virtual != null) {
            this.virtual.hideInfoWindow();
        }
    }

    @Override
    public boolean isCluster() {
        return true;
    }

    @Override
    public boolean isDraggable() {
        return false;
    }

    @Override
    public boolean isFlat() {
        if (this.virtual != null) {
            return this.virtual.isFlat();
        }
        return false;
    }

    @Override
    public boolean isInfoWindowShown() {
        if (this.virtual != null) {
            return this.virtual.isInfoWindowShown();
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        if (this.virtual != null) {
            return this.virtual.isVisible();
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(float alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAnchor(float anchorU, float anchorV) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClusterGroup(int clusterGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setData(Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDraggable(boolean draggable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlat(boolean flat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIcon(BitmapDescriptor icon) {
        if (this.virtual != null) {
            this.virtual.setIcon(icon);
        }
    }

    @Override
    public void setInfoWindowAnchor(float anchorU, float anchorV) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(LatLng position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRotation(float rotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSnippet(String snippet) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setTag(Object tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTitle(String title) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setZIndex(float zIndex) {
        if (this.virtual != null) {
            this.virtual.setZIndex(zIndex);
        }
    }

    @Override
    public void showInfoWindow() {
        if (this.virtual == null && this.markers.size() > 1) {
            this.refresh();
        }
        if (this.virtual != null) {
            this.virtual.showInfoWindow();
        }
    }
}

