/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.Circle;
import com.androidmapsextensions.CircleOptions;
import com.androidmapsextensions.GoogleMap;
import com.androidmapsextensions.impl.DelegatingCircle;
import com.androidmapsextensions.impl.IGoogleMap;
import com.google.android.gms.maps.GoogleMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CircleManager {
    private final IGoogleMap factory;
    private final Map<com.google.android.gms.maps.model.Circle, Circle> circles;

    public CircleManager(IGoogleMap factory) {
        this.factory = factory;
        this.circles = new HashMap<com.google.android.gms.maps.model.Circle, Circle>();
    }

    public Circle addCircle(CircleOptions circleOptions) {
        Circle circle = this.createCircle(circleOptions.real);
        circle.setData(circleOptions.getData());
        return circle;
    }

    private Circle createCircle(com.google.android.gms.maps.model.CircleOptions circleOptions) {
        com.google.android.gms.maps.model.Circle real = this.factory.addCircle(circleOptions);
        DelegatingCircle circle = new DelegatingCircle(real, this);
        this.circles.put(real, circle);
        return circle;
    }

    public void clear() {
        this.circles.clear();
    }

    public List<Circle> getCircles() {
        return new ArrayList<Circle>(this.circles.values());
    }

    public void onRemove(com.google.android.gms.maps.model.Circle real) {
        this.circles.remove(real);
    }

    public void setOnCircleClickListener(GoogleMap.OnCircleClickListener onCircleClickListener) {
        DelegatingOnCircleClickListener realOnCircleClickListener = null;
        if (onCircleClickListener != null) {
            realOnCircleClickListener = new DelegatingOnCircleClickListener(onCircleClickListener);
        }
        this.factory.setOnCircleClickListener(realOnCircleClickListener);
    }

    private class DelegatingOnCircleClickListener
    implements GoogleMap.OnCircleClickListener {
        private final GoogleMap.OnCircleClickListener onCircleClickListener;

        public DelegatingOnCircleClickListener(GoogleMap.OnCircleClickListener onCircleClickListener) {
            this.onCircleClickListener = onCircleClickListener;
        }

        public void onCircleClick(com.google.android.gms.maps.model.Circle circle) {
            this.onCircleClickListener.onCircleClick((Circle)CircleManager.this.circles.get(circle));
        }
    }
}

