/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions;

import android.content.Context;
import com.androidmapsextensions.GoogleMap;
import com.androidmapsextensions.OnMapReadyCallback;
import com.androidmapsextensions.impl.ExtendedMapFactory;
import java.lang.reflect.Method;

final class MapHolder {
    private final Delegate delegate;
    private GoogleMap map;

    public MapHolder(Delegate delegate) {
        this.delegate = delegate;
    }

    public GoogleMap getExtendedMap() {
        if (this.map == null) {
            try {
                Method getMapMethod = this.delegate.getClass().getMethod("getMap", new Class[0]);
                Object obj = getMapMethod.invoke((Object)this.delegate, new Object[0]);
                if (obj != null) {
                    com.google.android.gms.maps.GoogleMap realMap = (com.google.android.gms.maps.GoogleMap)obj;
                    this.map = ExtendedMapFactory.create(realMap, this.delegate.getContext());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.map;
    }

    public void getExtendedMapAsync(final OnMapReadyCallback callback) {
        if (this.map != null) {
            callback.onMapReady(this.map);
        } else {
            this.delegate.getMapAsync(new com.google.android.gms.maps.OnMapReadyCallback(){

                public void onMapReady(com.google.android.gms.maps.GoogleMap realMap) {
                    if (MapHolder.this.map == null) {
                        MapHolder.this.map = ExtendedMapFactory.create(realMap, MapHolder.this.delegate.getContext());
                    }
                    callback.onMapReady(MapHolder.this.map);
                }
            });
        }
    }

    public static interface Delegate {
        public void getMapAsync(com.google.android.gms.maps.OnMapReadyCallback var1);

        public Context getContext();
    }
}

