/*
 * Decompiled with CFR 0.152.
 */
package com.androidev.download;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.androidev.download.DownloadInfo;
import java.util.ArrayList;
import java.util.List;

class DownloadProvider {
    private DatabaseHelper helper;

    DownloadProvider(Context context) {
        this.helper = new DatabaseHelper(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insert(DownloadInfo info) {
        if (info == null) {
            return false;
        }
        Class<DownloadProvider> clazz = DownloadProvider.class;
        synchronized (DownloadProvider.class) {
            SQLiteDatabase database = this.helper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put("_key", info.key);
            contentValues.put("url", info.url);
            contentValues.put("name", info.name);
            contentValues.put("path", info.path);
            contentValues.put("source", info.source);
            contentValues.put("extras", info.extras);
            contentValues.put("downloadId", Long.valueOf(info.id));
            contentValues.put("createTime", Long.valueOf(info.createTime));
            contentValues.put("finishTime", Long.valueOf(info.finishTime));
            contentValues.put("contentLength", Long.valueOf(info.contentLength));
            contentValues.put("finishedLength", Long.valueOf(info.finishedLength));
            contentValues.put("state", Integer.valueOf(info.state));
            long result = database.insert("download", null, contentValues);
            database.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result != -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(DownloadInfo info) {
        if (info == null) {
            return false;
        }
        Class<DownloadProvider> clazz = DownloadProvider.class;
        synchronized (DownloadProvider.class) {
            SQLiteDatabase database = this.helper.getWritableDatabase();
            String whereClause = "_key=?";
            String[] whereArgs = new String[]{info.key};
            int result = database.delete("download", whereClause, whereArgs);
            database.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DownloadInfo> query() {
        Class<DownloadProvider> clazz = DownloadProvider.class;
        synchronized (DownloadProvider.class) {
            ArrayList<DownloadInfo> result = new ArrayList<DownloadInfo>();
            SQLiteDatabase database = this.helper.getReadableDatabase();
            String sql = "select * from download order by createTime desc";
            Cursor cursor = database.rawQuery(sql, null);
            if (cursor == null) {
                database.close();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            int index_key = cursor.getColumnIndex("_key");
            int index_url = cursor.getColumnIndex("url");
            int index_name = cursor.getColumnIndex("name");
            int index_path = cursor.getColumnIndex("path");
            int index_from = cursor.getColumnIndex("source");
            int index_extras = cursor.getColumnIndex("extras");
            int index_download_id = cursor.getColumnIndex("downloadId");
            int index_create_time = cursor.getColumnIndex("createTime");
            int index_finish_time = cursor.getColumnIndex("finishTime");
            int index_content_length = cursor.getColumnIndex("contentLength");
            int index_finished_length = cursor.getColumnIndex("finishedLength");
            int index_state = cursor.getColumnIndex("state");
            while (cursor.moveToNext()) {
                DownloadInfo info = new DownloadInfo();
                info.key = cursor.getString(index_key);
                info.url = cursor.getString(index_url);
                info.name = cursor.getString(index_name);
                info.path = cursor.getString(index_path);
                info.source = cursor.getString(index_from);
                info.extras = cursor.getString(index_extras);
                info.id = cursor.getLong(index_download_id);
                info.createTime = cursor.getLong(index_create_time);
                info.finishTime = cursor.getLong(index_finish_time);
                info.contentLength = cursor.getLong(index_content_length);
                info.finishedLength = cursor.getLong(index_finished_length);
                info.state = cursor.getInt(index_state);
                result.add(info);
            }
            cursor.close();
            database.close();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update(DownloadInfo info) {
        if (info == null) {
            return false;
        }
        Class<DownloadProvider> clazz = DownloadProvider.class;
        synchronized (DownloadProvider.class) {
            SQLiteDatabase database = this.helper.getReadableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put("_key", info.key);
            contentValues.put("url", info.url);
            contentValues.put("name", info.name);
            contentValues.put("path", info.path);
            contentValues.put("source", info.source);
            contentValues.put("extras", info.extras);
            contentValues.put("downloadId", Long.valueOf(info.id));
            contentValues.put("createTime", Long.valueOf(info.createTime));
            contentValues.put("finishTime", Long.valueOf(info.finishTime));
            contentValues.put("contentLength", Long.valueOf(info.contentLength));
            contentValues.put("finishedLength", Long.valueOf(info.finishedLength));
            contentValues.put("state", Integer.valueOf(info.state));
            String whereClause = "_key=?";
            String[] whereArgs = new String[]{info.key};
            int result = database.update("download", contentValues, whereClause, whereArgs);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(DownloadInfo info) {
        if (info == null) {
            return false;
        }
        Class<DownloadProvider> clazz = DownloadProvider.class;
        synchronized (DownloadProvider.class) {
            SQLiteDatabase database = this.helper.getReadableDatabase();
            String sql = "select count(_key) from download where _key=?";
            String[] whereArgs = new String[]{info.key};
            Cursor cursor = database.rawQuery(sql, whereArgs);
            int result = 0;
            if (cursor != null && cursor.moveToFirst()) {
                result = cursor.getInt(0);
                cursor.close();
            }
            database.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result != 0;
        }
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        static final String COLUMN_ID = "_id";
        static final String COLUMN_KEY = "_key";
        static final String COLUMN_URL = "url";
        static final String COLUMN_NAME = "name";
        static final String COLUMN_PATH = "path";
        static final String COLUMN_SOURCE = "source";
        static final String COLUMN_EXTRAS = "extras";
        static final String COLUMN_CREATE_TIME = "createTime";
        static final String COLUMN_FINISH_TIME = "finishTime";
        static final String COLUMN_DOWNLOAD_ID = "downloadId";
        static final String COLUMN_CONTENT_LENGTH = "contentLength";
        static final String COLUMN_FINISHED_LENGTH = "finishedLength";
        static final String COLUMN_STATE = "state";
        private static final String DB_NAME = "download";
        private static final String TABLE_NAME = "download";
        private static final int DB_VERSION = 1;

        DatabaseHelper(Context context) {
            super(context, "download", null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            this.createTable(db);
        }

        private void createTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE IF NOT EXISTS download(_id INTEGER PRIMARY KEY AUTOINCREMENT, _key TEXT, url TEXT UNIQUE NOT NULL, name TEXT NOT NULL, path TEXT, source TEXT, extras TEXT, createTime INTEGER, finishTime INTEGER, downloadId INTEGER, contentLength INTEGER, finishedLength INTEGER, state INTEGER)");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE download");
            this.createTable(db);
        }
    }
}

