/*
 * Decompiled with CFR 0.152.
 */
package com.androidev.download;

import android.content.Context;
import com.androidev.download.DownloadEngine;
import com.androidev.download.DownloadInfo;
import com.androidev.download.DownloadJobListener;
import com.androidev.download.DownloadListener;
import com.androidev.download.DownloadNotifier;
import com.androidev.download.DownloadTask;
import java.util.List;
import junit.framework.Assert;

public class DownloadManager {
    public static final String INTENT_ACTION_DOWNLOAD = "com.androidev.download";
    private DownloadEngine engine;

    private DownloadManager() {
    }

    public void initialize(Context context, int masTask) {
        this.engine = new DownloadEngine(masTask);
        this.engine.initialize(context);
    }

    public static DownloadManager getInstance() {
        return DownloadManagerHolder.instance;
    }

    public void destroy() {
        Assert.assertNotNull((Object)this.engine);
        this.engine.destroy();
        this.engine = null;
    }

    public DownloadTask.Builder newTask(long id, String url, String name) {
        Assert.assertNotNull((Object)this.engine);
        return new DownloadTask.Builder(this.engine).id(id).url(url).name(name);
    }

    public DownloadTask createTask(DownloadInfo info, DownloadListener listener) {
        return new DownloadTask(this.engine, info, listener);
    }

    public void addInterceptor(Interceptor interceptor) {
        Assert.assertNotNull((Object)this.engine);
        this.engine.addInterceptor(interceptor);
    }

    public void addDownloadJobListener(DownloadJobListener downloadJobListener) {
        Assert.assertNotNull((Object)this.engine);
        this.engine.addDownloadJobListener(downloadJobListener);
    }

    public void removeDownloadJobListener(DownloadJobListener downloadJobListener) {
        Assert.assertNotNull((Object)this.engine);
        this.engine.removeDownloadJobListener(downloadJobListener);
    }

    public void setDownloadNotifier(DownloadNotifier downloadNotifier) {
        Assert.assertNotNull((Object)this.engine);
        this.engine.setDownloadNotifier(downloadNotifier);
    }

    public List<DownloadTask> getAllTasks() {
        Assert.assertNotNull((Object)this.engine);
        return this.engine.getAllTasks();
    }

    public List<DownloadInfo> getAllInfo() {
        return this.engine.getAllInfo();
    }

    public void delete(DownloadInfo info) {
        Assert.assertNotNull((Object)this.engine);
        this.engine.delete(info);
    }

    public boolean isActive() {
        Assert.assertNotNull((Object)this.engine);
        return this.engine.isActive();
    }

    public static interface Interceptor {
        public void updateDownloadInfo(DownloadInfo var1);
    }

    private static class DownloadManagerHolder {
        private static DownloadManager instance = new DownloadManager();

        private DownloadManagerHolder() {
        }
    }
}

