/*
 * Decompiled with CFR 0.152.
 */
package com.androidev.download;

import com.androidev.download.DownloadEngine;
import com.androidev.download.DownloadInfo;
import com.androidev.download.DownloadListener;
import com.androidev.download.DownloadManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class DownloadJob
implements Runnable {
    private static final int MIN_READ_STEP = 8192;
    private static final int MIN_STORE_STEP = 131072;
    private boolean isPaused;
    private boolean isDeleted;
    private DownloadEngine engine;
    private List<DownloadListener> listeners;
    DownloadInfo info;
    private Runnable changeState = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<DownloadJob> clazz = DownloadJob.class;
            synchronized (DownloadJob.class) {
                for (DownloadListener listener : DownloadJob.this.listeners) {
                    listener.onStateChanged(DownloadJob.this.info.key, DownloadJob.this.info.state);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                switch (DownloadJob.this.info.state) {
                    case 1: {
                        DownloadJob.this.engine.onJobStarted(DownloadJob.this.info);
                        break;
                    }
                    case 2: {
                        DownloadJob.this.engine.onJobCompleted(true, DownloadJob.this.info);
                        DownloadJob.this.clear();
                        break;
                    }
                    case 3: 
                    case 4: {
                        DownloadJob.this.engine.onJobCompleted(false, DownloadJob.this.info);
                    }
                }
                return;
            }
        }
    };
    private Runnable changeProgress = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<DownloadJob> clazz = DownloadJob.class;
            synchronized (DownloadJob.class) {
                for (DownloadListener listener : DownloadJob.this.listeners) {
                    listener.onProgressChanged(DownloadJob.this.info.key, DownloadJob.this.info.finishedLength, DownloadJob.this.info.contentLength);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    };

    DownloadJob(DownloadEngine engine, DownloadInfo info) {
        this.engine = engine;
        this.info = info;
        this.listeners = new ArrayList<DownloadListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(DownloadListener listener) {
        Class<DownloadJob> clazz = DownloadJob.class;
        synchronized (DownloadJob.class) {
            if (listener == null || this.listeners.contains(listener)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            listener.onStateChanged(this.info.key, this.info.state);
            this.listeners.add(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(DownloadListener listener) {
        Class<DownloadJob> clazz = DownloadJob.class;
        synchronized (DownloadJob.class) {
            if (listener == null || !this.listeners.contains(listener)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.listeners.remove(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    boolean isRunning() {
        return 1 == this.info.state;
    }

    void enqueue() {
        this.resume();
    }

    void pause() {
        this.isPaused = true;
        if (this.info.state != 5) {
            return;
        }
        this.onStateChanged(4, false);
    }

    void delete() {
        this.isDeleted = true;
    }

    void resume() {
        if (this.isRunning()) {
            return;
        }
        this.onStateChanged(5, false);
        this.isPaused = false;
        this.engine.executor.submit(this);
    }

    private void clear() {
        this.listeners.clear();
        this.engine = null;
        this.info = null;
    }

    private void onStateChanged(int state, boolean updateDb) {
        this.info.state = state;
        if (updateDb) {
            this.engine.provider.update(this.info);
        }
        this.engine.handler.removeCallbacks(this.changeState);
        this.engine.handler.post(this.changeState);
    }

    private void onProgressChanged(long finishedLength, long contentLength) {
        this.info.finishedLength = finishedLength;
        this.info.contentLength = contentLength;
        this.engine.handler.removeCallbacks(this.changeProgress);
        this.engine.handler.post(this.changeProgress);
    }

    private boolean prepare() {
        if (this.isDeleted) {
            this.clear();
            return false;
        }
        if (this.isPaused) {
            this.onStateChanged(4, false);
            if (!this.engine.provider.exists(this.info)) {
                this.engine.provider.insert(this.info);
            } else {
                this.engine.provider.update(this.info);
            }
            return false;
        }
        this.onStateChanged(1, false);
        this.onProgressChanged(this.info.finishedLength, this.info.contentLength);
        if (this.engine.interceptors != null) {
            for (DownloadManager.Interceptor interceptor : this.engine.interceptors) {
                interceptor.updateDownloadInfo(this.info);
            }
        }
        if (!this.engine.provider.exists(this.info)) {
            this.engine.provider.insert(this.info);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.prepare()) {
            return;
        }
        long finishedLength = this.info.finishedLength;
        long contentLength = this.info.contentLength;
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        RandomAccessFile randomAccessFile = null;
        try {
            connection = (HttpURLConnection)new URL(this.info.url).openConnection();
            connection.setAllowUserInteraction(true);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("GET");
            if (finishedLength != 0L && contentLength > 0L) {
                connection.setRequestProperty("Range", "bytes=" + finishedLength + "-" + contentLength);
            } else {
                contentLength = connection.getContentLength();
                if (contentLength == -1L) {
                    contentLength = Long.parseLong(connection.getHeaderField("Content-Length"));
                }
            }
            int responseCode = connection.getResponseCode();
            if (contentLength > 0L && (responseCode == 200 || responseCode == 206)) {
                int len;
                inputStream = connection.getInputStream();
                File file = new File(this.info.path);
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(finishedLength);
                byte[] buffer = new byte[8192];
                int buck = 0;
                long bytesRead = finishedLength;
                while (!this.isDeleted && !this.isPaused && (len = inputStream.read(buffer)) != -1) {
                    randomAccessFile.write(buffer, 0, len);
                    finishedLength = bytesRead += (long)len;
                    this.onProgressChanged(finishedLength, contentLength);
                    if ((buck += len) < 131072) continue;
                    buck = 0;
                    randomAccessFile.getFD().sync();
                    this.engine.provider.update(this.info);
                }
                connection.disconnect();
                if (this.isDeleted) {
                    this.clear();
                } else if (this.isPaused) {
                    this.onStateChanged(4, true);
                } else {
                    this.info.finishTime = System.currentTimeMillis();
                    this.onStateChanged(2, true);
                }
            } else {
                this.onStateChanged(3, true);
            }
        }
        catch (Exception e) {
            this.onStateChanged(3, true);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

