/*
 * Decompiled with CFR 0.152.
 */
package com.androidev.download;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.androidev.download.DownloadInfo;
import com.androidev.download.DownloadJob;
import com.androidev.download.DownloadJobListener;
import com.androidev.download.DownloadManager;
import com.androidev.download.DownloadNotifier;
import com.androidev.download.DownloadProvider;
import com.androidev.download.DownloadTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DownloadEngine {
    private static final String TAG = "DownloadEngine";
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int KEEP_ALIVE = 10;
    private List<DownloadJobListener> downloadJobListeners;
    private Map<String, DownloadJob> jobs;
    private Map<String, DownloadInfo> infos;
    private List<DownloadInfo> activeInfos;
    private DownloadNotifier notifier;
    private Runnable updateNotificationRunnable = new Runnable(){

        @Override
        public void run() {
            DownloadEngine.this.notifier.notify(DownloadEngine.this.activeInfos);
        }
    };
    List<DownloadManager.Interceptor> interceptors;
    ThreadPoolExecutor executor;
    DownloadProvider provider;
    Handler handler;

    DownloadEngine(int maxTask) {
        this.jobs = new HashMap<String, DownloadJob>();
        this.infos = new HashMap<String, DownloadInfo>();
        this.activeInfos = new ArrayList<DownloadInfo>();
        this.interceptors = new ArrayList<DownloadManager.Interceptor>();
        this.downloadJobListeners = new ArrayList<DownloadJobListener>();
        this.handler = new Handler(Looper.getMainLooper());
        if (maxTask > CORE_POOL_SIZE) {
            maxTask = CORE_POOL_SIZE;
        }
        this.executor = new ThreadPoolExecutor(maxTask, maxTask, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.executor.allowCoreThreadTimeOut(true);
    }

    void initialize(Context context) {
        this.provider = new DownloadProvider(context.getApplicationContext());
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                List<DownloadInfo> list = DownloadEngine.this.provider.query();
                for (DownloadInfo info : list) {
                    if (1 == info.state) {
                        info.state = 4;
                    }
                    DownloadEngine.this.infos.put(info.key, info);
                    if (info.isFinished()) continue;
                    DownloadEngine.this.jobs.put(info.key, new DownloadJob(DownloadEngine.this, info));
                }
            }
        });
    }

    void destroy() {
        this.executor.shutdown();
        this.interceptors.clear();
        this.downloadJobListeners.clear();
    }

    List<DownloadTask> getAllTasks() {
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>();
        for (DownloadJob job : this.jobs.values()) {
            tasks.add(new DownloadTask(this, job.info, null));
        }
        Collections.sort(tasks);
        return tasks;
    }

    List<DownloadInfo> getAllInfo() {
        ArrayList<DownloadInfo> result = new ArrayList<DownloadInfo>(this.infos.values());
        Collections.sort(result);
        return result;
    }

    boolean isActive() {
        return this.activeInfos.size() > 0;
    }

    void addInterceptor(DownloadManager.Interceptor interceptor) {
        if (interceptor == null || this.interceptors.contains(interceptor)) {
            return;
        }
        this.interceptors.add(interceptor);
    }

    void addDownloadJobListener(DownloadJobListener downloadJobListener) {
        if (downloadJobListener == null || this.downloadJobListeners.contains(downloadJobListener)) {
            return;
        }
        this.downloadJobListeners.add(downloadJobListener);
    }

    void removeDownloadJobListener(DownloadJobListener downloadJobListener) {
        if (downloadJobListener == null || !this.downloadJobListeners.contains(downloadJobListener)) {
            return;
        }
        this.downloadJobListeners.remove(downloadJobListener);
    }

    void setDownloadNotifier(DownloadNotifier notifier) {
        this.notifier = notifier;
        if (notifier != null) {
            notifier.notify(this.activeInfos);
        }
    }

    void prepare(DownloadTask task) {
        String key = task.key;
        if (!this.infos.containsKey(key)) {
            if (task.listener == null) {
                return;
            }
            task.listener.onStateChanged(key, 0);
            return;
        }
        DownloadInfo info = this.infos.get(key);
        task.size = info.contentLength;
        task.createTime = info.createTime;
        if (!this.jobs.containsKey(key)) {
            if (task.listener == null) {
                return;
            }
            task.listener.onStateChanged(key, info.state);
        } else {
            this.jobs.get(key).addListener(task.listener);
        }
    }

    void enqueue(DownloadTask task) {
        String key = task.key;
        if (this.jobs.containsKey(key)) {
            DownloadJob job = this.jobs.get(key);
            if (job.isRunning()) {
                return;
            }
            job.enqueue();
            this.activeInfos.add(job.info);
        } else {
            if (this.infos.containsKey(key)) {
                return;
            }
            DownloadInfo info = task.generateInfo();
            DownloadJob job = new DownloadJob(this, info);
            this.infos.put(key, info);
            this.jobs.put(key, job);
            this.onJobCreated(info);
            job.addListener(task.listener);
            job.enqueue();
            this.activeInfos.add(info);
        }
        this.updateNotification();
    }

    void delete(DownloadTask task) {
        String key = task.key;
        if (!this.jobs.containsKey(key)) {
            return;
        }
        DownloadInfo info = this.infos.get(key);
        DownloadJob job = this.jobs.remove(key);
        job.delete();
        this.delete(info);
        if (!this.activeInfos.contains(info)) {
            return;
        }
        this.activeInfos.remove(info);
        this.updateNotification();
    }

    void pause(DownloadTask task) {
        String key = task.key;
        if (!this.jobs.containsKey(key)) {
            return;
        }
        this.jobs.get(key).pause();
    }

    void resume(DownloadTask task) {
        String key = task.key;
        if (!this.jobs.containsKey(key)) {
            return;
        }
        DownloadJob job = this.jobs.get(key);
        if (job.isRunning()) {
            return;
        }
        job.resume();
        this.activeInfos.add(job.info);
        this.updateNotification();
    }

    void delete(final DownloadInfo info) {
        if (info == null || !this.infos.containsValue(info)) {
            return;
        }
        this.infos.remove(info.key);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                DownloadEngine.this.provider.delete(info);
                File file = new File(info.path);
                if (file.exists() && !file.delete()) {
                    Log.w((String)DownloadEngine.TAG, (String)("can not delete file: " + file.getPath()));
                }
            }
        });
    }

    void addListener(DownloadTask task) {
        String key = task.key;
        if (!this.infos.containsKey(key)) {
            if (task.listener == null) {
                return;
            }
            task.listener.onStateChanged(key, 0);
        } else if (!this.jobs.containsKey(key)) {
            if (task.listener == null) {
                return;
            }
            task.listener.onStateChanged(key, 2);
        } else {
            this.jobs.get(key).addListener(task.listener);
        }
    }

    void removeListener(DownloadTask task) {
        String key = task.key;
        if (!this.jobs.containsKey(key)) {
            return;
        }
        this.jobs.get(key).removeListener(task.listener);
    }

    private void onJobCreated(DownloadInfo info) {
        for (DownloadJobListener downloadJobListener : this.downloadJobListeners) {
            downloadJobListener.onCreated(info);
        }
    }

    void onJobStarted(DownloadInfo info) {
        this.updateNotification();
        for (DownloadJobListener downloadJobListener : this.downloadJobListeners) {
            downloadJobListener.onStarted(info);
        }
    }

    void onJobCompleted(boolean finished, DownloadInfo info) {
        String key = info.key;
        this.activeInfos.remove(info);
        this.updateNotification();
        if (finished) {
            this.jobs.remove(key);
        }
        for (DownloadJobListener downloadJobListener : this.downloadJobListeners) {
            downloadJobListener.onCompleted(finished, info);
        }
    }

    private void updateNotification() {
        if (this.notifier == null) {
            return;
        }
        this.handler.removeCallbacks(this.updateNotificationRunnable);
        this.handler.postDelayed(this.updateNotificationRunnable, 100L);
    }
}

