/*
 * Decompiled with CFR 0.152.
 */
package com.androidev.download;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import com.androidev.download.DownloadInfo;
import com.androidev.download.DownloadNotifier;
import com.androidev.download.R;
import java.util.List;

public class DefaultNotifier
implements DownloadNotifier {
    private Context context;
    private NotificationManager notificationManager;
    private static final int NOTIFY_ID = 10000;
    private static final int REQUEST_CODE = 100;

    public DefaultNotifier(Context context) {
        this.context = context;
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    @Override
    public void notify(List<DownloadInfo> infos) {
        int activeCount = infos.size();
        if (activeCount == 0) {
            this.notificationManager.cancel(10000);
        } else {
            Notification.Builder builder = new Notification.Builder(this.context);
            Intent intent = new Intent();
            intent.setAction("com.androidev.download");
            PendingIntent downloadIntent = PendingIntent.getActivity((Context)this.context, (int)100, (Intent)intent, (int)0x10000000);
            Resources resources = this.context.getResources();
            String title = resources.getString(R.string.download_notification_title);
            String summary = resources.getString(R.string.download_notification_summary, new Object[]{activeCount});
            builder.setSmallIcon(R.drawable.notify_download).setPriority(2).setContentTitle((CharSequence)title).setContentText((CharSequence)summary).setWhen(System.currentTimeMillis()).setContentIntent(downloadIntent).setOngoing(true);
            Notification.InboxStyle style = new Notification.InboxStyle();
            style.setBigContentTitle((CharSequence)title);
            style.setSummaryText((CharSequence)summary);
            for (DownloadInfo info : infos) {
                if (info.state != 1) continue;
                style.addLine((CharSequence)info.name);
            }
            builder.setStyle((Notification.Style)style);
            this.notificationManager.notify(10000, builder.build());
        }
    }
}

