/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Location;
import com.android.zipflinger.Source;

public class Zip64 {
    static final short EXTRA_ID = 1;
    static final long LONG_MAGIC = 0xFFFFFFFFL;
    static final int INT_MAGIC = -1;
    static final int SHORT_MAGIC = -1;
    static final short VERSION_NEEDED = 45;

    public static boolean needZip64Footer(long numEntries, Location cdLocation) {
        return numEntries > 65535L || cdLocation.first > 0xFFFFFFFFL || cdLocation.size() > 0xFFFFFFFFL;
    }

    static void checkFooterPolicy(Policy policy, long numEntries, Location cdLocation) {
        if (policy == Policy.ALLOW) {
            return;
        }
        if (numEntries > 65535L) {
            String msg = String.format("Too many zip entries %d (MAX=%d)", numEntries, 65535L);
            throw new IllegalStateException(msg);
        }
        if (cdLocation.first > 0xFFFFFFFFL) {
            String msg = String.format("Zip32 cannot place Central directory at offset %d (MAX=%d)", cdLocation.first, 0xFFFFFFFFL);
            throw new IllegalStateException(msg);
        }
        if (cdLocation.size() > 0xFFFFFFFFL) {
            String msg = String.format("Zip32 cannot write Central Directory of size %d (MAX=%d)", cdLocation.size(), 0xFFFFFFFFL);
            throw new IllegalStateException(msg);
        }
    }

    static void checkEntryPolicy(Policy policy, Source source, Location cdloc, Location payloadLoc) {
        if (policy == Policy.ALLOW) {
            return;
        }
        if (source.getUncompressedSize() > 0xFFFFFFFFL) {
            String msg = String.format("Zip32 cannot handle entry '%s' compressed size %d (MAX=%d)", source.getName(), source.getUncompressedSize(), 0xFFFFFFFFL);
            throw new IllegalStateException(msg);
        }
        if (source.getCompressedSize() > 0xFFFFFFFFL) {
            String msg = String.format("Zip32 cannot handle entry '%s' size %d (MAX=%d)", source.getName(), source.getCompressedSize(), 0xFFFFFFFFL);
            throw new IllegalStateException(msg);
        }
        if (cdloc.first > 0xFFFFFFFFL) {
            String msg = String.format("Zip32 cannot place CD entry '%s' payload at %d (MAX=%d)", source.getName(), cdloc.first, 0xFFFFFFFFL);
            throw new IllegalStateException(msg);
        }
        if (payloadLoc.first > 0xFFFFFFFFL) {
            String msg = String.format("Zip32 cannot place entry '%s' payload at %d (MAX=%d)", source.getName(), payloadLoc.first, 0xFFFFFFFFL);
            throw new IllegalStateException(msg);
        }
    }

    private Zip64() {
    }

    public static enum Policy {
        ALLOW,
        FORBID;

    }
}

