/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Ints;
import com.android.zipflinger.Location;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class EndOfCentralDirectory {
    public static final int SIGNATURE = 101010256;
    public static final int SIZE = 22;

    EndOfCentralDirectory() {
    }

    public static Location parse(ByteBuffer buffer, Location cdLocation) {
        buffer.position(Math.toIntExact(cdLocation.first + 12L));
        long cdSize = Ints.uintToLong(buffer.getInt());
        long cdOffset = Ints.uintToLong(buffer.getInt());
        return new Location(cdOffset, cdSize);
    }

    public static Location write(ZipWriter writer, Location cdLocation, long numEntries) throws IOException {
        ByteBuffer eocd = ByteBuffer.allocate(22).order(ByteOrder.LITTLE_ENDIAN);
        eocd.putInt(101010256);
        eocd.putShort((short)0);
        eocd.putShort((short)0);
        eocd.putShort(Ints.longToUshort(numEntries));
        eocd.putShort(Ints.longToUshort(numEntries));
        eocd.putInt(Ints.longToUint(cdLocation.size()));
        eocd.putInt(Ints.longToUint(cdLocation.first));
        eocd.putShort((short)0);
        eocd.rewind();
        writer.write(eocd);
        return new Location(cdLocation.last + 1L, eocd.capacity());
    }
}

