/*
 * Decompiled with CFR 0.152.
 */
package com.permission.kit;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.permission.kit.AppGlobals;
import com.permission.kit.MainHandler;
import com.permission.kit.PermissionConstants;
import com.permission.kit.PermissionKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0005\u001f !\"#B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\tJ\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/permission/kit/PermissionKit;", "", "permissions", "", "", "([Ljava/lang/String;)V", "mFullCallback", "Lcom/permission/kit/PermissionKit$FullCallback;", "mOnRationaleListener", "Lcom/permission/kit/PermissionKit$OnRationaleListener;", "mPermissions", "Ljava/util/LinkedHashSet;", "mPermissionsDenied", "", "mPermissionsDeniedForever", "mPermissionsGranted", "mPermissionsRequest", "mSimpleCallback", "Lcom/permission/kit/PermissionKit$SimpleCallback;", "callback", "getPermissionsStatus", "", "activity", "Landroid/app/Activity;", "onRequestPermissionsResult", "rationale", "", "listener", "request", "requestCallback", "startPermissionActivity", "Companion", "FullCallback", "OnRationaleListener", "PermissionActivity", "SimpleCallback", "permission-kit_release"})
public final class PermissionKit {
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private final LinkedHashSet<String> mPermissions = new LinkedHashSet();
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;
    private static PermissionKit sInstance;
    private static final Application sApplication;
    private static final List<String> MANIFEST_PERMISSIONS;
    private static SimpleCallback sSimpleCallback4WriteSettings;
    private static SimpleCallback sSimpleCallback4DrawOverlays;
    public static final Companion Companion;

    @NotNull
    public final PermissionKit callback(@Nullable SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    @NotNull
    public final PermissionKit callback(@Nullable FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    @NotNull
    public final PermissionKit rationale(@Nullable OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public final void request() {
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll((Collection<String>)this.mPermissions);
            this.requestCallback();
        } else {
            Iterator iterator = this.mPermissions.iterator();
            while (iterator.hasNext()) {
                String permission;
                String string = permission = (String)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"permission");
                if (PermissionKit.Companion.isGranted(string)) {
                    this.mPermissionsGranted.add(permission);
                    continue;
                }
                this.mPermissionsRequest.add(permission);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private final void startPermissionActivity() {
        this.mPermissionsDenied = new ArrayList();
        this.mPermissionsDeniedForever = new ArrayList();
        Context context = sApplication.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"sApplication.applicationContext");
        PermissionActivity.Companion.start(context, 1);
    }

    @RequiresApi(api=23)
    private final boolean rationale(Activity activity) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission : this.mPermissionsRequest) {
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
                this.getPermissionsStatus(activity);
                OnRationaleListener onRationaleListener = this.mOnRationaleListener;
                if (onRationaleListener == null) {
                    Intrinsics.throwNpe();
                }
                onRationaleListener.rationale(new OnRationaleListener.ShouldRequest(this, activity){
                    final /* synthetic */ PermissionKit this$0;
                    final /* synthetic */ Activity $activity;

                    public void again(boolean again) {
                        this.$activity.finish();
                        if (again) {
                            PermissionKit.access$startPermissionActivity(this.this$0);
                        } else {
                            PermissionKit.access$requestCallback(this.this$0);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$activity = $captured_local_variable$1;
                    }
                });
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private final void getPermissionsStatus(Activity activity) {
        for (String permission : this.mPermissionsRequest) {
            if (PermissionKit.Companion.isGranted(permission)) {
                this.mPermissionsGranted.add(permission);
                continue;
            }
            this.mPermissionsDenied.add(permission);
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
            this.mPermissionsDeniedForever.add(permission);
        }
    }

    private final void requestCallback() {
        boolean bl;
        Collection collection;
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                SimpleCallback simpleCallback = this.mSimpleCallback;
                if (simpleCallback == null) {
                    Intrinsics.throwNpe();
                }
                simpleCallback.onGranted();
            } else {
                collection = this.mPermissionsDenied;
                bl = false;
                if (!collection.isEmpty()) {
                    SimpleCallback simpleCallback = this.mSimpleCallback;
                    if (simpleCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    simpleCallback.onDenied();
                }
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                FullCallback fullCallback = this.mFullCallback;
                if (fullCallback == null) {
                    Intrinsics.throwNpe();
                }
                fullCallback.onGranted(this.mPermissionsGranted);
            } else {
                collection = this.mPermissionsDenied;
                bl = false;
                if (!collection.isEmpty()) {
                    FullCallback fullCallback = this.mFullCallback;
                    if (fullCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    fullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
                }
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
    }

    private final void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    private PermissionKit(String ... permissions) {
        List list;
        PermissionKit permissionKit = this;
        boolean bl = false;
        permissionKit.mPermissionsRequest = list = (List)new ArrayList();
        permissionKit = this;
        bl = false;
        permissionKit.mPermissionsGranted = list = (List)new ArrayList();
        permissionKit = this;
        bl = false;
        permissionKit.mPermissionsDenied = list = (List)new ArrayList();
        permissionKit = this;
        bl = false;
        permissionKit.mPermissionsDeniedForever = list = (List)new ArrayList();
        for (String permission : permissions) {
            for (String singlePermission : PermissionConstants.INSTANCE.getPermissions(permission)) {
                if (!MANIFEST_PERMISSIONS.contains(singlePermission)) continue;
                this.mPermissions.add(singlePermission);
            }
        }
        sInstance = this;
    }

    static {
        Companion = new Companion(null);
        Application application = AppGlobals.INSTANCE.get();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        sApplication = application;
        String string = sApplication.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sApplication.packageName");
        MANIFEST_PERMISSIONS = Companion.getPermissions(string);
    }

    public static final /* synthetic */ void access$setSInstance$cp(PermissionKit permissionKit) {
        sInstance = permissionKit;
    }

    public static final /* synthetic */ void access$setMPermissionsRequest$p(PermissionKit $this, List list) {
        $this.mPermissionsRequest = list;
    }

    public static final /* synthetic */ void access$startPermissionActivity(PermissionKit $this) {
        $this.startPermissionActivity();
    }

    public static final /* synthetic */ void access$requestCallback(PermissionKit $this) {
        $this.requestCallback();
    }

    public /* synthetic */ PermissionKit(String[] permissions,  /* corrupt varargs signature?! */ DefaultConstructorMarkerDefaultConstructorMarker $constructor_marker) {
        this(permissions);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J+\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/permission/kit/PermissionKit$PermissionActivity;", "Landroid/app/Activity;", "()V", "onActivityResult", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "Companion", "permission-kit_release"})
    @RequiresApi(api=23)
    public static final class PermissionActivity
    extends Activity {
        private static final String TYPE = "TYPE";
        public static final int TYPE_RUNTIME = 1;
        public static final int TYPE_WRITE_SETTINGS = 2;
        public static final int TYPE_DRAW_OVERLAYS = 3;
        public static final Companion Companion = new Companion(null);
        private HashMap _$_findViewCache;

        /*
         * WARNING - void declaration
         */
        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.getWindow().addFlags(262160);
            int byteExtra = this.getIntent().getIntExtra(TYPE, 1);
            if (byteExtra == 1) {
                if (sInstance == null) {
                    Log.e((String)"PermissionKit", (String)"request permissions failed");
                    this.finish();
                    return;
                }
                PermissionKit permissionKit = sInstance;
                if (permissionKit == null) {
                    Intrinsics.throwNpe();
                }
                if (permissionKit.rationale(this)) {
                    return;
                }
                PermissionKit permissionKit2 = sInstance;
                if (permissionKit2 == null) {
                    Intrinsics.throwNpe();
                }
                if (permissionKit2.mPermissionsRequest != null) {
                    void $this$toTypedArray$iv;
                    int size;
                    PermissionKit permissionKit3 = sInstance;
                    if (permissionKit3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((size = permissionKit3.mPermissionsRequest.size()) <= 0) {
                        this.finish();
                        return;
                    }
                    PermissionKit permissionKit4 = sInstance;
                    if (permissionKit4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Collection collection = permissionKit4.mPermissionsRequest;
                    PermissionActivity permissionActivity = this;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] stringArray2 = stringArray;
                    permissionActivity.requestPermissions(stringArray2, 1);
                }
            } else if (byteExtra == 2) {
                Companion.startWriteSettingsActivity(this, 2);
            } else if (byteExtra == 3) {
                Companion.startOverlayPermissionActivity(this, 3);
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
            Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
            Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
            if (sInstance != null) {
                PermissionKit permissionKit = sInstance;
                if (permissionKit == null) {
                    Intrinsics.throwNpe();
                }
                permissionKit.onRequestPermissionsResult(this);
            }
            this.finish();
        }

        protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            super.onActivityResult(requestCode, resultCode, data);
            if (requestCode == 2) {
                if (sSimpleCallback4WriteSettings == null) {
                    return;
                }
                if (Companion.isGrantedWriteSettings()) {
                    SimpleCallback simpleCallback = sSimpleCallback4WriteSettings;
                    if (simpleCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    simpleCallback.onGranted();
                } else {
                    SimpleCallback simpleCallback = sSimpleCallback4WriteSettings;
                    if (simpleCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    simpleCallback.onDenied();
                }
                sSimpleCallback4WriteSettings = null;
            } else if (requestCode == 3) {
                if (sSimpleCallback4DrawOverlays == null) {
                    return;
                }
                MainHandler.INSTANCE.postDelay(100L, onActivityResult.1.INSTANCE);
            }
            this.finish();
        }

        public View _$_findCachedViewById(int n) {
            View view;
            if (this._$_findViewCache == null) {
                this._$_findViewCache = new HashMap();
            }
            if ((view = (View)this._$_findViewCache.get(n)) == null) {
                view = this.findViewById(n);
                this._$_findViewCache.put(n, view);
            }
            return view;
        }

        public void _$_clearFindViewByIdCache() {
            if (this._$_findViewCache != null) {
                this._$_findViewCache.clear();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/permission/kit/PermissionKit$PermissionActivity$Companion;", "", "()V", "TYPE", "", "TYPE_DRAW_OVERLAYS", "", "TYPE_RUNTIME", "TYPE_WRITE_SETTINGS", "start", "", "context", "Landroid/content/Context;", "type", "permission-kit_release"})
        public static final class Companion {
            public final void start(@NotNull Context context, int type) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intent starter = new Intent(context, PermissionActivity.class);
                starter.addFlags(0x10000000);
                starter.putExtra(PermissionActivity.TYPE, type);
                context.startActivity(starter);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0006J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/permission/kit/PermissionKit$OnRationaleListener;", "", "rationale", "", "shouldRequest", "Lcom/permission/kit/PermissionKit$OnRationaleListener$ShouldRequest;", "ShouldRequest", "permission-kit_release"})
    public static interface OnRationaleListener {
        public void rationale(@Nullable ShouldRequest var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0004H&\u00a8\u0006\u0005"}, d2={"Lcom/permission/kit/PermissionKit$OnRationaleListener$ShouldRequest;", "", "again", "", "", "permission-kit_release"})
        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/permission/kit/PermissionKit$SimpleCallback;", "", "onDenied", "", "onGranted", "permission-kit_release"})
    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&\u00a8\u0006\n"}, d2={"Lcom/permission/kit/PermissionKit$FullCallback;", "", "onDenied", "", "permissionsDeniedForever", "", "", "permissionsDenied", "onGranted", "permissionsGranted", "permission-kit_release"})
    public static interface FullCallback {
        public void onGranted(@Nullable List<String> var1);

        public void onDenied(@Nullable List<String> var1, @Nullable List<String> var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u0005J\u001f\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0015\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u0017\u001a\u00020\r2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0015\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010 \u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0007J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0003J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0003R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/permission/kit/PermissionKit$Companion;", "", "()V", "MANIFEST_PERMISSIONS", "", "", "isGrantedDrawOverlays", "", "()Z", "isGrantedWriteSettings", "sApplication", "Landroid/app/Application;", "sInstance", "Lcom/permission/kit/PermissionKit;", "sSimpleCallback4DrawOverlays", "Lcom/permission/kit/PermissionKit$SimpleCallback;", "sSimpleCallback4WriteSettings", "getPermissions", "packageName", "isGranted", "permissions", "", "([Ljava/lang/String;)Z", "permission", "isIntentAvailable", "intent", "Landroid/content/Intent;", "launchAppDetailsSettings", "", "([Ljava/lang/String;)Lcom/permission/kit/PermissionKit;", "requestDrawOverlays", "callback", "requestWriteSettings", "startOverlayPermissionActivity", "activity", "Landroid/app/Activity;", "requestCode", "", "startWriteSettingsActivity", "permission-kit_release"})
    public static final class Companion {
        private final boolean isGranted(String permission) {
            return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)((Context)sApplication), (String)permission) == 0;
        }

        @TargetApi(value=23)
        private final void startWriteSettingsActivity(Activity activity, int requestCode) {
            Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            StringBuilder stringBuilder = new StringBuilder().append("package:");
            Application application = sApplication;
            if (application == null) {
                Intrinsics.throwNpe();
            }
            intent.setData(Uri.parse((String)stringBuilder.append(application.getPackageName()).toString()));
            if (!this.isIntentAvailable(intent)) {
                this.launchAppDetailsSettings();
                return;
            }
            activity.startActivityForResult(intent, requestCode);
        }

        @TargetApi(value=23)
        private final void startOverlayPermissionActivity(Activity activity, int requestCode) {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            StringBuilder stringBuilder = new StringBuilder().append("package:");
            Application application = sApplication;
            if (application == null) {
                Intrinsics.throwNpe();
            }
            intent.setData(Uri.parse((String)stringBuilder.append(application.getPackageName()).toString()));
            if (!this.isIntentAvailable(intent)) {
                this.launchAppDetailsSettings();
                return;
            }
            activity.startActivityForResult(intent, requestCode);
        }

        @RequiresApi(api=23)
        public final boolean isGrantedDrawOverlays() {
            return Settings.canDrawOverlays((Context)((Context)sApplication));
        }

        @RequiresApi(api=23)
        public final void requestDrawOverlays(@Nullable SimpleCallback callback) {
            if (this.isGrantedDrawOverlays()) {
                SimpleCallback simpleCallback = callback;
                if (simpleCallback != null) {
                    simpleCallback.onGranted();
                }
                return;
            }
            sSimpleCallback4DrawOverlays = callback;
            Context context = sApplication.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"sApplication.applicationContext");
            PermissionActivity.Companion.start(context, 3);
        }

        @NotNull
        public final PermissionKit permission(String ... permissions) {
            Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
            return new PermissionKit(Arrays.copyOf(permissions, permissions.length), null);
        }

        public final void launchAppDetailsSettings() {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + sApplication.getPackageName())));
            if (!this.isIntentAvailable(intent)) {
                return;
            }
            sApplication.startActivity(intent.addFlags(0x10000000));
        }

        private final boolean isIntentAvailable(Intent intent) {
            return sApplication.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
        }

        @NotNull
        public final List<String> getPermissions(@NotNull String packageName) {
            List<String> list;
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            PackageManager pm = sApplication.getPackageManager();
            try {
                if (pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions == null) {
                    return CollectionsKt.emptyList();
                }
                String[] permissions = pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions;
                List<String> list2 = Arrays.asList(Arrays.copyOf(permissions, permissions.length));
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*permissions)");
                list = list2;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public final boolean isGranted(String ... permissions) {
            Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
            for (String permission : permissions) {
                if (this.isGranted(permission)) continue;
                return false;
            }
            return true;
        }

        @RequiresApi(api=23)
        public final boolean isGrantedWriteSettings() {
            return Settings.System.canWrite((Context)((Context)sApplication));
        }

        @RequiresApi(api=23)
        public final void requestWriteSettings(@Nullable SimpleCallback callback) {
            if (this.isGrantedWriteSettings()) {
                SimpleCallback simpleCallback = callback;
                if (simpleCallback != null) {
                    simpleCallback.onGranted();
                }
                return;
            }
            sSimpleCallback4WriteSettings = callback;
            Application application = sApplication;
            if (application == null) {
                Intrinsics.throwNpe();
            }
            Context context = application.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"sApplication!!.applicationContext");
            PermissionActivity.Companion.start(context, 2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

