/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.print.view;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.log.kit.LogConfig;
import com.log.kit.print.LogPrinter;
import com.log.kit.print.view.LogAdapter;
import com.log.kit.print.view.LogModel;
import com.log.kit.print.view.ViewPrintProvider;
import com.log.kit.util.MainHandler;

public class ViewPrinter
implements LogPrinter {
    private RecyclerView mRecyclerView;
    private LogAdapter mAdapter;
    private final ViewPrintProvider mViewPrintProvider;

    public ViewPrinter(Activity activity) {
        FrameLayout rootView = (FrameLayout)activity.findViewById(0x1020002);
        this.mRecyclerView = new RecyclerView((Context)activity);
        this.mAdapter = new LogAdapter(LayoutInflater.from((Context)this.mRecyclerView.getContext()));
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.mRecyclerView.getContext());
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mViewPrintProvider = new ViewPrintProvider(rootView, this.mRecyclerView, this.mAdapter);
    }

    @Override
    public void print(@NonNull LogConfig config, final int level, final String tag, final @NonNull String printString) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ViewPrinter.this.mAdapter.addItem(new LogModel(System.currentTimeMillis(), level, tag, printString));
                ViewPrinter.this.mRecyclerView.smoothScrollToPosition(ViewPrinter.this.mAdapter.getItemCount() - 1);
            }
        });
    }

    public ViewPrintProvider getViewPrintProvider() {
        return this.mViewPrintProvider;
    }
}

