/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.print.view;

import java.text.SimpleDateFormat;
import java.util.Locale;

public class LogModel {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.CHINA);
    public long timeMillis;
    public int level;
    public String tag;
    public String log;

    public LogModel(long timeMillis, int level, String tag, String log) {
        this.timeMillis = timeMillis;
        this.level = level;
        this.tag = tag;
        this.log = log;
    }

    public String flattenedLog() {
        return this.getFlattened() + "\n" + this.log;
    }

    public String getFlattened() {
        return this.format(this.timeMillis) + " " + '/' + this.convertLevel(this.level) + '/' + this.tag + "/:";
    }

    private String convertLevel(int level) {
        switch (level) {
            case 2: {
                return "V";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "W";
            }
            case 6: {
                return "E";
            }
        }
        return "A";
    }

    private String format(long timeMillis) {
        return sdf.format(timeMillis);
    }
}

