/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.log.kit.util.AppGlobal;

public class IDisplayUtil {
    public static int dp2px(float dp, Resources resources) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static int dp2px(float dp) {
        Resources resources = AppGlobal.getInstance().getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static int sp2px(float dp) {
        Resources resources = AppGlobal.getInstance().getResources();
        return (int)TypedValue.applyDimension((int)2, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static int getDisplayWidthInPx(@NonNull Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm != null) {
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            return size.x;
        }
        return 0;
    }

    public static int getDisplayHeightInPx(@NonNull Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm != null) {
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            return size.y;
        }
        return 0;
    }

    public static int getStatusBarDimensionPx() {
        int statusBarHeight = 0;
        Resources res = AppGlobal.getInstance().getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = res.getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }
}

