/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.print.view;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.log.kit.print.view.ILogAdapter;
import com.log.kit.util.IDisplayUtil;

public class IViewPrintProvider {
    private static final String TAG_FLOATING_VIEW = "TAG_FLOATING_VIEW";
    private static final String TAG_LOG_VIEW = "TAG_LOG_VIEW";
    private FrameLayout mRootView;
    private View mFloatingView;
    private boolean mIsOpen;
    private FrameLayout mLogView;
    private RecyclerView mRecyclerView;
    private ILogAdapter mAdapter;

    public IViewPrintProvider(FrameLayout rootView, RecyclerView recyclerView, ILogAdapter adapter) {
        this.mRootView = rootView;
        this.mRecyclerView = recyclerView;
        this.mAdapter = adapter;
    }

    public void showFloatingView() {
        if (this.mRootView.findViewWithTag((Object)TAG_FLOATING_VIEW) != null) {
            return;
        }
        int index = this.mRootView.indexOfChild(this.getFloatingView());
        View childAt = this.mRootView.getChildAt(index);
        if (childAt == null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 0x800055;
            View floatingView = this.getFloatingView();
            floatingView.setTag((Object)TAG_FLOATING_VIEW);
            floatingView.setBackgroundColor(-16777216);
            floatingView.setAlpha(0.8f);
            params.bottomMargin = IDisplayUtil.dp2px(100.0f, this.mRootView.getResources());
            this.mRootView.addView(this.getFloatingView(), (ViewGroup.LayoutParams)params);
        }
    }

    public void closeFloatingView() {
        this.mRootView.removeView(this.getFloatingView());
    }

    private View getFloatingView() {
        if (this.mFloatingView != null) {
            return this.mFloatingView;
        }
        TextView textView = new TextView(this.mRootView.getContext());
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!IViewPrintProvider.this.mIsOpen) {
                    IViewPrintProvider.this.showLogView();
                }
            }
        });
        textView.setText((CharSequence)"iLog");
        this.mFloatingView = textView;
        return this.mFloatingView;
    }

    private void showLogView() {
        if (this.mRootView.findViewWithTag((Object)TAG_LOG_VIEW) != null) {
            return;
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, IDisplayUtil.dp2px(260.0f, this.mRootView.getResources()));
        params.gravity = 80;
        View logView = this.getLogView();
        logView.setTag((Object)TAG_LOG_VIEW);
        this.mRootView.addView(this.getLogView(), (ViewGroup.LayoutParams)params);
        this.mIsOpen = true;
    }

    private void closeLogView() {
        this.mIsOpen = false;
        this.mRootView.removeView(this.getLogView());
    }

    private View getLogView() {
        if (this.mLogView != null) {
            return this.mLogView;
        }
        FrameLayout logView = new FrameLayout(this.mRootView.getContext());
        logView.setBackgroundColor(-16777216);
        logView.addView((View)this.mRecyclerView);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 0x800005;
        TextView closeView = new TextView(this.mRootView.getContext());
        closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IViewPrintProvider.this.closeLogView();
            }
        });
        closeView.setText((CharSequence)"Close");
        logView.addView((View)closeView, (ViewGroup.LayoutParams)params);
        FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
        params2.gravity = 0x800005;
        params2.topMargin = IDisplayUtil.dp2px(30.0f, this.mRootView.getResources());
        TextView clearView = new TextView(this.mRootView.getContext());
        clearView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IViewPrintProvider.this.mAdapter.clear();
            }
        });
        clearView.setText((CharSequence)"Clear");
        logView.addView((View)clearView, (ViewGroup.LayoutParams)params2);
        this.mLogView = logView;
        return this.mLogView;
    }
}

