/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit;

import androidx.annotation.NonNull;
import com.log.kit.ILogConfig;
import com.log.kit.print.ILogPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ILogManager {
    private ILogConfig mConfig;
    private List<ILogPrinter> mPrinters = new ArrayList<ILogPrinter>();

    private ILogManager() {
    }

    public static ILogManager getInstance() {
        return SingleHolder.instance;
    }

    public void init(@NonNull ILogConfig config, ILogPrinter ... printers) {
        this.mConfig = config;
        this.mPrinters.addAll(Arrays.asList(printers));
    }

    public ILogConfig getConfig() {
        this.check();
        return this.mConfig;
    }

    public List<ILogPrinter> getPrinters() {
        this.check();
        return this.mPrinters;
    }

    public void addPrinter(ILogPrinter printer) {
        this.check();
        this.mPrinters.add(printer);
    }

    public void removePrinter(ILogPrinter printer) {
        this.check();
        if (this.mPrinters != null) {
            this.mPrinters.remove(printer);
        }
    }

    private void check() {
        if (this.mConfig == null || this.mPrinters == null) {
            throw new RuntimeException("ILogManager \u7684 init \u8fd8\u672a\u521d\u59cb\u5316");
        }
    }

    public static class SingleHolder {
        public static volatile ILogManager instance = new ILogManager();
    }
}

