/*
 * Decompiled with CFR 0.152.
 */
package com.crash.kit;

import android.app.Application;
import com.crash.kit.CrashHandler;
import com.crash.kit.util.ActivityManager;
import com.crash.kit.util.AppGlobals;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/crash/kit/CrashKitManager;", "", "()V", "CRASH_DIR_JAVA", "", "crashFiles", "", "Ljava/io/File;", "()[Ljava/io/File;", "deleteFiles", "", "getJavaCrashDir", "init", "crash-kit_release"})
public final class CrashKitManager {
    private static final String CRASH_DIR_JAVA = "java_crash";
    public static final CrashKitManager INSTANCE;

    public final void init() {
        ActivityManager activityManager = ActivityManager.Companion.getInstance();
        Application application = AppGlobals.INSTANCE.get();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        activityManager.init(application);
        File javaCrashDir = this.getJavaCrashDir();
        String string = javaCrashDir.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaCrashDir.absolutePath");
        CrashHandler.INSTANCE.init(string);
    }

    private final File getJavaCrashDir() {
        File javaCrashFile;
        Application application = AppGlobals.INSTANCE.get();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (!(javaCrashFile = new File(application.getCacheDir(), CRASH_DIR_JAVA)).exists()) {
            javaCrashFile.mkdirs();
        }
        return javaCrashFile;
    }

    @NotNull
    public final File[] crashFiles() {
        File[] fileArray = this.getJavaCrashDir().listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"getJavaCrashDir().listFiles()");
        return fileArray;
    }

    public final void deleteFiles() {
        File javaCrashFile;
        Application application = AppGlobals.INSTANCE.get();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if ((javaCrashFile = new File(application.getCacheDir(), CRASH_DIR_JAVA)).exists()) {
            if (javaCrashFile.isDirectory()) {
                File[] listFiles;
                for (File file : listFiles = javaCrashFile.listFiles()) {
                    file.delete();
                }
            } else {
                javaCrashFile.delete();
            }
        }
    }

    private CrashKitManager() {
    }

    static {
        CrashKitManager crashKitManager;
        INSTANCE = crashKitManager = new CrashKitManager();
    }
}

