/*
 * Decompiled with CFR 0.152.
 */
package com.adapter.kit;

import android.content.Context;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.adapter.kit.CacheViewHolder;
import com.adapter.kit.DataItem;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J*\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00072\u0012\u0010\u001f\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\u0006\u0010 \u001a\u00020!J(\u0010\"\u001a\u00020\u001a2\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\f0$2\u0006\u0010 \u001a\u00020!J\u0006\u0010%\u001a\u00020\u001aJ*\u0010&\u001a\u00020\u00022\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\f0(2\u0006\u0010)\u001a\u00020\u0010H\u0002J\b\u0010*\u001a\u0004\u0018\u00010\u0016J\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010,\u001a\u00020\u0007J\u001c\u0010-\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010.\u001a\u00020\u0007H\u0002J\b\u0010/\u001a\u00020\u0007H\u0016J\u0010\u00100\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0016J\u0006\u00101\u001a\u00020\u0007J\u0010\u00102\u001a\u00020!2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0010\u00103\u001a\u00020!2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u0016H\u0016J\u0018\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0007H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0007H\u0016J\u0010\u0010<\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u0016H\u0016J\u0010\u0010=\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0002H\u0016J\u0010\u0010>\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0002H\u0016J\u001a\u0010?\u001a\u00020\u001a2\u0012\u0010@\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\fJ\u000e\u0010A\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010B\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J\u001a\u0010C\u001a\u00020\u001a2\u0012\u0010\u001f\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\fJ\u001c\u0010C\u001a\u0010\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\f0\u000bj\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/adapter/kit/AdapterKit;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "BASE_ITEM_TYPE_FOOTER", "", "BASE_ITEM_TYPE_HEADER", "mContext", "mDataSets", "Ljava/util/ArrayList;", "Lcom/adapter/kit/DataItem;", "Lkotlin/collections/ArrayList;", "mFooters", "Landroid/util/SparseArray;", "Landroid/view/View;", "mHeaders", "mInflater", "Landroid/view/LayoutInflater;", "mRecyclerViewRef", "Ljava/lang/ref/WeakReference;", "Landroidx/recyclerview/widget/RecyclerView;", "mTypePositions", "Landroid/util/SparseIntArray;", "addFooterView", "", "view", "addHeadView", "addItem", "index", "item", "notify", "", "addItems", "items", "", "clearItems", "createViewHolderInternal", "javaClass", "Ljava/lang/Class;", "itemView", "getAttachRecyclerView", "getFooterSize", "getHeaderSize", "getItem", "position", "getItemCount", "getItemViewType", "getOriginalItemSize", "isFooterPosition", "isHeaderPosition", "onAttachedToRecyclerView", "recyclerView", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "onViewAttachedToWindow", "onViewDetachedFromWindow", "refreshItem", "iDataItem", "removeFooterView", "removeHeaderView", "removeItem", "adapter-kit_release"})
public final class AdapterKit
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private int BASE_ITEM_TYPE_HEADER;
    private int BASE_ITEM_TYPE_FOOTER;
    private WeakReference<RecyclerView> mRecyclerViewRef;
    private Context mContext;
    private LayoutInflater mInflater;
    private ArrayList<DataItem<?, ? extends RecyclerView.ViewHolder>> mDataSets;
    private final SparseIntArray mTypePositions;
    private SparseArray<View> mHeaders;
    private SparseArray<View> mFooters;

    public int getItemCount() {
        return this.mDataSets.size() + this.getHeaderSize() + this.getFooterSize();
    }

    public int getItemViewType(int position) {
        if (this.isHeaderPosition(position)) {
            return this.mHeaders.keyAt(position);
        }
        if (this.isFooterPosition(position)) {
            int footerPosition = position - this.getHeaderSize() - this.getOriginalItemSize();
            return this.mFooters.keyAt(footerPosition);
        }
        int itemPosition = position - this.getHeaderSize();
        DataItem<?, RecyclerView.ViewHolder> dataItem = this.mDataSets.get(itemPosition);
        Intrinsics.checkExpressionValueIsNotNull(dataItem, (String)"mDataSets.get(itemPosition)");
        DataItem<?, RecyclerView.ViewHolder> dataItem2 = dataItem;
        int type = dataItem2.getClass().hashCode();
        this.mTypePositions.put(type, position);
        return type;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        if (this.mHeaders.indexOfKey(viewType) >= 0) {
            View view = (View)this.mHeaders.get(viewType);
            return new RecyclerView.ViewHolder(view, view){
                final /* synthetic */ View $view;
                {
                    this.$view = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }
        if (this.mFooters.indexOfKey(viewType) >= 0) {
            View view = (View)this.mFooters.get(viewType);
            return new RecyclerView.ViewHolder(view, view){
                final /* synthetic */ View $view;
                {
                    this.$view = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }
        int position = this.mTypePositions.get(viewType);
        DataItem<?, RecyclerView.ViewHolder> dataItem = this.mDataSets.get(position);
        Intrinsics.checkExpressionValueIsNotNull(dataItem, (String)"mDataSets[position]");
        DataItem<?, RecyclerView.ViewHolder> dataItem2 = dataItem;
        RecyclerView.ViewHolder vh = dataItem2.onCreateViewHolder(parent);
        if (vh != null) {
            return vh;
        }
        View itemView = dataItem2.getItemView(parent);
        if (itemView == null) {
            int itemLayoutRes = dataItem2.getItemLayoutRes();
            if (itemLayoutRes < 0) {
                new RuntimeException("dataItem:" + dataItem2.getClass().getName() + "\u5fc5\u987b\u91cd\u5199 getItemView \u6216\u8005 getItemLayoutRes\u65b9\u6cd5");
            }
            LayoutInflater layoutInflater = this.mInflater;
            if (layoutInflater == null) {
                Intrinsics.throwNpe();
            }
            itemView = layoutInflater.inflate(itemLayoutRes, parent, false);
        }
        Class<DataItem<?, ? extends RecyclerView.ViewHolder>> clazz = dataItem2.getClass();
        View view = itemView;
        if (view == null) {
            Intrinsics.throwNpe();
        }
        return this.createViewHolderInternal(clazz, view);
    }

    private final RecyclerView.ViewHolder createViewHolderInternal(Class<DataItem<?, ? extends RecyclerView.ViewHolder>> javaClass, View itemView) {
        Type superclass = javaClass.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            Type[] arguments;
            for (Type argument : arguments = ((ParameterizedType)superclass).getActualTypeArguments()) {
                if (!(argument instanceof Class) || !RecyclerView.ViewHolder.class.isAssignableFrom((Class)argument)) continue;
                try {
                    Object t = ((Class)argument).getConstructor(View.class).newInstance(itemView);
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView.ViewHolder");
                    }
                    return (RecyclerView.ViewHolder)t;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return new CacheViewHolder(itemView, itemView){
            final /* synthetic */ View $itemView;
            {
                this.$itemView = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            if (this.isHeaderPosition(position) || this.isFooterPosition(position)) {
                return;
            }
            int itemPosition = position - this.getHeaderSize();
            DataItem<?, RecyclerView.ViewHolder> dataItem = this.getItem(itemPosition);
            if (dataItem == null) break block1;
            dataItem.onBindData(holder, itemPosition);
        }
    }

    private final DataItem<?, RecyclerView.ViewHolder> getItem(int position) {
        if (position < 0 || position >= this.mDataSets.size()) {
            return null;
        }
        DataItem<?, ? extends RecyclerView.ViewHolder> dataItem = this.mDataSets.get(position);
        if (dataItem == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.adapter.kit.DataItem<*, androidx.recyclerview.widget.RecyclerView.ViewHolder>");
        }
        return dataItem;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerViewRef = new WeakReference<RecyclerView>(recyclerView);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            int spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
            ((GridLayoutManager)layoutManager).setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(this, spanCount){
                final /* synthetic */ AdapterKit this$0;
                final /* synthetic */ int $spanCount;

                public int getSpanSize(int position) {
                    if (AdapterKit.access$isHeaderPosition(this.this$0, position) || AdapterKit.access$isFooterPosition(this.this$0, position)) {
                        return this.$spanCount;
                    }
                    int itemPosition = position - this.this$0.getHeaderSize();
                    if (itemPosition < AdapterKit.access$getMDataSets$p(this.this$0).size()) {
                        E e = AdapterKit.access$getMDataSets$p(this.this$0).get(itemPosition);
                        Intrinsics.checkExpressionValueIsNotNull(e, (String)"mDataSets.get(itemPosition)");
                        DataItem dataItem = (DataItem)e;
                        int spanSize = dataItem.getSpanSize();
                        return spanSize <= 0 ? this.$spanCount : spanSize;
                    }
                    return this.$spanCount;
                }
                {
                    this.this$0 = $outer;
                    this.$spanCount = $captured_local_variable$1;
                }
            });
        }
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
            super.onDetachedFromRecyclerView(recyclerView);
            if (this.mRecyclerViewRef == null) break block1;
            WeakReference<RecyclerView> weakReference = this.mRecyclerViewRef;
            if (weakReference != null) {
                weakReference.clear();
            }
        }
    }

    public void onViewAttachedToWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        RecyclerView recyclerView = this.getAttachRecyclerView();
        if (recyclerView != null) {
            int position = recyclerView.getChildAdapterPosition(holder.itemView);
            boolean isHeaderFooter = this.isHeaderPosition(position) || this.isFooterPosition(position);
            int itemPosition = position - this.getHeaderSize();
            DataItem<?, RecyclerView.ViewHolder> dataItem = this.getItem(itemPosition);
            if (dataItem == null) {
                return;
            }
            DataItem<?, RecyclerView.ViewHolder> dataItem2 = dataItem;
            View view = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
                StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)recyclerView.getLayoutManager();
                if (isHeaderFooter) {
                    ((StaggeredGridLayoutManager.LayoutParams)lp).setFullSpan(true);
                    return;
                }
                int spanSize = dataItem2.getSpanSize();
                StaggeredGridLayoutManager staggeredGridLayoutManager = manager;
                if (staggeredGridLayoutManager == null) {
                    Intrinsics.throwNpe();
                }
                if (spanSize == staggeredGridLayoutManager.getSpanCount()) {
                    ((StaggeredGridLayoutManager.LayoutParams)lp).setFullSpan(true);
                }
            }
            dataItem2.onViewAttachedToWindow(holder);
        }
    }

    public void onViewDetachedFromWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        int position = holder.getAdapterPosition();
        if (this.isHeaderPosition(position) || this.isFooterPosition(position)) {
            return;
        }
        int itemPosition = position - this.getHeaderSize();
        DataItem<?, RecyclerView.ViewHolder> dataItem = this.getItem(itemPosition);
        if (dataItem == null) {
            return;
        }
        DataItem<?, RecyclerView.ViewHolder> dataItem2 = dataItem;
        dataItem2.onViewDetachedFromWindow(holder);
    }

    @Nullable
    public final RecyclerView getAttachRecyclerView() {
        Object object;
        if (this.mRecyclerViewRef != null) {
            WeakReference<RecyclerView> weakReference = this.mRecyclerViewRef;
            object = weakReference != null ? (RecyclerView)weakReference.get() : null;
        } else {
            object = null;
        }
        return object;
    }

    public final void addHeadView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (this.mHeaders.indexOfValue((Object)view) < 0) {
            int n = this.BASE_ITEM_TYPE_HEADER;
            this.BASE_ITEM_TYPE_HEADER = n + 1;
            this.mHeaders.put(n, (Object)view);
            this.notifyItemInserted(this.mHeaders.size() - 1);
        }
    }

    public final void removeHeaderView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        int indexOfValue = this.mHeaders.indexOfValue((Object)view);
        if (indexOfValue < 0) {
            return;
        }
        this.mHeaders.removeAt(indexOfValue);
        this.notifyItemRemoved(indexOfValue);
    }

    public final void addFooterView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (this.mFooters.indexOfValue((Object)view) < 0) {
            int n = this.BASE_ITEM_TYPE_FOOTER;
            this.BASE_ITEM_TYPE_FOOTER = n + 1;
            this.mFooters.put(n, (Object)view);
            this.notifyItemInserted(this.getItemCount());
        }
    }

    public final void removeFooterView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        int indexOfValue = this.mFooters.indexOfValue((Object)view);
        if (indexOfValue < 0) {
            return;
        }
        this.mFooters.removeAt(indexOfValue);
        this.notifyItemRemoved(indexOfValue + this.getHeaderSize() + this.getOriginalItemSize());
    }

    public final int getHeaderSize() {
        return this.mHeaders.size();
    }

    public final int getFooterSize() {
        return this.mFooters.size();
    }

    public final int getOriginalItemSize() {
        return this.mDataSets.size();
    }

    private final boolean isHeaderPosition(int position) {
        return position < this.mHeaders.size();
    }

    private final boolean isFooterPosition(int position) {
        return position >= this.getHeaderSize() + this.getOriginalItemSize();
    }

    public final void addItem(int index, @NotNull DataItem<?, ? extends RecyclerView.ViewHolder> item, boolean notify) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        if (index > 0) {
            this.mDataSets.add(index, item);
        } else {
            this.mDataSets.add(item);
        }
        if (notify) {
            int notifyPos = index > 0 ? index : this.mDataSets.size() - 1;
            this.notifyItemInserted(notifyPos);
        }
    }

    public final void addItems(@NotNull List<? extends DataItem<?, ? extends RecyclerView.ViewHolder>> items, boolean notify) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        int start = this.mDataSets.size();
        for (DataItem<?, RecyclerView.ViewHolder> dataItem : items) {
            this.mDataSets.add(dataItem);
        }
        if (notify) {
            this.notifyItemRangeInserted(start, items.size());
        }
    }

    @Nullable
    public final DataItem<?, ? extends RecyclerView.ViewHolder> removeItem(int index) {
        if (index > 0 && index < this.mDataSets.size()) {
            DataItem<?, ? extends RecyclerView.ViewHolder> dataItem = this.mDataSets.get(index);
            Intrinsics.checkExpressionValueIsNotNull(dataItem, (String)"mDataSets.get(index)");
            DataItem<?, ? extends RecyclerView.ViewHolder> item = dataItem;
            this.notifyItemRemoved(index);
            return item;
        }
        return null;
    }

    public final void removeItem(@NotNull DataItem<?, ? extends RecyclerView.ViewHolder> item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        int index = this.mDataSets.indexOf(item);
        this.removeItem(index);
    }

    public final void refreshItem(@NotNull DataItem<?, ? extends RecyclerView.ViewHolder> iDataItem) {
        Intrinsics.checkParameterIsNotNull(iDataItem, (String)"iDataItem");
        int indexOf = this.mDataSets.indexOf(iDataItem);
        this.notifyItemChanged(indexOf);
    }

    public final void clearItems() {
        this.mDataSets.clear();
        this.notifyDataSetChanged();
    }

    public AdapterKit(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.BASE_ITEM_TYPE_HEADER = 1000000;
        this.BASE_ITEM_TYPE_FOOTER = 2000000;
        this.mDataSets = new ArrayList();
        this.mTypePositions = new SparseIntArray();
        this.mHeaders = new SparseArray();
        this.mFooters = new SparseArray();
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public static final /* synthetic */ boolean access$isHeaderPosition(AdapterKit $this, int position) {
        return $this.isHeaderPosition(position);
    }

    public static final /* synthetic */ boolean access$isFooterPosition(AdapterKit $this, int position) {
        return $this.isFooterPosition(position);
    }

    public static final /* synthetic */ ArrayList access$getMDataSets$p(AdapterKit $this) {
        return $this.mDataSets;
    }

    public static final /* synthetic */ void access$setMDataSets$p(AdapterKit $this, ArrayList arrayList) {
        $this.mDataSets = arrayList;
    }
}

