/*
 * Decompiled with CFR 0.152.
 */
package com.android.xselector.selector;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.support.annotation.ColorRes;
import android.widget.TextView;
import com.android.xselector.interfaces.ISelector;
import com.android.xselector.utils.XHelper;

public class ColorSelector
implements ISelector<ColorStateList, TextView> {
    private static ColorSelector mColorSelector;
    private TextColorType textType = TextColorType.TEXT_COLOR;
    private static final int DEFAULT_COLOR_ID = -1;
    private int disabledColor = -1;
    private int focusedColor = -1;
    private int pressedColor = -1;
    private int selectedColor = -1;
    private int normalColor = -1;

    public static ColorSelector getInstance() {
        mColorSelector = new ColorSelector();
        return mColorSelector;
    }

    public ColorSelector defaultColor(@ColorRes int tmpColor) {
        this.normalColor = XHelper.getColorRes(tmpColor);
        return this;
    }

    public ColorSelector defaultColor(String tmpColor) {
        this.normalColor = Color.parseColor((String)tmpColor);
        return this;
    }

    public ColorSelector disabledColor(@ColorRes int color) {
        this.disabledColor = XHelper.getColorRes(color);
        return this;
    }

    public ColorSelector disabledColor(String color) {
        this.disabledColor = Color.parseColor((String)color);
        return this;
    }

    public ColorSelector pressedColor(@ColorRes int color) {
        this.pressedColor = XHelper.getColorRes(color);
        return this;
    }

    public ColorSelector pressedColor(String color) {
        this.pressedColor = Color.parseColor((String)color);
        return this;
    }

    public ColorSelector selectedColor(@ColorRes int color) {
        this.selectedColor = XHelper.getColorRes(color);
        return this;
    }

    public ColorSelector selectedColor(String color) {
        this.selectedColor = Color.parseColor((String)color);
        return this;
    }

    public ColorSelector focusedColor(@ColorRes int color) {
        this.focusedColor = XHelper.getColorRes(color);
        return this;
    }

    public ColorSelector focusedColor(String color) {
        this.focusedColor = Color.parseColor((String)color);
        return this;
    }

    public ColorSelector selectorColor(int pressedColorResId, int normalColorResId) {
        this.pressedColor = pressedColorResId;
        this.normalColor = normalColorResId;
        return this;
    }

    public ColorSelector textType(TextColorType type) {
        this.textType = type;
        return this;
    }

    @Override
    public void into(TextView textView) {
        if (this.isDefaultColorValue(this.normalColor)) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6edefaultColor\u5c5e\u6027\uff01");
        }
        if (TextColorType.HINT_TEXT_COLOR == this.textType) {
            textView.setHintTextColor(this.create());
        } else {
            textView.setTextColor(this.create());
        }
    }

    @Override
    public ColorStateList build() {
        return this.create();
    }

    public ColorStateList create() {
        int[] colors = new int[]{this.isDefaultColorValue(this.disabledColor) ? this.normalColor : this.disabledColor, this.isDefaultColorValue(this.pressedColor) ? this.normalColor : this.pressedColor, this.isDefaultColorValue(this.selectedColor) ? this.normalColor : this.selectedColor, this.isDefaultColorValue(this.focusedColor) ? this.normalColor : this.focusedColor, this.normalColor};
        return this.getColorStateList(colors);
    }

    private boolean isDefaultColorValue(int color) {
        return color == -1;
    }

    public ColorStateList getColorStateList(int[] colors) {
        int[][] states = new int[][]{{-16842910}, {16842919}, {0x10100A1}, {16842908}, new int[0]};
        return new ColorStateList((int[][])states, colors);
    }

    public static enum TextColorType {
        TEXT_COLOR,
        HINT_TEXT_COLOR;

    }
}

