/*
 * Decompiled with CFR 0.152.
 */
package com.android.xselector.shadow;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.view.View;

public class ShadowHelper
extends Drawable {
    static ShadowHelper shadowHelper;
    private Paint mPaint;
    private int mShadowRadius = 18;
    private int mShadowColor = Color.parseColor((String)"#4d000000");
    private int mShape = 1;
    private int mShapeRadius = 0;
    private int mOffsetX = 0;
    private int mOffsetY = 0;
    private int[] mBgColor = new int[1];
    private RectF mRect;
    public static final int SHAPE_ROUND = 1;
    public static final int SHAPE_CIRCLE = 2;
    public static final int ALL = 4369;
    public static final int LEFT = 1;
    public static final int TOP = 16;
    public static final int RIGHT = 256;
    public static final int BOTTOM = 4096;
    private int shadowSide = 4369;

    private ShadowHelper() {
        this.mBgColor[0] = 0;
        this.mPaint = new Paint();
        this.mPaint.setColor(0);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mOffsetX, (float)this.mOffsetY, this.mShadowColor);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
    }

    public static ShadowHelper getInstance() {
        shadowHelper = new ShadowHelper();
        return shadowHelper;
    }

    public ShadowHelper setShape(int mShape) {
        this.mShape = mShape;
        return this;
    }

    public ShadowHelper setShadowSide(int shadowSide) {
        this.shadowSide = shadowSide;
        return this;
    }

    public ShadowHelper setShapeRadius(int ShapeRadius) {
        this.mShapeRadius = ShapeRadius;
        return this;
    }

    public ShadowHelper setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mOffsetX, (float)this.mOffsetY, this.mShadowColor);
        return this;
    }

    public ShadowHelper setShadowColor(String shadowColor) {
        this.mShadowColor = Color.parseColor((String)shadowColor);
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mOffsetX, (float)this.mOffsetY, this.mShadowColor);
        return this;
    }

    public ShadowHelper setShadowRadius(int shadowRadius) {
        this.mShadowRadius = shadowRadius;
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mOffsetX, (float)this.mOffsetY, this.mShadowColor);
        return this;
    }

    public ShadowHelper setOffsetX(int OffsetX) {
        this.mOffsetX = OffsetX;
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mOffsetX, (float)this.mOffsetY, this.mShadowColor);
        return this;
    }

    public ShadowHelper setOffsetY(int OffsetY) {
        this.mOffsetY = OffsetY;
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mOffsetX, (float)this.mOffsetY, this.mShadowColor);
        return this;
    }

    public ShadowHelper setBgColor(int BgColor) {
        this.mBgColor[0] = BgColor;
        return this;
    }

    public ShadowHelper setBgColor(String bgColor) {
        this.mBgColor[0] = Color.parseColor((String)bgColor);
        return this;
    }

    public ShadowHelper setBgColor(int[] BgColor) {
        this.mBgColor = BgColor;
        return this;
    }

    public ShadowHelper setBgColor(String[] bgColor) {
        int length = bgColor.length;
        int[] color = new int[length];
        for (int i = 0; i < length; ++i) {
            color[i] = Color.parseColor((String)bgColor[i]);
        }
        this.mBgColor = color;
        return this;
    }

    public ShadowHelper setShadowAlpha(int i) {
        this.setAlpha(i);
        return this;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        int leftShadow = (this.shadowSide & 1) == 1 ? this.mShadowRadius - this.mOffsetX : -this.mShapeRadius;
        int topShadow = (this.shadowSide & 0x10) == 16 ? this.mShadowRadius - this.mOffsetY : -this.mShapeRadius;
        int rightShadow = (this.shadowSide & 0x100) == 256 ? this.mShadowRadius + this.mOffsetX : -this.mShapeRadius;
        int bottomShadow = (this.shadowSide & 0x1000) == 4096 ? this.mShadowRadius + this.mOffsetY : -this.mShapeRadius;
        this.mRect = new RectF((float)(bounds.left + leftShadow), (float)(bounds.top + topShadow), (float)(bounds.right - rightShadow), (float)(bounds.bottom - bottomShadow));
    }

    public void draw(@NonNull Canvas canvas) {
        Paint newPaint = new Paint();
        if (this.mBgColor != null) {
            if (this.mBgColor.length == 1) {
                newPaint.setColor(this.mBgColor[0]);
            } else {
                newPaint.setShader((Shader)new LinearGradient(this.mRect.left, this.mRect.height() / 2.0f, this.mRect.right, this.mRect.height() / 2.0f, this.mBgColor, null, Shader.TileMode.CLAMP));
            }
        }
        newPaint.setAntiAlias(true);
        if (this.mShape == 1) {
            canvas.drawRoundRect(this.mRect, (float)this.mShapeRadius, (float)this.mShapeRadius, this.mPaint);
            canvas.drawRoundRect(this.mRect, (float)this.mShapeRadius, (float)this.mShapeRadius, newPaint);
        } else {
            canvas.drawCircle(this.mRect.centerX(), this.mRect.centerY(), Math.min(this.mRect.width(), this.mRect.height()) / 2.0f, this.mPaint);
            canvas.drawCircle(this.mRect.centerX(), this.mRect.centerY(), Math.min(this.mRect.width(), this.mRect.height()) / 2.0f, newPaint);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public static void setShadowHelper(View view, Drawable drawable) {
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)drawable);
    }

    public void into(View view) {
        if (view == null) {
            return;
        }
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)this);
    }
}

