/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.entity;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.File;

public class BundleConfig
implements Parcelable {
    private Integer bundleId;
    private String moduleName;
    private String bundleVersion;
    private String bundleFilePath;
    private String bundleAssetName;
    private String jsMainMoudlePath;
    private Bundle appProperties;
    public static final Parcelable.Creator<BundleConfig> CREATOR = new Parcelable.Creator<BundleConfig>(){

        public BundleConfig createFromParcel(Parcel in) {
            return new BundleConfig(in);
        }

        public BundleConfig[] newArray(int size) {
            return new BundleConfig[size];
        }
    };

    public BundleConfig() {
    }

    private BundleConfig(BundleConfigBuild builder) {
        this.bundleId = builder.bundleId;
        this.moduleName = builder.moduleName;
        this.bundleFilePath = builder.bundleFilePath;
        this.bundleAssetName = builder.bundleAssetName;
        this.jsMainMoudlePath = builder.jsMainMoudlePath;
        this.appProperties = builder.appProperties;
        this.bundleVersion = builder.bundleVersion;
    }

    protected BundleConfig(Parcel in) {
        this.bundleId = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.moduleName = in.readString();
        this.bundleFilePath = in.readString();
        this.bundleAssetName = in.readString();
        this.jsMainMoudlePath = in.readString();
        this.appProperties = in.readBundle();
        this.bundleVersion = in.readString();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getBundleFilePath() {
        if (TextUtils.isEmpty((CharSequence)this.bundleFilePath)) {
            return null;
        }
        File localBundleFile = new File(this.bundleFilePath);
        if (localBundleFile.exists()) {
            return localBundleFile.getAbsolutePath();
        }
        return null;
    }

    public void setBundleFilePath(String bundleFilePath) {
        this.bundleFilePath = bundleFilePath;
    }

    public String getBundleAssetName() {
        if (!TextUtils.isEmpty((CharSequence)this.bundleAssetName)) {
            return this.bundleAssetName;
        }
        return "index.android.bundle";
    }

    public String getJsMainMoudlePath() {
        if (!TextUtils.isEmpty((CharSequence)this.jsMainMoudlePath)) {
            return this.jsMainMoudlePath;
        }
        return "index.android";
    }

    public int getBundleId() {
        return this.bundleId;
    }

    public Bundle getAppProperties() {
        return this.appProperties;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.bundleId == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.bundleId.intValue());
        }
        dest.writeString(this.moduleName);
        dest.writeString(this.bundleFilePath);
        dest.writeString(this.bundleAssetName);
        dest.writeString(this.jsMainMoudlePath);
        dest.writeBundle(this.appProperties);
        dest.writeString(this.bundleVersion);
    }

    public static class BundleConfigBuild {
        private int bundleId;
        private String moduleName;
        private String bundleFilePath;
        private String bundleAssetName;
        private String jsMainMoudlePath;
        private Bundle appProperties;
        private String bundleVersion;

        public BundleConfig build() {
            return new BundleConfig(this);
        }

        public BundleConfigBuild setBundleId(int bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public BundleConfigBuild setAppProperties(Bundle appProperties) {
            this.appProperties = appProperties;
            return this;
        }

        public BundleConfigBuild setModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public BundleConfigBuild setBundlePath(String bundleFilePath) {
            this.bundleFilePath = bundleFilePath;
            return this;
        }

        public BundleConfigBuild setBundleAssetName(String bundleAssetName) {
            this.bundleAssetName = bundleAssetName;
            return this;
        }

        public BundleConfigBuild setJsMainMoudlePath(String jsMainMoudlePath) {
            this.jsMainMoudlePath = jsMainMoudlePath;
            return this;
        }

        public BundleConfigBuild setBundleVersion(String bundleVersion) {
            this.bundleVersion = bundleVersion;
            return this;
        }
    }
}

