/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.SparseArray;
import com.cc.rnbridge.base.ReactBridgeActivity;
import com.cc.rnbridge.entity.BundleConfig;
import com.cc.rnbridge.impl.BridgeConfig;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactInstanceManagerBuilder;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactRootView;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import java.util.Arrays;
import java.util.List;

public class RNBridge {
    private ReactInstanceManager mReactInstanceManager;
    private static volatile RNBridge defaultInstance;
    private Application mApplication;
    private boolean debug;
    private List<ReactPackage> reactPackages;
    private BundleConfig mBundleConfig = new BundleConfig();
    private static final SparseArray<ReactNativeHost> nativeHostArray;
    private static final SparseArray<ReactInstanceManager> reactInstanceManagerArray;
    private ReactNativeHost mReactNativeHost;

    private RNBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RNBridge getInstance() {
        if (defaultInstance != null) return defaultInstance;
        Class<RNBridge> clazz = RNBridge.class;
        synchronized (RNBridge.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new RNBridge();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public RNBridge initRNConfig(Application mApplication, BridgeConfig bridgeConfig) {
        this.mApplication = mApplication;
        this.debug = bridgeConfig.isDebug();
        this.reactPackages = bridgeConfig.getReactPackages();
        return this;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public List<ReactPackage> getReactPackages() {
        if (this.reactPackages == null) {
            this.reactPackages = Arrays.asList(new ReactPackage[0]);
        }
        return this.reactPackages;
    }

    public void setRootView(ReactRootView mReactRootView, BundleConfig bundleConfig) {
        Assertions.assumeNotNull((Object)this.getApplication(), (String)"\u8fd8\u6ca1\u6709\u521d\u59cb\u5316RNBridge");
        this.mBundleConfig = bundleConfig;
        this.setRootView(this.getApplication(), null, null, mReactRootView, bundleConfig.getBundleId(), bundleConfig.getModuleName(), bundleConfig.getBundleFilePath(), bundleConfig.getBundleAssetName(), bundleConfig.getJsMainMoudlePath(), bundleConfig.getAppProperties(), this.isDebug(), this.getReactPackages());
    }

    @Deprecated
    public void setRootView(ReactBridgeActivity mActivity, DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler, ReactRootView mReactRootView, BundleConfig bundleConfig) {
        Assertions.assumeNotNull((Object)this.getApplication(), (String)"\u8fd8\u6ca1\u6709\u521d\u59cb\u5316RNBridge");
        this.mBundleConfig = bundleConfig;
        this.setRootView(this.getApplication(), mActivity, defaultHardwareBackBtnHandler, mReactRootView, bundleConfig.getBundleId(), bundleConfig.getModuleName(), bundleConfig.getBundleFilePath(), bundleConfig.getBundleAssetName(), bundleConfig.getJsMainMoudlePath(), bundleConfig.getAppProperties(), this.isDebug(), this.getReactPackages());
    }

    private void setRootView(Application mApplication, ReactBridgeActivity mActivity, DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler, ReactRootView mReactRootView, int bundleId, String moduleName, String bundleFile, String bundleAssetName, String jsMainMoudlePath, Bundle appProperties, boolean debug, List<ReactPackage> reactPackages) {
        ReactInstanceManagerBuilder builder = ReactInstanceManager.builder().setApplication(mApplication).setUseDeveloperSupport(debug).setJSMainModulePath(jsMainMoudlePath).setInitialLifecycleState(LifecycleState.BEFORE_CREATE);
        if (bundleFile != null) {
            builder.setJSBundleFile(bundleFile);
        } else {
            builder.setBundleAssetName(bundleAssetName);
        }
        if (reactPackages != null && reactPackages.size() > 0) {
            builder.addPackages(reactPackages);
        }
        this.mReactInstanceManager = builder.build();
        if (mActivity != null) {
            if (defaultHardwareBackBtnHandler != null) {
                this.mReactInstanceManager.onHostResume((Activity)mActivity, defaultHardwareBackBtnHandler);
            } else {
                this.mReactInstanceManager.onHostResume((Activity)mActivity);
            }
        }
        reactInstanceManagerArray.put(bundleId, (Object)this.mReactInstanceManager);
        this.startReactApplication(mReactRootView, moduleName, appProperties);
    }

    private void startReactApplication(ReactRootView mReactRootView, String moduleName, Bundle appProperties) {
        if (mReactRootView != null && mReactRootView.getReactInstanceManager() == null) {
            mReactRootView.startReactApplication(this.mReactInstanceManager, moduleName, appProperties);
        }
    }

    public ReactInstanceManager getReactInstanceManager(int bundleId) {
        return (ReactInstanceManager)reactInstanceManagerArray.get(bundleId);
    }

    @Deprecated
    public ReactNativeHost getReactNativeHost(Application application) {
        this.mReactNativeHost = (ReactNativeHost)nativeHostArray.get(this.mBundleConfig.getBundleId());
        if (this.mReactNativeHost == null) {
            this.mReactNativeHost = new ReactNativeHost(application){

                public boolean getUseDeveloperSupport() {
                    return RNBridge.this.isDebug();
                }

                protected List<ReactPackage> getPackages() {
                    return RNBridge.this.getReactPackages();
                }
            };
            nativeHostArray.put(this.mBundleConfig.getBundleId(), (Object)this.mReactNativeHost);
        }
        return this.mReactNativeHost;
    }

    static {
        nativeHostArray = new SparseArray();
        reactInstanceManagerArray = new SparseArray();
    }
}

