/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view.selector.shape;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorRes;
import android.view.View;
import com.liujc.baseutils.view.selector.SelectorUtil;
import com.liujc.baseutils.view.selector.interfaces.ISelectorUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SelectorShape
implements ISelectorUtil<Drawable, View> {
    static SelectorShape mDevShape;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    private static int shape;
    private int backgroundColor;
    private int lineColor;
    private int lineWidth = 1;
    private int dashLineWidth = 1;
    private int dashLineColor = 1;
    private float dashWidth = 1.0f;
    private float dashGap = 1.0f;
    private int[] gradientColors;
    private float radialRadius;
    private int gradientType = 0;
    private String gradientOrientation = "TOP_BOTTOM";
    public static final String TOP_BOTTOM = "TOP_BOTTOM";
    public static final String TR_BL = "TR_BL";
    public static final String RIGHT_LEFT = "RIGHT_LEFT";
    public static final String BR_TL = "BR_TL";
    public static final String BOTTOM_TOP = "BOTTOM_TOP";
    public static final String BL_TR = "BL_TR";
    public static final String LEFT_RIGHT = "LEFT_RIGHT";
    public static final String TL_BR = "TL_BR";
    private boolean isBackgroundColor;
    private boolean isLine;
    private boolean isDashLine;
    private boolean isGradient;
    private boolean isRadius;
    private float topRightRadius = 0.0f;
    private float topLeftRadius = 0.0f;
    private float bottomRightRadius = 0.0f;
    private float bottomLeftRadius = 0.0f;

    public static SelectorShape getInstance(int shapeModel) {
        mDevShape = new SelectorShape();
        shape = shapeModel;
        return mDevShape;
    }

    public SelectorShape solid(@ColorRes int backgroundColorResId) {
        this.isBackgroundColor = true;
        this.backgroundColor = SelectorUtil.getContext().getResources().getColor(backgroundColorResId);
        return this;
    }

    public SelectorShape solid(String backgroundColor) {
        this.isBackgroundColor = true;
        this.backgroundColor = Color.parseColor((String)backgroundColor);
        return this;
    }

    public SelectorShape line(int lineWidth, @ColorRes int lineColorResId) {
        this.isLine = true;
        this.lineWidth = lineWidth;
        this.lineColor = SelectorUtil.getContext().getResources().getColor(lineColorResId);
        return this;
    }

    public SelectorShape line(int lineWidth, String lineColor) {
        this.isLine = true;
        this.lineWidth = lineWidth;
        this.lineColor = Color.parseColor((String)lineColor);
        return this;
    }

    public SelectorShape dashLine(int dashLineWidth, @ColorRes int dashLineColorResId, float dashWidth, float dashGap) {
        this.isDashLine = true;
        this.dashLineWidth = dashLineWidth;
        this.dashWidth = dashWidth;
        this.dashGap = dashGap;
        this.dashLineColor = SelectorUtil.getContext().getResources().getColor(dashLineColorResId);
        return this;
    }

    public SelectorShape dashLine(int dashLineWidth, String dashLineColor, float dashWidth, float dashGap) {
        this.isDashLine = true;
        this.dashLineWidth = dashLineWidth;
        this.dashWidth = dashWidth;
        this.dashGap = dashGap;
        this.dashLineColor = Color.parseColor((String)dashLineColor);
        return this;
    }

    public SelectorShape gradient(@ColorRes int startColor, @ColorRes int endColor) {
        this.isGradient = true;
        this.gradientColors = new int[2];
        this.gradientColors[0] = SelectorUtil.getContext().getResources().getColor(startColor);
        this.gradientColors[1] = SelectorUtil.getContext().getResources().getColor(endColor);
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        return this;
    }

    public SelectorShape gradient(String startColor, String endColor) {
        this.isGradient = true;
        this.gradientColors = new int[2];
        this.gradientColors[0] = Color.parseColor((String)startColor);
        this.gradientColors[1] = Color.parseColor((String)endColor);
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        return this;
    }

    public SelectorShape gradientLinear(int ... gradientColorsResId) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        if (gradientColorsResId.length > 1) {
            this.gradientColors = new int[gradientColorsResId.length];
            for (int i = 0; i < gradientColorsResId.length; ++i) {
                this.gradientColors[i] = SelectorUtil.getContext().getResources().getColor(gradientColorsResId[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientLinear(String ... gradientColorsResId) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        if (gradientColorsResId.length > 1) {
            this.gradientColors = new int[gradientColorsResId.length];
            for (int i = 0; i < gradientColorsResId.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColorsResId[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientLinear(String gradientOrientation, int ... gradientColorsResId) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = gradientOrientation;
        if (gradientColorsResId.length > 1) {
            this.gradientColors = new int[gradientColorsResId.length];
            for (int i = 0; i < gradientColorsResId.length; ++i) {
                this.gradientColors[i] = SelectorUtil.getContext().getResources().getColor(gradientColorsResId[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientLinear(String gradientOrientation, String ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = gradientOrientation;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientSweep(int ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 2;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = SelectorUtil.getContext().getResources().getColor(gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientSweep(String ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 2;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientRadial(float radialRadius, int ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 1;
        this.radialRadius = radialRadius;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = SelectorUtil.getContext().getResources().getColor(gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape gradientRadial(float radialRadius, String ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 1;
        this.radialRadius = radialRadius;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public SelectorShape radius(float radius) {
        this.isRadius = true;
        this.topRightRadius = radius;
        this.topLeftRadius = radius;
        this.bottomRightRadius = radius;
        this.bottomLeftRadius = radius;
        return this;
    }

    public SelectorShape trRadius(float topRightRadius) {
        this.isRadius = true;
        this.topRightRadius = topRightRadius;
        return this;
    }

    public SelectorShape tlRadius(float topLeftRadius) {
        this.isRadius = true;
        this.topLeftRadius = topLeftRadius;
        return this;
    }

    public SelectorShape brRadius(float bottomRightRadius) {
        this.isRadius = true;
        this.bottomRightRadius = bottomRightRadius;
        return this;
    }

    public SelectorShape blRadius(float bottomLeftRadius) {
        this.isRadius = true;
        this.bottomLeftRadius = bottomLeftRadius;
        return this;
    }

    @Override
    public void into(View view) {
        view.setBackground(this.createShape());
    }

    @Override
    public Drawable build() {
        return this.createShape();
    }

    private Drawable createShape() {
        GradientDrawable drawable2 = new GradientDrawable();
        if (shape == 1) {
            drawable2.setShape(1);
        } else {
            drawable2.setShape(0);
        }
        if (this.isRadius) {
            float[] radii = new float[]{this.dip2px(this.topLeftRadius), this.dip2px(this.topLeftRadius), this.dip2px(this.topRightRadius), this.dip2px(this.topRightRadius), this.dip2px(this.bottomRightRadius), this.dip2px(this.bottomRightRadius), this.dip2px(this.bottomLeftRadius), this.dip2px(this.bottomLeftRadius)};
            drawable2.setCornerRadii(radii);
        }
        if (this.isBackgroundColor) {
            drawable2.setColor(this.backgroundColor);
        }
        if (this.isLine) {
            drawable2.setStroke(this.dip2px(this.lineWidth), this.lineColor);
        }
        if (this.isDashLine) {
            drawable2.setStroke(this.dip2px(this.dashLineWidth), this.dashLineColor, (float)this.dip2px(this.dashWidth), (float)this.dip2px(this.dashGap));
        }
        if (this.isGradient) {
            switch (this.gradientType) {
                case 0: {
                    drawable2.setOrientation(this.createGradientOrientation());
                    break;
                }
                case 1: {
                    drawable2.setGradientRadius((float)this.dip2px(this.radialRadius));
                    break;
                }
            }
            drawable2.setGradientType(this.gradientType);
            drawable2.setColors(this.gradientColors);
        }
        return drawable2;
    }

    private GradientDrawable.Orientation createGradientOrientation() {
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.TOP_BOTTOM;
        switch (this.gradientOrientation) {
            case "TOP_BOTTOM": {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case "TR_BL": {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case "RIGHT_LEFT": {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case "BR_TL": {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case "BOTTOM_TOP": {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case "BL_TR": {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case "LEFT_RIGHT": {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case "TL_BR": {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    private int dip2px(float dipValue) {
        float scale = SelectorUtil.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    static {
        shape = 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GradientOrientation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Shape {
    }
}

