/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view.selector.selector;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorRes;
import android.view.View;
import android.widget.TextView;
import com.liujc.baseutils.view.selector.SelectorUtil;
import com.liujc.baseutils.view.selector.interfaces.ISelectorUtil;
import com.liujc.baseutils.view.selector.selector.ColorSelector;

public class DrawableSelector
implements ISelectorUtil<Drawable, View> {
    private static DrawableSelector mDrawableSelector;
    private Drawable mPressedDrawable;
    private Drawable mNormalDrawable;
    private boolean isSelectorColor;
    private ColorStateList mColorStateList;

    public static DrawableSelector getInstance() {
        mDrawableSelector = new DrawableSelector();
        return mDrawableSelector;
    }

    public DrawableSelector selectorBackground(Drawable pressedDrawable, Drawable normalDrawable) {
        this.mPressedDrawable = pressedDrawable;
        this.mNormalDrawable = normalDrawable;
        return this;
    }

    public DrawableSelector selectorColor(@ColorRes int pressedColorResId, @ColorRes int normalColorResId) {
        this.mColorStateList = ColorSelector.getInstance().selectorColor(SelectorUtil.getContext().getResources().getColor(pressedColorResId), SelectorUtil.getContext().getResources().getColor(normalColorResId)).build();
        this.isSelectorColor = true;
        return this;
    }

    public DrawableSelector selectorColor(String pressedColor, String normalColor) {
        this.mColorStateList = ColorSelector.getInstance().selectorColor(Color.parseColor((String)pressedColor), Color.parseColor((String)normalColor)).build();
        this.isSelectorColor = true;
        return this;
    }

    @Override
    public void into(View view) {
        view.setBackground((Drawable)this.createDrawableSelector());
        if (this.isSelectorColor) {
            try {
                ((TextView)view).setTextColor(this.mColorStateList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExceptionInInitializerError("\u8bbe\u7f6e\u5b57\u4f53\u989c\u8272\u9009\u62e9\u5668\uff08Selector\uff09\u8bf7\u4f20\u5165TextView\uff08\u5305\u62ecButton\uff09\uff01\uff01\uff01");
            }
        }
    }

    @Override
    public Drawable build() {
        return this.createDrawableSelector();
    }

    private StateListDrawable createDrawableSelector() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, this.mPressedDrawable);
        stateListDrawable.addState(new int[0], this.mNormalDrawable);
        return stateListDrawable;
    }
}

