/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import com.liujc.baseutils.R;

public final class ShortCutUtil {
    private ShortCutUtil() {
        throw new Error("Do not need instantiate!");
    }

    public static boolean hasShortcut(Activity activity) {
        boolean isInstallShortcut = false;
        ContentResolver cr = activity.getContentResolver();
        String AUTHORITY = "com.android.launcher.settings";
        Uri CONTENT_URI = Uri.parse((String)"content://com.android.launcher.settings/favorites?notify=true");
        Cursor c = cr.query(CONTENT_URI, new String[]{"title", "iconResource"}, "title=?", new String[]{activity.getString(R.string.app_name).trim()}, null);
        if (c != null && c.getCount() > 0) {
            isInstallShortcut = true;
        }
        return isInstallShortcut;
    }

    public static void addShortcut(Activity activity, @DrawableRes int img) {
        Intent shortcut = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
        shortcut.putExtra("android.intent.extra.shortcut.NAME", activity.getString(R.string.app_name));
        shortcut.putExtra("duplicate", false);
        Intent shortcutIntent = new Intent("android.intent.action.MAIN");
        shortcutIntent.setClassName((Context)activity, activity.getClass().getName());
        shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        Intent.ShortcutIconResource iconRes = Intent.ShortcutIconResource.fromContext((Context)activity, (int)img);
        shortcut.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconRes);
        activity.sendBroadcast(shortcut);
    }

    public static void delShortcut(Activity activity) {
        Intent shortcut = new Intent("com.android.launcher.action.UNINSTALL_SHORTCUT");
        shortcut.putExtra("android.intent.extra.shortcut.NAME", activity.getString(R.string.app_name));
        String appClass = activity.getPackageName() + "" + activity.getLocalClassName();
        ComponentName comp = new ComponentName(activity.getPackageName(), appClass);
        shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)new Intent("android.intent.action.MAIN").setComponent(comp));
        activity.sendBroadcast(shortcut);
    }
}

