/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import com.liujc.baseutils.common.LogUtil;

public class KeyguardLock {
    KeyguardManager keyguardManager;
    KeyguardManager.KeyguardLock keyguardLock;

    public KeyguardLock(Context context, String tag) {
        this.keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        this.keyguardLock = this.keyguardManager.newKeyguardLock(tag);
    }

    public boolean isKeyguardLocked() {
        if (Build.VERSION.SDK_INT < 16) {
            LogUtil.d("can not call isKeyguardLocked if SDK_INT < 16 ");
            return false;
        }
        return this.keyguardManager.isKeyguardLocked();
    }

    public boolean isKeyguardSecure() {
        if (Build.VERSION.SDK_INT < 16) {
            LogUtil.d("can not call isKeyguardSecure if SDK_INT < 16 ");
            return false;
        }
        return this.keyguardManager.isKeyguardSecure();
    }

    public boolean inKeyguardRestrictedInputMode() {
        return this.keyguardManager.inKeyguardRestrictedInputMode();
    }

    public void disableKeyguard() {
        this.keyguardLock.disableKeyguard();
    }

    public void reenableKeyguard() {
        this.keyguardLock.reenableKeyguard();
    }

    public void release() {
        if (this.keyguardLock != null) {
            this.keyguardLock.reenableKeyguard();
        }
    }

    public KeyguardManager getKeyguardManager() {
        return this.keyguardManager;
    }

    public void setKeyguardManager(KeyguardManager keyguardManager) {
        this.keyguardManager = keyguardManager;
    }

    public KeyguardManager.KeyguardLock getKeyguardLock() {
        return this.keyguardLock;
    }

    public void setKeyguardLock(KeyguardManager.KeyguardLock keyguardLock) {
        this.keyguardLock = keyguardLock;
    }
}

