/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;

public class FlashLight {
    private Camera camera;
    private Handler handler = new Handler();
    private static final int OFF_TIME = 180000;

    public boolean turnOnFlashLight() {
        if (this.camera == null) {
            this.camera = Camera.open();
            this.camera.startPreview();
            Camera.Parameters parameter = this.camera.getParameters();
            if (Build.VERSION.SDK_INT >= 5) {
                parameter.setFlashMode("torch");
            } else {
                parameter.set("flash-mode", "torch");
            }
            this.camera.setParameters(parameter);
            this.handler.removeCallbacksAndMessages(null);
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FlashLight.this.turnOffFlashLight();
                }
            }, 180000L);
        }
        return true;
    }

    public boolean turnOffFlashLight() {
        if (this.camera != null) {
            this.handler.removeCallbacksAndMessages(null);
            Camera.Parameters parameter = this.camera.getParameters();
            if (Build.VERSION.SDK_INT >= 5) {
                parameter.setFlashMode("off");
            } else {
                parameter.set("flash-mode", "off");
            }
            this.camera.setParameters(parameter);
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
        }
        return true;
    }
}

