/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.sucurity;

import com.liujc.baseutils.common.StringUtil;
import com.liujc.baseutils.convert.ConvertUtil;
import com.liujc.baseutils.file.CloseUtil;
import com.liujc.baseutils.sucurity.EncodeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtil {
    public static String DES_Transformation = "DES/ECB/NoPadding";
    private static final String DES_Algorithm = "DES";
    public static String TripleDES_Transformation = "DESede/ECB/NoPadding";
    private static final String TripleDES_Algorithm = "DESede";
    public static String AES_Transformation = "AES/ECB/NoPadding";
    private static final String AES_Algorithm = "AES";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    private EncryptUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String encryptMD2ToString(String data) {
        return EncryptUtil.encryptMD2ToString(data.getBytes());
    }

    public static String encryptMD2ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptMD2(data));
    }

    public static byte[] encryptMD2(byte[] data) {
        return EncryptUtil.hashTemplate(data, "MD2");
    }

    public static String encryptMD5ToString(String data) {
        return EncryptUtil.encryptMD5ToString(data.getBytes());
    }

    public static String encryptMD5ToString(String data, String salt) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptMD5((data + salt).getBytes()));
    }

    public static String encryptMD5ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptMD5(data));
    }

    public static String encryptMD5ToString(byte[] data, byte[] salt) {
        if (data == null || salt == null) {
            return null;
        }
        byte[] dataSalt = new byte[data.length + salt.length];
        System.arraycopy(data, 0, dataSalt, 0, data.length);
        System.arraycopy(salt, 0, dataSalt, data.length, salt.length);
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptMD5(dataSalt));
    }

    public static byte[] encryptMD5(byte[] data) {
        return EncryptUtil.hashTemplate(data, "MD5");
    }

    public static String encryptMD5File2String(String filePath) {
        File file = StringUtil.isSpace(filePath) ? null : new File(filePath);
        return EncryptUtil.encryptMD5File2String(file);
    }

    public static byte[] encryptMD5File(String filePath) {
        File file = StringUtil.isSpace(filePath) ? null : new File(filePath);
        return EncryptUtil.encryptMD5File(file);
    }

    public static String encryptMD5File2String(File file) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptMD5File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptMD5File(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(fis);
                throw throwable;
            }
            CloseUtil.closeIO(fis);
            return byArray2;
        }
        CloseUtil.closeIO(fis);
        return byArray;
    }

    public static String encryptSHA1ToString(String data) {
        return EncryptUtil.encryptSHA1ToString(data.getBytes());
    }

    public static String encryptSHA1ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptSHA1(data));
    }

    public static byte[] encryptSHA1(byte[] data) {
        return EncryptUtil.hashTemplate(data, "SHA1");
    }

    public static String encryptSHA224ToString(String data) {
        return EncryptUtil.encryptSHA224ToString(data.getBytes());
    }

    public static String encryptSHA224ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptSHA224(data));
    }

    public static byte[] encryptSHA224(byte[] data) {
        return EncryptUtil.hashTemplate(data, "SHA224");
    }

    public static String encryptSHA256ToString(String data) {
        return EncryptUtil.encryptSHA256ToString(data.getBytes());
    }

    public static String encryptSHA256ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptSHA256(data));
    }

    public static byte[] encryptSHA256(byte[] data) {
        return EncryptUtil.hashTemplate(data, "SHA256");
    }

    public static String encryptSHA384ToString(String data) {
        return EncryptUtil.encryptSHA384ToString(data.getBytes());
    }

    public static String encryptSHA384ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptSHA384(data));
    }

    public static byte[] encryptSHA384(byte[] data) {
        return EncryptUtil.hashTemplate(data, "SHA384");
    }

    public static String encryptSHA512ToString(String data) {
        return EncryptUtil.encryptSHA512ToString(data.getBytes());
    }

    public static String encryptSHA512ToString(byte[] data) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptSHA512(data));
    }

    public static byte[] encryptSHA512(byte[] data) {
        return EncryptUtil.hashTemplate(data, "SHA512");
    }

    private static byte[] hashTemplate(byte[] data, String algorithm) {
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptHmacMD5ToString(String data, String key) {
        return EncryptUtil.encryptHmacMD5ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacMD5ToString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptHmacMD5(data, key));
    }

    public static byte[] encryptHmacMD5(byte[] data, byte[] key) {
        return EncryptUtil.hmacTemplate(data, key, "HmacMD5");
    }

    public static String encryptHmacSHA1ToString(String data, String key) {
        return EncryptUtil.encryptHmacSHA1ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA1ToString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptHmacSHA1(data, key));
    }

    public static byte[] encryptHmacSHA1(byte[] data, byte[] key) {
        return EncryptUtil.hmacTemplate(data, key, "HmacSHA1");
    }

    public static String encryptHmacSHA224ToString(String data, String key) {
        return EncryptUtil.encryptHmacSHA224ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA224ToString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptHmacSHA224(data, key));
    }

    public static byte[] encryptHmacSHA224(byte[] data, byte[] key) {
        return EncryptUtil.hmacTemplate(data, key, "HmacSHA224");
    }

    public static String encryptHmacSHA256ToString(String data, String key) {
        return EncryptUtil.encryptHmacSHA256ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA256ToString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptHmacSHA256(data, key));
    }

    public static byte[] encryptHmacSHA256(byte[] data, byte[] key) {
        return EncryptUtil.hmacTemplate(data, key, "HmacSHA256");
    }

    public static String encryptHmacSHA384ToString(String data, String key) {
        return EncryptUtil.encryptHmacSHA384ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA384ToString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptHmacSHA384(data, key));
    }

    public static byte[] encryptHmacSHA384(byte[] data, byte[] key) {
        return EncryptUtil.hmacTemplate(data, key, "HmacSHA384");
    }

    public static String encryptHmacSHA512ToString(String data, String key) {
        return EncryptUtil.encryptHmacSHA512ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA512ToString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptHmacSHA512(data, key));
    }

    public static byte[] encryptHmacSHA512(byte[] data, byte[] key) {
        return EncryptUtil.hmacTemplate(data, key, "HmacSHA512");
    }

    private static byte[] hmacTemplate(byte[] data, byte[] key, String algorithm) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptDES2Base64(byte[] data, byte[] key) {
        return EncodeUtil.base64Encode(EncryptUtil.encryptDES(data, key));
    }

    public static String encryptDES2HexString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptDES(data, key));
    }

    public static byte[] encryptDES(byte[] data, byte[] key) {
        return EncryptUtil.desTemplate(data, key, DES_Algorithm, DES_Transformation, true);
    }

    public static byte[] decryptBase64DES(byte[] data, byte[] key) {
        return EncryptUtil.decryptDES(EncodeUtil.base64Decode(data), key);
    }

    public static byte[] decryptHexStringDES(String data, byte[] key) {
        return EncryptUtil.decryptDES(ConvertUtil.hexString2Bytes(data), key);
    }

    public static byte[] decryptDES(byte[] data, byte[] key) {
        return EncryptUtil.desTemplate(data, key, DES_Algorithm, DES_Transformation, false);
    }

    public static byte[] encrypt3DES2Base64(byte[] data, byte[] key) {
        return EncodeUtil.base64Encode(EncryptUtil.encrypt3DES(data, key));
    }

    public static String encrypt3DES2HexString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encrypt3DES(data, key));
    }

    public static byte[] encrypt3DES(byte[] data, byte[] key) {
        return EncryptUtil.desTemplate(data, key, TripleDES_Algorithm, TripleDES_Transformation, true);
    }

    public static byte[] decryptBase64_3DES(byte[] data, byte[] key) {
        return EncryptUtil.decrypt3DES(EncodeUtil.base64Decode(data), key);
    }

    public static byte[] decryptHexString3DES(String data, byte[] key) {
        return EncryptUtil.decrypt3DES(ConvertUtil.hexString2Bytes(data), key);
    }

    public static byte[] decrypt3DES(byte[] data, byte[] key) {
        return EncryptUtil.desTemplate(data, key, TripleDES_Algorithm, TripleDES_Transformation, false);
    }

    public static byte[] encryptAES2Base64(byte[] data, byte[] key) {
        return EncodeUtil.base64Encode(EncryptUtil.encryptAES(data, key));
    }

    public static String encryptAES2HexString(byte[] data, byte[] key) {
        return ConvertUtil.bytes2HexString(EncryptUtil.encryptAES(data, key));
    }

    public static byte[] encryptAES(byte[] data, byte[] key) {
        return EncryptUtil.desTemplate(data, key, AES_Algorithm, AES_Transformation, true);
    }

    public static byte[] decryptBase64AES(byte[] data, byte[] key) {
        return EncryptUtil.decryptAES(EncodeUtil.base64Decode(data), key);
    }

    public static byte[] decryptHexStringAES(String data, byte[] key) {
        return EncryptUtil.decryptAES(ConvertUtil.hexString2Bytes(data), key);
    }

    public static byte[] decryptAES(byte[] data, byte[] key) {
        return EncryptUtil.desTemplate(data, key, AES_Algorithm, AES_Transformation, false);
    }

    public static byte[] desTemplate(byte[] data, byte[] key, String algorithm, String transformation, boolean isEncrypt) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(transformation);
            SecureRandom random = new SecureRandom();
            cipher.init(isEncrypt ? 1 : 2, (Key)keySpec, random);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return EncodeUtil.base64Encode2String(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return EncodeUtil.base64Encode2String(key.getEncoded());
    }

    public static byte[] decryptByPrivateKey(byte[] data, String key) throws Exception {
        byte[] keyBytes = EncodeUtil.base64Decode(key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(byte[] data, String key) throws Exception {
        byte[] keyBytes = EncodeUtil.base64Decode(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, String key) throws Exception {
        byte[] keyBytes = EncodeUtil.base64Decode(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPrivateKey(byte[] data, String key) throws Exception {
        byte[] keyBytes = EncodeUtil.base64Decode(key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = EncodeUtil.base64Decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return EncodeUtil.base64Encode2String(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = EncodeUtil.base64Decode(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(EncodeUtil.base64Decode(sign));
    }
}

