/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.convert;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.liujc.baseutils.common.ConstantUtil;
import com.liujc.baseutils.common.StringUtil;
import com.liujc.baseutils.file.CloseUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class ConvertUtil {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ConvertUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        if (len <= 0) {
            return null;
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = hexDigits[bytes[i] >>> 4 & 0xF];
            ret[j++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] hexString2Bytes(String hexString) {
        if (StringUtil.isSpace(hexString)) {
            return null;
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            hexString = "0" + hexString;
            ++len;
        }
        char[] hexBytes = hexString.toUpperCase().toCharArray();
        byte[] ret = new byte[len >> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(ConvertUtil.hex2Dec(hexBytes[i]) << 4 | ConvertUtil.hex2Dec(hexBytes[i + 1]));
        }
        return ret;
    }

    private static int hex2Dec(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    public static byte[] chars2Bytes(char[] chars) {
        if (chars == null || chars.length <= 0) {
            return null;
        }
        int len = chars.length;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static char[] bytes2Chars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        if (len <= 0) {
            return null;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    public static double byte2Size(long byteNum, ConstantUtil.MemoryUnit unit) {
        if (byteNum < 0L) {
            return -1.0;
        }
        switch (unit) {
            default: {
                return (double)byteNum / 1.0;
            }
            case KB: {
                return (double)byteNum / 1024.0;
            }
            case MB: {
                return (double)byteNum / 1048576.0;
            }
            case GB: 
        }
        return (double)byteNum / 1.073741824E9;
    }

    public static long size2Byte(long size, ConstantUtil.MemoryUnit unit) {
        if (size < 0L) {
            return -1L;
        }
        switch (unit) {
            default: {
                return size * 1L;
            }
            case KB: {
                return size * 1024L;
            }
            case MB: {
                return size * 0x100000L;
            }
            case GB: 
        }
        return size * 0x40000000L;
    }

    public static String byte2FitSize(long byteNum) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format(Locale.getDefault(), "%.3fB", (double)byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format(Locale.getDefault(), "%.3fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format(Locale.getDefault(), "%.3fMB", (double)byteNum / 1048576.0);
        }
        return String.format(Locale.getDefault(), "%.3fGB", (double)byteNum / 1.073741824E9);
    }

    public static String bytes2Bits(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            for (int j = 7; j >= 0; --j) {
                sb.append((aByte >> j & 1) == 0 ? (char)'0' : '1');
            }
        }
        return sb.toString();
    }

    public static byte[] bits2Bytes(String bits) {
        int lenMod = bits.length() % 8;
        int byteLen = bits.length() / 8;
        if (lenMod != 0) {
            for (int i = lenMod; i < 8; ++i) {
                bits = "0" + bits;
            }
            ++byteLen;
        }
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                bytes[n] = (byte)(bytes[n] << 1);
                int n2 = i;
                bytes[n2] = (byte)(bytes[n2] | bits.charAt(i * 8 + j) - 48);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream input2OutputStream(InputStream is) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (is == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                os.write(b, 0, len);
            }
            byteArrayOutputStream = os;
        }
        catch (IOException e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                e.printStackTrace();
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(is);
                throw throwable;
            }
            CloseUtil.closeIO(is);
            return byteArrayOutputStream2;
        }
        CloseUtil.closeIO(is);
        return byteArrayOutputStream;
    }

    public ByteArrayInputStream output2InputStream(OutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
    }

    public static byte[] inputStream2Bytes(InputStream is) {
        if (is == null) {
            return null;
        }
        return ConvertUtil.input2OutputStream(is).toByteArray();
    }

    public static InputStream bytes2InputStream(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static byte[] outputStream2Bytes(OutputStream out) {
        if (out == null) {
            return null;
        }
        return ((ByteArrayOutputStream)out).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytes2OutputStream(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            os.write(bytes);
            byteArrayOutputStream = os;
        }
        catch (IOException e) {
            OutputStream outputStream;
            try {
                e.printStackTrace();
                outputStream = null;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(os);
                throw throwable;
            }
            CloseUtil.closeIO(os);
            return outputStream;
        }
        CloseUtil.closeIO(os);
        return byteArrayOutputStream;
    }

    public static String inputStream2String(InputStream is, String charsetName) {
        if (is == null || StringUtil.isSpace(charsetName)) {
            return null;
        }
        try {
            return new String(ConvertUtil.inputStream2Bytes(is), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream string2InputStream(String string, String charsetName) {
        if (string == null || StringUtil.isSpace(charsetName)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputStream2String(OutputStream out, String charsetName) {
        if (out == null || StringUtil.isSpace(charsetName)) {
            return null;
        }
        try {
            return new String(ConvertUtil.outputStream2Bytes(out), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OutputStream string2OutputStream(String string, String charsetName) {
        if (string == null || StringUtil.isSpace(charsetName)) {
            return null;
        }
        try {
            return ConvertUtil.bytes2OutputStream(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap, Bitmap.CompressFormat format) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(format, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap bytes2Bitmap(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap drawable2Bitmap(Drawable drawable) {
        return drawable == null ? null : ((BitmapDrawable)drawable).getBitmap();
    }

    public static Drawable bitmap2Drawable(Resources res, Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(res, bitmap);
    }

    public static byte[] drawable2Bytes(Drawable drawable, Bitmap.CompressFormat format) {
        return drawable == null ? null : ConvertUtil.bitmap2Bytes(ConvertUtil.drawable2Bitmap(drawable), format);
    }

    public static Drawable bytes2Drawable(Resources res, byte[] bytes) {
        return res == null ? null : ConvertUtil.bitmap2Drawable(res, ConvertUtil.bytes2Bitmap(bytes));
    }

    public static Bitmap view2Bitmap(View view) {
        if (view == null) {
            return null;
        }
        Bitmap ret = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(ret);
        Drawable bgDrawable = view.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        view.draw(canvas);
        return ret;
    }

    public static Object byteToObject(byte[] bytes) throws Exception {
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByte(Object obj) throws Exception {
        try (ObjectOutputStream oos = null;){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static void byteToBit(byte[] bytes, StringBuilder sb) {
        for (int i = 0; i < 8 * bytes.length; ++i) {
            sb.append((bytes[i / 8] << i % 8 & 0x80) == 0 ? (char)'0' : '1');
        }
    }

    public static String byteToBit(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8 * bytes.length; ++i) {
            sb.append((bytes[i / 8] << i % 8 & 0x80) == 0 ? (char)'0' : '1');
        }
        return sb.toString();
    }
}

