package com.liujc.baseutils.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;

import com.liujc.baseutils.BaseUtilContext;

/**
 * 类名称：ToastUitl
 * 创建者：Create by liujc
 * 创建时间：Create on 2016/11/15 15:39
 * 描述：Toast统一管理类
 * 最近修改时间：2016/11/15 15:39
 * 修改人：Modify by liujc
 */
public class ToastUitl {

    private static Toast toast;
    private static Toast toast2;

    private static Toast initToast(CharSequence message, int duration) {
        if (toast == null) {
            toast = Toast.makeText(BaseUtilContext.getContext(), message, duration);
        } else {
            toast.setText(message);
            toast.setDuration(duration);
        }
        return toast;
    }

    /**
     * 短时间显示Toast
     *
     * @param message
     */
    public static void showShort(CharSequence message) {
        initToast(message, Toast.LENGTH_SHORT).show();
    }


    /**
     * 短时间显示Toast
     *
     * @param strResId
     */
    public static void showShort(int strResId) {
//		Toast.makeText(context, strResId, Toast.LENGTH_SHORT).show();
        initToast(BaseUtilContext.getContext().getResources().getText(strResId), Toast.LENGTH_SHORT).show();
    }

    /**
     * 长时间显示Toast
     *
     * @param message
     */
    public static void showLong(CharSequence message) {
        initToast(message, Toast.LENGTH_LONG).show();
    }

    /**
     * 长时间显示Toast
     *
     * @param strResId
     */
    public static void showLong(int strResId) {
        initToast(BaseUtilContext.getContext().getResources().getText(strResId), Toast.LENGTH_LONG).show();
    }

    /**
     * 自定义显示Toast时间
     *
     * @param message
     * @param duration
     */
    public static void show(CharSequence message, int duration) {
        initToast(message, duration).show();
    }

    /**
     * 自定义显示Toast时间
     *
     * @param context
     * @param strResId
     * @param duration
     */
    public static void show(Context context, int strResId, int duration) {
        initToast(context.getResources().getText(strResId), duration).show();
    }

//    /**
//     * 显示有image的toast
//     *
//     * @param tvStr
//     * @param imageResource
//     * @return
//     */
//    public static Toast showToastWithImg(final String tvStr, final int imageResource) {
//        if (toast2 == null) {
//            toast2 = new Toast(BaseUtilContext.getContext());
//        }
//        View view = LayoutInflater.from(BaseUtilContext.getContext()).inflate(R.layout.toast_custom, null);
//        TextView tv = (TextView) view.findViewById(R.id.toast_custom_tv);
//        tv.setText(TextUtils.isEmpty(tvStr) ? "" : tvStr);
//        ImageView iv = (ImageView) view.findViewById(R.id.toast_custom_iv);
//        if (imageResource > 0) {
//            iv.setVisibility(View.VISIBLE);
//            iv.setImageResource(imageResource);
//        } else {
//            iv.setVisibility(View.GONE);
//        }
//        toast2.setView(view);
//        toast2.setGravity(Gravity.CENTER, 0, 0);
//        toast2.show();
//        return toast2;
//    }


    /**
     * @param toastLayout  自定义布局
     * @param gravity   显示位置
     * @return
     */
    public static Toast setToastLayout(final int toastLayout,int gravity) {
        if (toast2 == null) {
            toast2 = new Toast(BaseUtilContext.getContext());
        }
        View view = LayoutInflater.from(BaseUtilContext.getContext()).inflate(toastLayout, null);
        toast2.setView(view);
        toast2.setGravity(gravity, 0, 0);
        return toast2;
    }
}
