/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.logcat;

import com.android.tools.utp.plugins.common.HostPluginAdapter;
import com.android.tools.utp.plugins.host.logcat.proto.AndroidTestLogcatConfigProto;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.config.ProtoConfig;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.event.Events;
import com.google.testing.platform.api.plugin.HostPluginExtKt;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.core.IssueProto;
import com.google.testing.platform.proto.api.core.PathProto;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 J2\u00020\u0001:\u0001JB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J \u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00100\u001a\u000201H\u0016J\u001a\u00109\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u000201H\u0016J\b\u0010<\u001a\u000203H\u0016J\b\u0010=\u001a\u000208H\u0002J\u0010\u0010>\u001a\u0002082\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010?\u001a\n @*\u0004\u0018\u00010'0'2\u0006\u0010A\u001a\u00020'2\u0006\u0010B\u001a\u00020'H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010'2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010D\u001a\u0002082\u0006\u0010E\u001a\u00020'H\u0002J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0010\u0010G\u001a\u00020#2\u0006\u0010H\u001a\u000201H\u0002J\b\u0010I\u001a\u000208H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin;", "Lcom/android/tools/utp/plugins/common/HostPluginAdapter;", "logger", "Ljava/util/logging/Logger;", "logcatTimeoutSeconds", "", "(Ljava/util/logging/Logger;J)V", "allTestFinished", "Ljava/util/concurrent/atomic/AtomicBoolean;", "context", "Lcom/google/testing/platform/api/context/Context;", "crashHappened", "crashLogFinished", "Ljava/util/concurrent/CountDownLatch;", "crashLogcatFile", "Ljava/io/File;", "crashLogcatFinishMatcher", "Lkotlin/text/Regex;", "getCrashLogcatFinishMatcher", "()Lkotlin/text/Regex;", "crashLogcatFinishMatcher$delegate", "Lkotlin/Lazy;", "crashLogcatProgressMatcher", "getCrashLogcatProgressMatcher", "crashLogcatProgressMatcher$delegate", "crashLogcatStartMatcher", "crashLogcatWriter", "Ljava/io/BufferedWriter;", "currentLogcatFile", "currentLogcatLock", "", "currentLogcatWriter", "expectedTestCaseNum", "Ljava/util/concurrent/atomic/AtomicInteger;", "logcatCommandHandle", "Lcom/google/testing/platform/api/device/CommandHandle;", "logcatCounter", "logcatOptions", "", "", "logcatTextProcessFinished", "outputDir", "processedLogcatNum", "targetTestProcessName", "testPid", "afterAllWithReturn", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "testSuiteResult", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "cancelled", "", "afterEachWithReturn", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "testResult", "beforeAll", "", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "closeCurrentLogcatWriter", "configure", "generateLogcatFileName", "kotlin.jvm.PlatformType", "testPackageAndClass", "testMethod", "getDeviceCurrentTime", "parseLine", "line", "setUpLogcatCommandLine", "startLogcatAsync", "controller", "stopLogcat", "Companion", "android-test-plugin-host-logcat"})
@SourceDebugExtension(value={"SMAP\nAndroidTestLogcatPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestLogcatPlugin.kt\ncom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
public final class AndroidTestLogcatPlugin
extends HostPluginAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private final long logcatTimeoutSeconds;
    private String outputDir;
    @NotNull
    private final CountDownLatch logcatTextProcessFinished;
    @NotNull
    private final AtomicInteger processedLogcatNum;
    @NotNull
    private final AtomicBoolean allTestFinished;
    @NotNull
    private final AtomicInteger expectedTestCaseNum;
    @NotNull
    private final Object currentLogcatLock;
    @Nullable
    private File currentLogcatFile;
    @Nullable
    private BufferedWriter currentLogcatWriter;
    private CommandHandle logcatCommandHandle;
    private File crashLogcatFile;
    private BufferedWriter crashLogcatWriter;
    private String targetTestProcessName;
    private Regex crashLogcatStartMatcher;
    private String testPid;
    private Context context;
    @NotNull
    private final CountDownLatch crashLogFinished;
    @NotNull
    private final CountDownLatch logcatCounter;
    @NotNull
    private List<String> logcatOptions;
    @NotNull
    private AtomicBoolean crashHappened;
    @NotNull
    private final Lazy crashLogcatFinishMatcher$delegate;
    @NotNull
    private final Lazy crashLogcatProgressMatcher$delegate;
    @NotNull
    private static final String TEST_CRASH_INDICATOR = "E AndroidRuntime: ";
    private static final long LOGCAT_TIMEOUT_SECONDS = 10L;

    public AndroidTestLogcatPlugin(@NotNull Logger logger, long logcatTimeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.logcatTimeoutSeconds = logcatTimeoutSeconds;
        this.logcatTextProcessFinished = new CountDownLatch(1);
        this.processedLogcatNum = new AtomicInteger(0);
        this.allTestFinished = new AtomicBoolean(false);
        this.expectedTestCaseNum = new AtomicInteger(0);
        this.currentLogcatLock = new Object();
        this.crashLogFinished = new CountDownLatch(1);
        this.logcatCounter = new CountDownLatch(5);
        this.logcatOptions = new ArrayList();
        this.crashHappened = new AtomicBoolean(false);
        this.crashLogcatFinishMatcher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Regex>(this){
            final /* synthetic */ AndroidTestLogcatPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Regex invoke() {
                String string = AndroidTestLogcatPlugin.access$getTestPid$p(this.this$0);
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"testPid");
                    string = null;
                }
                return new Regex(".*I\\sProcess.*Sending\\ssignal.*PID:.*" + string + ".*SIG:\\s9");
            }
        }));
        this.crashLogcatProgressMatcher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Regex>(this){
            final /* synthetic */ AndroidTestLogcatPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Regex invoke() {
                String string = AndroidTestLogcatPlugin.access$getTestPid$p(this.this$0);
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"testPid");
                    string = null;
                }
                return new Regex(".*" + string + ".*E AndroidRuntime: .*");
            }
        }));
    }

    public /* synthetic */ AndroidTestLogcatPlugin(Logger logger, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = LoggerExtKt.getLogger((Object)Companion);
        }
        if ((n & 2) != 0) {
            l = 10L;
        }
        this(logger, l);
    }

    private final Regex getCrashLogcatFinishMatcher() {
        Lazy lazy = this.crashLogcatFinishMatcher$delegate;
        return (Regex)lazy.getValue();
    }

    private final Regex getCrashLogcatProgressMatcher() {
        Lazy lazy = this.crashLogcatProgressMatcher$delegate;
        return (Regex)lazy.getValue();
    }

    public void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get("config");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.testing.platform.api.config.ProtoConfig");
        ProtoConfig config = (ProtoConfig)object;
        this.outputDir = ConfigExtKt.getEnvironment((Config)((Config)config)).getOutputDirectory();
        Any any = config.getConfigProto();
        Intrinsics.checkNotNull((Object)any);
        String string = AndroidTestLogcatConfigProto.AndroidTestLogcatConfig.parseFrom((ByteString)any.getValue()).getTargetTestProcessName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTargetTestProcessName(...)");
        this.targetTestProcessName = string;
        String string2 = this.targetTestProcessName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetTestProcessName");
            string2 = null;
        }
        this.crashLogcatStartMatcher = new Regex(".*E\\sAndroidRuntime:\\sProcess:\\s" + string2 + ".*");
        this.context = context;
    }

    public void beforeAll(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.logger.info("Start logcat streaming.");
        this.logcatCommandHandle = this.startLogcatAsync(deviceController);
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    @NotNull
    public TestResultProto.TestResult afterEachWithReturn(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        TestArtifactProto.Artifact.Builder builder;
        TestResultProto.TestResult.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.expectedTestCaseNum.incrementAndGet();
        TestCaseProto.TestCase testCase = testResult.getTestCase();
        String packageName = testCase.getTestPackage();
        String className = testCase.getTestClass();
        String methodName = testCase.getTestMethod();
        TestResultProto.TestResult.Builder $this$afterEachWithReturn_u24lambda_u241 = builder2 = testResult.toBuilder();
        boolean bl = false;
        TestArtifactProto.Artifact.Builder $this$afterEachWithReturn_u24lambda_u241_u24lambda_u240 = builder = $this$afterEachWithReturn_u24lambda_u241.addOutputArtifactBuilder();
        boolean bl2 = false;
        $this$afterEachWithReturn_u24lambda_u241_u24lambda_u240.getLabelBuilder().setLabel("logcat");
        $this$afterEachWithReturn_u24lambda_u241_u24lambda_u240.getLabelBuilder().setNamespace("android");
        PathProto.Path.Builder builder3 = $this$afterEachWithReturn_u24lambda_u241_u24lambda_u240.getSourcePathBuilder();
        String string = packageName + "." + className;
        Intrinsics.checkNotNull((Object)methodName);
        builder3.setPath(this.generateLogcatFileName(string, methodName));
        TestResultProto.TestResult.Builder it = builder2 = builder2.build();
        boolean bl3 = false;
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        Events events = ContextExtKt.getEvents((Context)context);
        Intrinsics.checkNotNull((Object)it);
        HostPluginExtKt.sendTestResultUpdate((Events)events, (TestResultProto.TestResult)it);
        TestResultProto.TestResult.Builder builder4 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"also(...)");
        return builder4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TestSuiteResultProto.TestSuiteResult afterAllWithReturn(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        if (this.expectedTestCaseNum.get() > this.processedLogcatNum.get()) {
            this.allTestFinished.set(true);
            if (!this.logcatTextProcessFinished.await(this.logcatTimeoutSeconds, TimeUnit.SECONDS)) {
                this.logger.warning("Failed to retrieve logcat for some test cases. We retrieved logcat for " + this.processedLogcatNum.get() + " test cases out of " + this.expectedTestCaseNum.get() + " tests.");
            }
        }
        this.logcatCounter.await(this.logcatTimeoutSeconds, TimeUnit.SECONDS);
        TestSuiteResultProto.TestSuiteResult updatedTestSuiteResult = testSuiteResult;
        if (this.crashHappened.get()) {
            TestSuiteResultProto.TestSuiteResult.Builder builder;
            String string;
            IssueProto.Issue.Builder builder2;
            this.crashLogFinished.await(this.logcatTimeoutSeconds, TimeUnit.SECONDS);
            IssueProto.Issue.Builder $this$afterAllWithReturn_u24lambda_u244 = builder2 = IssueProto.Issue.newBuilder();
            boolean bl = false;
            $this$afterAllWithReturn_u24lambda_u244.setSeverity(IssueProto.Issue.Severity.SEVERE);
            File file = this.crashLogcatFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"crashLogcatFile");
                file = null;
            }
            Object object = file;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            IssueProto.Issue.Builder builder3 = $this$afterAllWithReturn_u24lambda_u244;
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl2 = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            builder3.setMessage("Logcat of last crash: \n" + string);
            IssueProto.Issue issue = builder2.build();
            TestSuiteResultProto.TestSuiteResult.Builder $this$afterAllWithReturn_u24lambda_u245 = builder = testSuiteResult.toBuilder();
            boolean bl3 = false;
            $this$afterAllWithReturn_u24lambda_u245.addIssue(issue);
            TestSuiteResultProto.TestSuiteResult testSuiteResult2 = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)testSuiteResult2, (String)"build(...)");
            updatedTestSuiteResult = testSuiteResult2;
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            Events events = ContextExtKt.getEvents((Context)context);
            Intrinsics.checkNotNull((Object)issue);
            HostPluginExtKt.sendIssue((Events)events, (IssueProto.Issue)issue);
        }
        this.stopLogcat();
        return updatedTestSuiteResult;
    }

    public boolean canRun() {
        return true;
    }

    private final String generateLogcatFileName(String testPackageAndClass, String testMethod) {
        String string = this.outputDir;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            string = null;
        }
        return new File(string, "logcat-" + testPackageAndClass + "-" + testMethod + ".txt").getAbsolutePath();
    }

    private final String getDeviceCurrentTime(DeviceController deviceController) {
        Object[] objectArray = new String[]{"date", "+%m-%d\\ %H:%M:%S"};
        CommandResult dateCommandResult = AndroidDeviceControllerExtKt.deviceShell$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        if (dateCommandResult.getStatusCode() != 0 || dateCommandResult.getOutput().isEmpty()) {
            this.logger.warning("Failed to read device time.");
            return null;
        }
        return "'" + dateCommandResult.getOutput().get(0) + ".000'";
    }

    private final List<String> setUpLogcatCommandLine() {
        List logcatCommand;
        List $this$setUpLogcatCommandLine_u24lambda_u246 = logcatCommand = (List)new ArrayList();
        boolean bl = false;
        $this$setUpLogcatCommandLine_u24lambda_u246.add("shell");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("logcat");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("-v");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("threadtime");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("-b");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("main");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("-b");
        $this$setUpLogcatCommandLine_u24lambda_u246.add("crash");
        $this$setUpLogcatCommandLine_u24lambda_u246.addAll((Collection)this.logcatOptions);
        return logcatCommand;
    }

    private final CommandHandle startLogcatAsync(DeviceController controller) {
        String deviceTime = this.getDeviceCurrentTime(controller);
        if (deviceTime != null) {
            Object[] objectArray = new String[]{"-T", deviceTime};
            this.logcatOptions = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        Ref.BooleanRef testRunInProgress = new Ref.BooleanRef();
        return controller.executeAsync(this.setUpLogcatCommandLine(), (Function1)new Function1<String, Unit>(this, testRunInProgress){
            final /* synthetic */ AndroidTestLogcatPlugin this$0;
            final /* synthetic */ Ref.BooleanRef $testRunInProgress;
            {
                this.this$0 = $receiver;
                this.$testRunInProgress = $testRunInProgress;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull String line) {
                Object object;
                Object object2;
                String[] stringArray;
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                AndroidTestLogcatPlugin.access$getLogcatCounter$p(this.this$0).countDown();
                if (!AndroidTestLogcatPlugin.access$getCrashHappened$p(this.this$0).get()) {
                    stringArray = (String[])line;
                    Regex regex = AndroidTestLogcatPlugin.access$getCrashLogcatStartMatcher$p(this.this$0);
                    if (regex == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"crashLogcatStartMatcher");
                        regex = null;
                    }
                    if (regex.matches((CharSequence)stringArray)) {
                        String string = AndroidTestLogcatPlugin.access$getTargetTestProcessName$p(this.this$0);
                        if (string == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"targetTestProcessName");
                            string = null;
                        }
                        AndroidTestLogcatPlugin.access$setCrashLogcatFile$p(this.this$0, new File(AndroidTestLogcatPlugin.access$generateLogcatFileName(this.this$0, string, "crash-report")));
                        File file = AndroidTestLogcatPlugin.access$getCrashLogcatFile$p(this.this$0);
                        if (file == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"crashLogcatFile");
                            file = null;
                        }
                        stringArray = file;
                        stringArray = new FileOutputStream((File)stringArray);
                        object2 = Charsets.UTF_8;
                        object = new OutputStreamWriter((OutputStream)stringArray, (Charset)object2);
                        int n = 8192;
                        AndroidTestLogcatPlugin.access$setCrashLogcatWriter$p(this.this$0, object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
                        AndroidTestLogcatPlugin.access$getCrashHappened$p(this.this$0).set(true);
                        stringArray = new String[]{" "};
                        AndroidTestLogcatPlugin.access$setTestPid$p(this.this$0, (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
                    }
                }
                if (AndroidTestLogcatPlugin.access$getCrashHappened$p(this.this$0).get()) {
                    stringArray = line;
                    if (AndroidTestLogcatPlugin.access$getCrashLogcatProgressMatcher(this.this$0).matches((CharSequence)stringArray)) {
                        BufferedWriter bufferedWriter = AndroidTestLogcatPlugin.access$getCrashLogcatWriter$p(this.this$0);
                        if (bufferedWriter == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"crashLogcatWriter");
                            bufferedWriter = null;
                        }
                        stringArray = new String[]{"E AndroidRuntime: "};
                        bufferedWriter.write((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
                        BufferedWriter bufferedWriter2 = AndroidTestLogcatPlugin.access$getCrashLogcatWriter$p(this.this$0);
                        if (bufferedWriter2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"crashLogcatWriter");
                            bufferedWriter2 = null;
                        }
                        bufferedWriter2.newLine();
                        BufferedWriter bufferedWriter3 = AndroidTestLogcatPlugin.access$getCrashLogcatWriter$p(this.this$0);
                        if (bufferedWriter3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"crashLogcatWriter");
                            bufferedWriter3 = null;
                        }
                        bufferedWriter3.flush();
                    }
                }
                if (AndroidTestLogcatPlugin.access$getCrashHappened$p(this.this$0).get()) {
                    stringArray = line;
                    if (AndroidTestLogcatPlugin.access$getCrashLogcatFinishMatcher(this.this$0).matches((CharSequence)stringArray)) {
                        AndroidTestLogcatPlugin.access$getCrashLogFinished$p(this.this$0).countDown();
                    }
                }
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"TestRunner: started: ", (boolean)false, (int)2, null)) {
                    this.$testRunInProgress.element = true;
                    AndroidTestLogcatPlugin.access$parseLine(this.this$0, line);
                }
                if (this.$testRunInProgress.element) {
                    stringArray = AndroidTestLogcatPlugin.access$getCurrentLogcatLock$p(this.this$0);
                    object2 = this.this$0;
                    object = stringArray;
                    synchronized (object) {
                        Unit unit;
                        boolean bl = false;
                        BufferedWriter bufferedWriter = AndroidTestLogcatPlugin.access$getCurrentLogcatWriter$p(object2);
                        if (bufferedWriter != null) {
                            bufferedWriter.write(line);
                        }
                        BufferedWriter bufferedWriter4 = AndroidTestLogcatPlugin.access$getCurrentLogcatWriter$p(object2);
                        if (bufferedWriter4 != null) {
                            bufferedWriter4.newLine();
                        }
                        BufferedWriter bufferedWriter5 = AndroidTestLogcatPlugin.access$getCurrentLogcatWriter$p(object2);
                        if (bufferedWriter5 != null) {
                            bufferedWriter5.flush();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                }
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"TestRunner: finished:", (boolean)false, (int)2, null)) {
                    this.$testRunInProgress.element = false;
                    AndroidTestLogcatPlugin.access$closeCurrentLogcatWriter(this.this$0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopLogcat() {
        this.logger.info("Stop logcat streaming.");
        try {
            if (this.logcatCommandHandle != null) {
                CommandHandle commandHandle = this.logcatCommandHandle;
                if (commandHandle == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logcatCommandHandle");
                    commandHandle = null;
                }
                commandHandle.stop();
                CommandHandle commandHandle2 = this.logcatCommandHandle;
                if (commandHandle2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logcatCommandHandle");
                    commandHandle2 = null;
                }
                CommandHandle.DefaultImpls.waitFor$default((CommandHandle)commandHandle2, null, (int)1, null);
            }
        }
        catch (Throwable t) {
            this.logger.warning("Stopping logcat failed with the following error: " + t);
        }
        finally {
            this.closeCurrentLogcatWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseLine(String line) {
        String[] stringArray = new String[]{"TestRunner: started: "};
        CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        stringArray = new String[]{"("};
        List testPackageClassAndMethodNames = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String testMethod = ((Object)StringsKt.trim((CharSequence)((String)testPackageClassAndMethodNames.get(0)))).toString();
        String testPackageAndClass = StringsKt.removeSuffix((String)((String)testPackageClassAndMethodNames.get(1)), (CharSequence)")");
        String tempFileName = this.generateLogcatFileName(testPackageAndClass, testMethod);
        Object object = this.currentLogcatLock;
        synchronized (object) {
            File logcatFile;
            boolean bl = false;
            this.closeCurrentLogcatWriter();
            this.currentLogcatFile = logcatFile = new File(tempFileName);
            OutputStream outputStream = new FileOutputStream(logcatFile);
            Charset charset = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter(outputStream, charset);
            int n = 8192;
            this.currentLogcatWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCurrentLogcatWriter() {
        Object object = this.currentLogcatLock;
        synchronized (object) {
            boolean bl = false;
            if (this.currentLogcatFile != null) {
                BufferedWriter bufferedWriter = this.currentLogcatWriter;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                this.currentLogcatWriter = null;
                this.currentLogcatFile = null;
                this.processedLogcatNum.incrementAndGet();
                if (this.allTestFinished.get() && this.processedLogcatNum.get() >= this.expectedTestCaseNum.get()) {
                    this.logcatTextProcessFinished.countDown();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public AndroidTestLogcatPlugin() {
        this(null, 0L, 3, null);
    }

    public static final /* synthetic */ CountDownLatch access$getLogcatCounter$p(AndroidTestLogcatPlugin $this) {
        return $this.logcatCounter;
    }

    public static final /* synthetic */ AtomicBoolean access$getCrashHappened$p(AndroidTestLogcatPlugin $this) {
        return $this.crashHappened;
    }

    public static final /* synthetic */ Regex access$getCrashLogcatStartMatcher$p(AndroidTestLogcatPlugin $this) {
        return $this.crashLogcatStartMatcher;
    }

    public static final /* synthetic */ void access$setCrashLogcatFile$p(AndroidTestLogcatPlugin $this, File file) {
        $this.crashLogcatFile = file;
    }

    public static final /* synthetic */ String access$generateLogcatFileName(AndroidTestLogcatPlugin $this, String testPackageAndClass, String testMethod) {
        return $this.generateLogcatFileName(testPackageAndClass, testMethod);
    }

    public static final /* synthetic */ String access$getTargetTestProcessName$p(AndroidTestLogcatPlugin $this) {
        return $this.targetTestProcessName;
    }

    public static final /* synthetic */ void access$setCrashLogcatWriter$p(AndroidTestLogcatPlugin $this, BufferedWriter bufferedWriter) {
        $this.crashLogcatWriter = bufferedWriter;
    }

    public static final /* synthetic */ File access$getCrashLogcatFile$p(AndroidTestLogcatPlugin $this) {
        return $this.crashLogcatFile;
    }

    public static final /* synthetic */ void access$setTestPid$p(AndroidTestLogcatPlugin $this, String string) {
        $this.testPid = string;
    }

    public static final /* synthetic */ Regex access$getCrashLogcatProgressMatcher(AndroidTestLogcatPlugin $this) {
        return $this.getCrashLogcatProgressMatcher();
    }

    public static final /* synthetic */ BufferedWriter access$getCrashLogcatWriter$p(AndroidTestLogcatPlugin $this) {
        return $this.crashLogcatWriter;
    }

    public static final /* synthetic */ Regex access$getCrashLogcatFinishMatcher(AndroidTestLogcatPlugin $this) {
        return $this.getCrashLogcatFinishMatcher();
    }

    public static final /* synthetic */ CountDownLatch access$getCrashLogFinished$p(AndroidTestLogcatPlugin $this) {
        return $this.crashLogFinished;
    }

    public static final /* synthetic */ void access$parseLine(AndroidTestLogcatPlugin $this, String line) {
        $this.parseLine(line);
    }

    public static final /* synthetic */ Object access$getCurrentLogcatLock$p(AndroidTestLogcatPlugin $this) {
        return $this.currentLogcatLock;
    }

    public static final /* synthetic */ void access$closeCurrentLogcatWriter(AndroidTestLogcatPlugin $this) {
        $this.closeCurrentLogcatWriter();
    }

    public static final /* synthetic */ BufferedWriter access$getCurrentLogcatWriter$p(AndroidTestLogcatPlugin $this) {
        return $this.currentLogcatWriter;
    }

    public static final /* synthetic */ String access$getTestPid$p(AndroidTestLogcatPlugin $this) {
        return $this.testPid;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin$Companion;", "", "()V", "LOGCAT_TIMEOUT_SECONDS", "", "TEST_CRASH_INDICATOR", "", "android-test-plugin-host-logcat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

