/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.internal.avd.EmulatorFeaturesChannel;
import com.android.sdklib.internal.avd.EmulatorPackages;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.internal.avd.SystemImageUpdateDependency;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u0006\u0010'\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/android/sdklib/internal/avd/EmulatorPackage;", "", "emulator", "Lcom/android/repository/api/LocalPackage;", "(Lcom/android/repository/api/LocalPackage;)V", "emulatorBinary", "Ljava/nio/file/Path;", "getEmulatorBinary", "()Ljava/nio/file/Path;", "emulatorCheckBinary", "getEmulatorCheckBinary", "isQemu2", "", "()Z", "mkSdCardBinary", "getMkSdCardBinary", "version", "Lcom/android/repository/Revision;", "getVersion", "()Lcom/android/repository/Revision;", "getBinaryLocation", "filename", "", "getEmulatorFeatures", "", "logger", "Lcom/android/utils/ILogger;", "channel", "Lcom/android/sdklib/internal/avd/EmulatorFeaturesChannel;", "featuresFile", "getHardwareProperties", "", "Lcom/android/sdklib/internal/avd/HardwareProperties$HardwareProperty;", "getSystemImageUpdateDependencies", "", "Lcom/android/sdklib/internal/avd/SystemImageUpdateDependency;", "getSystemImageUpdateRequiredPredicate", "Ljava/util/function/Predicate;", "Lcom/android/sdklib/repository/targets/SystemImage;", "hasStudioParamsSupport", "sdklib"})
@SourceDebugExtension(value={"SMAP\nEmulatorPackage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorPackage.kt\ncom/android/sdklib/internal/avd/EmulatorPackage\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n535#2:185\n520#2,6:186\n1#3:192\n1755#4,3:193\n*S KotlinDebug\n*F\n+ 1 EmulatorPackage.kt\ncom/android/sdklib/internal/avd/EmulatorPackage\n*L\n76#1:185\n76#1:186,6\n98#1:193,3\n*E\n"})
public final class EmulatorPackage {
    @NotNull
    private final LocalPackage emulator;

    public EmulatorPackage(@NotNull LocalPackage emulator) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        this.emulator = emulator;
    }

    @NotNull
    public final Revision getVersion() {
        Revision revision = this.emulator.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"getVersion(...)");
        return revision;
    }

    public final boolean isQemu2() {
        return this.getVersion().compareTo(EmulatorPackages.access$getTOOLS_REVISION_WITH_FIRST_QEMU2$p()) >= 0;
    }

    @Nullable
    public final Map<String, HardwareProperties.HardwareProperty> getHardwareProperties(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Path propertiesPath = this.emulator.getLocation().resolve("lib").resolve("hardware-properties.ini");
        return HardwareProperties.parseHardwareDefinitions(new PathFileWrapper(propertiesPath), logger);
    }

    @JvmOverloads
    @Nullable
    public final Set<String> getEmulatorFeatures(@NotNull ILogger logger, @NotNull EmulatorFeaturesChannel channel) {
        Set<String> set;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
        if (channel.compareTo((Enum)EmulatorFeaturesChannel.CANARY) >= 0 && (set = this.getEmulatorFeatures(EmulatorFeaturesChannel.CANARY.getFeaturesFile(), logger)) != null) {
            Set<String> it = set;
            boolean bl = false;
            return it;
        }
        return this.getEmulatorFeatures(EmulatorFeaturesChannel.RELEASE.getFeaturesFile(), logger);
    }

    public static /* synthetic */ Set getEmulatorFeatures$default(EmulatorPackage emulatorPackage, ILogger iLogger, EmulatorFeaturesChannel emulatorFeaturesChannel, int n, Object object) {
        if ((n & 2) != 0) {
            emulatorFeaturesChannel = EmulatorFeaturesChannel.RELEASE;
        }
        return emulatorPackage.getEmulatorFeatures(iLogger, emulatorFeaturesChannel);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getEmulatorFeatures(String featuresFile, ILogger logger) {
        Path featuresPath = this.emulator.getLocation().resolve("lib").resolve(featuresFile);
        if (Files.exists(featuresPath, new LinkOption[0])) {
            Set set;
            Map<String, String> map = ProjectProperties.parsePropertyFile(new PathFileWrapper(featuresPath), logger);
            if (map != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Map<String, String> map2 = map;
                boolean $i$f$filter = false;
                void var7_7 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getValue(), (Object)"on")) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                set = destination$iv$iv.keySet();
            } else {
                set = null;
            }
            return set;
        }
        return null;
    }

    private final Path getBinaryLocation(String filename) {
        Path path;
        Path it = path = this.emulator.getLocation().resolve(filename);
        boolean bl = false;
        return CancellableFileIo.exists((Path)it, (LinkOption[])new LinkOption[0]) ? path : null;
    }

    @Nullable
    public final Path getEmulatorBinary() {
        String string = SdkConstants.FN_EMULATOR;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FN_EMULATOR");
        return this.getBinaryLocation(string);
    }

    @Nullable
    public final Path getEmulatorCheckBinary() {
        String string = SdkConstants.FN_EMULATOR_CHECK;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FN_EMULATOR_CHECK");
        return this.getBinaryLocation(string);
    }

    @Nullable
    public final Path getMkSdCardBinary() {
        String string = SdkConstants.mkSdCardCmdName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mkSdCardCmdName(...)");
        return this.getBinaryLocation(string);
    }

    @NotNull
    public final Predicate<SystemImage> getSystemImageUpdateRequiredPredicate() {
        List<SystemImageUpdateDependency> dependencies = this.getSystemImageUpdateDependencies();
        return arg_0 -> EmulatorPackage.getSystemImageUpdateRequiredPredicate$lambda$4(dependencies, arg_0);
    }

    private final List<SystemImageUpdateDependency> getSystemImageUpdateDependencies() {
        List list;
        Revision version = this.getVersion();
        if (version.compareTo(EmulatorPackages.access$getTOOLS_REVISION_25_0_2_RC3$p()) >= 0) {
            list = EmulatorPackages.access$getSYSTEM_IMAGE_DEPENDENCY_WITH_25_0_2_RC3$p();
        } else if (version.compareTo(EmulatorPackages.access$getTOOLS_REVISION_WITH_FIRST_QEMU2$p()) >= 0) {
            list = EmulatorPackages.access$getSYSTEM_IMAGE_DEPENDENCY_WITH_FIRST_QEMU2$p();
        } else {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            list = (List)immutableList;
        }
        return list;
    }

    public final boolean hasStudioParamsSupport() {
        return this.getVersion().compareTo(Revision.parseRevision((String)"26.1.0")) >= 0;
    }

    @JvmOverloads
    @Nullable
    public final Set<String> getEmulatorFeatures(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        return EmulatorPackage.getEmulatorFeatures$default(this, logger, null, 2, null);
    }

    private static final boolean getSystemImageUpdateRequiredPredicate$lambda$4(List $dependencies, SystemImage systemImage) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)systemImage, (String)"systemImage");
            Iterable $this$any$iv = $dependencies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SystemImageUpdateDependency it = (SystemImageUpdateDependency)element$iv;
                    boolean bl2 = false;
                    if (!it.updateRequired(systemImage)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

