/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdNetworkLatency;
import com.android.sdklib.internal.avd.AvdNetworkSpeed;
import com.google.common.collect.Comparators;
import java.util.Comparator;
import java.util.Map;

public class EmulatedProperties {
    public static final String BACK_CAMERA_KEY = "hw.camera.back";
    public static final String CPU_CORES_KEY = "hw.cpu.ncore";
    public static final String CUSTOM_SKIN_FILE_KEY = "skin.path";
    public static final String DEVICE_FRAME_KEY = "showDeviceFrame";
    public static final String FRONT_CAMERA_KEY = "hw.camera.front";
    public static final String HAS_HARDWARE_KEYBOARD_KEY = "hw.keyboard";
    public static final String HOST_GPU_MODE_KEY = "hw.gpu.mode";
    public static final String INTERNAL_STORAGE_KEY = "disk.dataPartition.size";
    public static final String NETWORK_LATENCY_KEY = "runtime.network.latency";
    public static final String NETWORK_SPEED_KEY = "runtime.network.speed";
    public static final String RAM_STORAGE_KEY = "hw.ramSize";
    public static final String SDCARD_SIZE = "sdcard.size";
    public static final String USE_CHOSEN_SNAPSHOT_BOOT = "fastboot.forceChosenSnapshotBoot";
    public static final String USE_COLD_BOOT = "fastboot.forceColdBoot";
    public static final String USE_FAST_BOOT = "fastboot.forceFastBoot";
    public static final String USE_HOST_GPU_KEY = "hw.gpu.enabled";
    public static final String VM_HEAP_STORAGE_KEY = "vm.heapSize";
    public static final int MAX_NUMBER_OF_CORES = Integer.max(1, Runtime.getRuntime().availableProcessors() / 2);
    public static final int RECOMMENDED_NUMBER_OF_CORES = Integer.min(4, MAX_NUMBER_OF_CORES);
    public static final Storage DEFAULT_INTERNAL_STORAGE = new Storage(800L, Storage.Unit.MiB);
    public static final Storage DEFAULT_HEAP = new Storage(16L, Storage.Unit.MiB);
    public static final AvdNetworkSpeed DEFAULT_NETWORK_SPEED = AvdNetworkSpeed.FULL;
    public static final AvdNetworkLatency DEFAULT_NETWORK_LATENCY = AvdNetworkLatency.NONE;
    public static final Storage DEFAULT_SDCARD_SIZE = new Storage(512L, Storage.Unit.MiB);
    public static final Storage MAX_DEFAULT_RAM_SIZE = new Storage(2L, Storage.Unit.GiB);

    public static void restrictDefaultRamSize(Map<String, String> deviceConfig) {
        Storage ramSize = Storage.getStorageFromString(deviceConfig.get(RAM_STORAGE_KEY));
        if (ramSize != null && MAX_DEFAULT_RAM_SIZE.lessThan(ramSize)) {
            deviceConfig.put(RAM_STORAGE_KEY, MAX_DEFAULT_RAM_SIZE.toIniString());
        }
    }

    public static Storage defaultRamSize(Device device) {
        return (Storage)Comparators.min((Object)device.getDefaultHardware().getRam(), (Object)MAX_DEFAULT_RAM_SIZE, Comparator.comparing(Storage::getSize));
    }

    public static Storage defaultVmHeapSize(Device device) {
        return EmulatedProperties.minimumVmHeapSize(ScreenSize.getScreenSize((Double)device.getDefaultHardware().getScreen().getDiagonalLength()), device.getDefaultHardware().getScreen().getPixelDensity(), Device.isWear(device));
    }

    public static Storage minimumVmHeapSize(ScreenSize screenSize, Density screenDensity, boolean isWear) {
        int vmHeapSize;
        if (screenDensity == Density.ANYDPI || screenDensity == Density.NODPI) {
            screenDensity = Density.MEDIUM;
        }
        if (isWear) {
            vmHeapSize = screenDensity.getDpiValue() <= 220 ? 32 : (screenDensity.getDpiValue() <= 280 ? 36 : (screenDensity.getDpiValue() <= 360 ? 48 : (screenDensity.getDpiValue() <= 400 ? 56 : (screenDensity.getDpiValue() <= 440 ? 64 : (screenDensity.getDpiValue() <= 480 ? 88 : (screenDensity.getDpiValue() <= 560 ? 112 : 156))))));
        } else {
            switch (screenSize) {
                default: {
                    if (screenDensity.getDpiValue() <= 160) {
                        vmHeapSize = 32;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 280) {
                        vmHeapSize = 48;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 360) {
                        vmHeapSize = 80;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 400) {
                        vmHeapSize = 96;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 420) {
                        vmHeapSize = 112;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 480) {
                        vmHeapSize = 128;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 560) {
                        vmHeapSize = 192;
                        break;
                    }
                    vmHeapSize = 256;
                    break;
                }
                case LARGE: {
                    if (screenDensity.getDpiValue() <= 120) {
                        vmHeapSize = 32;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 160) {
                        vmHeapSize = 48;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 240) {
                        vmHeapSize = 80;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 280) {
                        vmHeapSize = 96;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 320) {
                        vmHeapSize = 128;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 360) {
                        vmHeapSize = 160;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 400) {
                        vmHeapSize = 192;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 420) {
                        vmHeapSize = 228;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 480) {
                        vmHeapSize = 256;
                        break;
                    }
                    if (screenDensity.getDpiValue() <= 560) {
                        vmHeapSize = 384;
                        break;
                    }
                    vmHeapSize = 512;
                    break;
                }
                case XLARGE: {
                    vmHeapSize = screenDensity.getDpiValue() <= 120 ? 48 : (screenDensity.getDpiValue() <= 160 ? 80 : (screenDensity.getDpiValue() <= 240 ? 96 : (screenDensity.getDpiValue() <= 280 ? 144 : (screenDensity.getDpiValue() <= 320 ? 192 : (screenDensity.getDpiValue() <= 360 ? 240 : (screenDensity.getDpiValue() <= 400 ? 288 : (screenDensity.getDpiValue() <= 420 ? 336 : (screenDensity.getDpiValue() <= 480 ? 384 : (screenDensity.getDpiValue() <= 560 ? 576 : 768)))))))));
                }
            }
        }
        return new Storage(vmHeapSize, Storage.Unit.MiB);
    }

    public static Storage defaultInternalStorage(Device device) {
        return DEFAULT_INTERNAL_STORAGE;
    }
}

