/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Device;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0012J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/sdklib/internal/avd/AvdNames;", "", "()V", "ALLOWED_CHARS", "", "ALLOWED_CHARS_READABLE", "cleanAvdName", "avdName", "getDefaultDeviceDisplayName", "device", "Lcom/android/sdklib/devices/Device;", "version", "Lcom/android/sdklib/AndroidVersion;", "humanReadableAllowedCharacters", "isValid", "", "candidateName", "stripBadCharacters", "stripBadCharacters$sdklib", "uniquify", "name", "separator", "isPresent", "Lkotlin/Function1;", "sdklib"})
@SourceDebugExtension(value={"SMAP\nAvdNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdNames.kt\ncom/android/sdklib/internal/avd/AvdNames\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class AvdNames {
    @NotNull
    public static final AvdNames INSTANCE = new AvdNames();
    @NotNull
    private static final String ALLOWED_CHARS = "0-9a-zA-Z-_. ()";
    @NotNull
    private static final String ALLOWED_CHARS_READABLE = "a-z A-Z 0-9 . _ - ( )";

    private AvdNames() {
    }

    @JvmStatic
    public static final boolean isValid(@NotNull String candidateName) {
        Intrinsics.checkNotNullParameter((Object)candidateName, (String)"candidateName");
        CharSequence charSequence = candidateName;
        return new Regex("^[0-9a-zA-Z-_. ()]+$").matches(charSequence);
    }

    @JvmStatic
    @NotNull
    public static final String stripBadCharacters$sdklib(@NotNull String candidateName) {
        Intrinsics.checkNotNullParameter((Object)candidateName, (String)"candidateName");
        CharSequence charSequence = candidateName;
        Regex regex = new Regex("[^0-9a-zA-Z-_. ()]");
        String string = " ";
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @NotNull
    public static final String humanReadableAllowedCharacters() {
        return ALLOWED_CHARS_READABLE;
    }

    @JvmStatic
    @NotNull
    public static final String cleanAvdName(@NotNull String avdName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        CharSequence charSequence2 = avdName;
        Regex regex = new Regex("[^0-9a-zA-Z-_. ()]");
        String string = " ";
        charSequence2 = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence2, string))).toString();
        regex = new Regex("[ ()_]+");
        string = "_";
        charSequence2 = regex.replace(charSequence2, string);
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "myavd";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultDeviceDisplayName(@NotNull Device device, @NotNull AndroidVersion version) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return AvdNames.stripBadCharacters$sdklib(string) + " API " + version.getApiStringWithExtension();
    }

    @NotNull
    public final String uniquify(@NotNull String name, @NotNull String separator, @NotNull Function1<? super String, Boolean> isPresent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(isPresent, (String)"isPresent");
        int suffix = 1;
        Object candidate = name;
        while (((Boolean)isPresent.invoke(candidate)).booleanValue()) {
            candidate = name + separator + ++suffix;
        }
        return candidate;
    }
}

