/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public final class AvdInfo {
    private final String mName;
    private final Path mIniFile;
    private final Path mFolderPath;
    private final ImmutableMap<String, String> mProperties;
    private final AvdStatus mStatus;
    private final ISystemImage mSystemImage;
    private final boolean mHasPlayStore;

    public AvdInfo(String name, Path iniFile, Path folderPath, ISystemImage systemImage, Map<String, String> properties) {
        this(name, iniFile, folderPath, systemImage, properties, AvdStatus.OK);
    }

    public AvdInfo(String name, Path iniFile, Path folderPath, ISystemImage systemImage, Map<String, String> properties, AvdStatus status) {
        this.mName = name;
        this.mIniFile = iniFile;
        this.mFolderPath = folderPath;
        this.mSystemImage = systemImage;
        this.mProperties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.mStatus = status;
        String psString = (String)this.mProperties.get((Object)"PlayStore.enabled");
        this.mHasPlayStore = "true".equalsIgnoreCase(psString) || "yes".equalsIgnoreCase(psString);
    }

    public String getId() {
        return this.mFolderPath.toString();
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        String name = this.getProperties().get("avd.ini.displayname");
        return name == null ? this.mName.replace('_', ' ') : name;
    }

    public Path getDataFolderPath() {
        return this.mFolderPath;
    }

    public IdDisplay getTag() {
        String id = this.getProperties().get("tag.id");
        if (id == null) {
            return SystemImage.DEFAULT_TAG;
        }
        String display = this.getProperties().get("tag.display");
        return IdDisplay.create(id, display == null ? id : display);
    }

    public String getAbiType() {
        return this.getProperties().get("abi.type");
    }

    public boolean hasPlayStore() {
        return this.mHasPlayStore;
    }

    public AndroidVersion getAndroidVersion() {
        Map<String, String> properties = this.getProperties();
        String apiStr = properties.get("image.androidVersion.api");
        String codename = properties.get("image.androidVersion.codename");
        int api = 1;
        if (!Strings.isNullOrEmpty((String)apiStr)) {
            try {
                api = Integer.parseInt(apiStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String extStr = properties.get("image.androidVersion.extension");
        int extension = 1;
        if (!Strings.isNullOrEmpty((String)extStr)) {
            try {
                extension = Integer.parseInt(extStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String isBaseStr = properties.get("image.androidVersion.isBaseExtension");
        boolean isBase = true;
        if (!Strings.isNullOrEmpty((String)isBaseStr)) {
            isBase = Boolean.parseBoolean(isBaseStr);
        }
        return new AndroidVersion(api, codename, Integer.valueOf(extension), isBase);
    }

    public String getCpuArch() {
        String cpuArch = (String)this.mProperties.get((Object)"hw.cpu.arch");
        if (cpuArch != null) {
            return cpuArch;
        }
        return "arm";
    }

    public String getDeviceManufacturer() {
        String deviceManufacturer = (String)this.mProperties.get((Object)"hw.device.manufacturer");
        if (deviceManufacturer != null && !deviceManufacturer.isEmpty()) {
            return deviceManufacturer;
        }
        return "";
    }

    public String getDeviceName() {
        String deviceName = (String)this.mProperties.get((Object)"hw.device.name");
        if (deviceName != null && !deviceName.isEmpty()) {
            return deviceName;
        }
        return "";
    }

    public ISystemImage getSystemImage() {
        return this.mSystemImage;
    }

    public AvdStatus getStatus() {
        return this.mStatus;
    }

    public static Path getDefaultAvdFolder(AvdManager manager, String avdName, boolean unique) {
        Path base = manager.getBaseAvdFolder();
        Path result = base.resolve(avdName + ".avd");
        if (unique) {
            int suffix = 0;
            while (CancellableFileIo.exists((Path)result, (LinkOption[])new LinkOption[0])) {
                result = base.resolve(String.format("%s_%d%s", avdName, ++suffix, ".avd"));
            }
        }
        return result;
    }

    public static Path getDefaultIniFile(AvdManager manager, String avdName) {
        Path avdRoot = manager.getBaseAvdFolder();
        return avdRoot.resolve(avdName + ".ini");
    }

    public Path getIniFile() {
        return this.mIniFile;
    }

    public static Path getConfigFile(Path path) {
        return path.resolve("config.ini");
    }

    public Path getConfigFile() {
        return AvdInfo.getConfigFile(this.mFolderPath);
    }

    public String getProperty(String propertyName) {
        return (String)this.mProperties.get((Object)propertyName);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public String getErrorMessage() {
        switch (this.mStatus) {
            case ERROR_PATH: {
                return String.format("Missing AVD 'path' property in %1$s", this.getIniFile());
            }
            case ERROR_CONFIG: {
                return String.format("Missing config.ini file in %1$s", this.mFolderPath);
            }
            case ERROR_PROPERTIES: {
                return String.format("Failed to parse properties from %1$s", this.getConfigFile());
            }
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return String.format("Missing system image for %s%s %s.", SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "" : this.getTag().getDisplay() + " ", this.getAbiType(), this.mName);
            }
            case ERROR_DEVICE_CHANGED: {
                return String.format("%1$s %2$s configuration has changed since AVD creation", this.mProperties.get((Object)"hw.device.manufacturer"), this.mProperties.get((Object)"hw.device.name"));
            }
            case ERROR_DEVICE_MISSING: {
                return String.format("%1$s %2$s no longer exists as a device", this.mProperties.get((Object)"hw.device.manufacturer"), this.mProperties.get((Object)"hw.device.name"));
            }
            case ERROR_CORRUPTED_INI: {
                return String.format("Corrupted AVD ini file: %1$s", this.getIniFile());
            }
            case OK: {
                return null;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvdInfo avdInfo = (AvdInfo)o;
        return this.mHasPlayStore == avdInfo.mHasPlayStore && this.mName.equals(avdInfo.mName) && this.mIniFile.equals(avdInfo.mIniFile) && this.mFolderPath.equals(avdInfo.mFolderPath) && this.mProperties.equals(avdInfo.mProperties) && this.mStatus == avdInfo.mStatus && Objects.equals(this.mSystemImage, avdInfo.mSystemImage);
    }

    public int hashCode() {
        int hashCode = this.mName.hashCode();
        hashCode = 31 * hashCode + this.mIniFile.hashCode();
        hashCode = 31 * hashCode + this.mFolderPath.hashCode();
        hashCode = 31 * hashCode + this.mProperties.hashCode();
        hashCode = 31 * hashCode + this.mStatus.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mSystemImage);
        hashCode = 31 * hashCode + Objects.hashCode(this.mHasPlayStore);
        return hashCode;
    }

    public String toDebugString() {
        String separator = System.lineSeparator();
        return "mName = " + this.mName + separator + "mIniFile = " + this.mIniFile + separator + "mFolderPath = " + this.mFolderPath + separator + "mProperties = " + this.mProperties + separator + "mStatus = " + this.mStatus + separator + "mSystemImage = " + this.mSystemImage + separator + "mHasPlayStore = " + this.mHasPlayStore + separator;
    }

    public static enum AvdStatus {
        OK,
        ERROR_PATH,
        ERROR_CONFIG,
        ERROR_PROPERTIES,
        ERROR_IMAGE_DIR,
        ERROR_DEVICE_CHANGED,
        ERROR_DEVICE_MISSING,
        ERROR_IMAGE_MISSING,
        ERROR_CORRUPTED_INI;

    }
}

