/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.io.CancellableFileIo;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathFileWrapper
implements IAbstractFile,
IAbstractFolder {
    private final Path mFile;

    public PathFileWrapper(Path path) {
        this.mFile = path;
    }

    public InputStream getContents() throws StreamException {
        try {
            return CancellableFileIo.newInputStream((Path)this.mFile, (OpenOption[])new OpenOption[0]);
        }
        catch (IOException e) {
            throw new StreamException((Exception)e, (IAbstractFile)this);
        }
    }

    public void setContents(InputStream source) throws StreamException {
        try (OutputStream fos = Files.newOutputStream(this.mFile, new OpenOption[0]);){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = source.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new StreamException((Exception)e, (IAbstractFile)this);
        }
    }

    public OutputStream getOutputStream() throws StreamException {
        try {
            return Files.newOutputStream(this.mFile, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new StreamException((Exception)ex, (IAbstractFile)this);
        }
    }

    public String getOsLocation() {
        return this.mFile.toAbsolutePath().toString();
    }

    public boolean exists() {
        return CancellableFileIo.exists((Path)this.mFile, (LinkOption[])new LinkOption[0]);
    }

    public IAbstractFile getFile(String name) {
        return new PathFileWrapper(this.mFile.resolve(name));
    }
}

