/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolListWithPackageNameWriter;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.io.NonClosingStreams;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class SymbolIo {
    public static final String ANDROID_ATTR_PREFIX = "android_";
    public static final String ANDROID_DOT_PREFIX = "android.";
    private final Interner<Symbol> symbolInterner;

    public SymbolIo() {
        this((Interner<Symbol>)Interners.newStrongInterner());
    }

    public SymbolIo(Interner<Symbol> symbolInterner) {
        this.symbolInterner = symbolInterner;
    }

    public static SymbolTable readFromAapt(File file, String tablePackage) throws Exception {
        return new SymbolIo().read(file, tablePackage, ReadConfiguration.AAPT);
    }

    public static SymbolTable readFromAaptNoValues(File file, String tablePackage) throws Exception {
        return new SymbolIo().read(file, tablePackage, ReadConfiguration.AAPT_NO_VALUES);
    }

    public static SymbolTable readFromAaptNoValues(BufferedReader reader, String filename, String tablePackage) throws Exception {
        return new SymbolIo().read(reader.lines(), filename, tablePackage, ReadConfiguration.AAPT_NO_VALUES);
    }

    public SymbolTable readFromPartialRFile(File file, String tablePackage) throws Exception {
        return this.read(file, tablePackage, ReadConfiguration.PARTIAL_FILE);
    }

    public static SymbolTable readFromPublicTxtFile(InputStream inputStream, String fileName, String tablePackage) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            SymbolTable symbolTable = new SymbolIo().read(reader.lines(), fileName, tablePackage, ReadConfiguration.PUBLIC_FILE);
            return symbolTable;
        }
    }

    private SymbolTable read(File file, String tablePackage, ReadConfiguration readConfiguration) throws Exception {
        String filename = file.getAbsolutePath();
        try (Stream<String> lines = Files.lines(file.toPath());){
            SymbolTable symbolTable = this.read(lines, filename, tablePackage, readConfiguration);
            return symbolTable;
        }
    }

    private SymbolTable read(Stream<String> lines, String filename, String tablePackage, ReadConfiguration readConfiguration) throws Exception {
        Iterator<String> linesIterator = lines.iterator();
        int startLine = SymbolIo.checkFileTypeHeader(linesIterator, readConfiguration, filename);
        SymbolTable.FastBuilder table = new SymbolLineReader(readConfiguration, linesIterator, filename, this.symbolInterner, startLine).readLines();
        if (tablePackage != null) {
            table.tablePackage(tablePackage);
        }
        try {
            return table.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Issue parsing symbol table from package '" + tablePackage + "' at " + filename + ".\n" + e.getMessage(), e);
        }
    }

    public SymbolTable readSymbolListWithPackageName(Path file) throws IOException {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            SymbolTable symbolTable = this.readWithPackage(lines, file.toString(), ReadConfiguration.SYMBOL_LIST_WITH_PACKAGE);
            return symbolTable;
        }
    }

    public static SymbolTable readRDef(Path file) throws IOException {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            SymbolTable symbolTable = new SymbolIo().readWithPackage(lines, file.toString(), ReadConfiguration.R_DEF);
            return symbolTable;
        }
    }

    public static SymbolTable readRDefFromZip(Path zipFile) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(new BufferedInputStream(Files.newInputStream(zipFile, new OpenOption[0])));){
            ZipEntry entry;
            do {
                if ((entry = zip.getNextEntry()) != null) continue;
                throw new IOException("Expected zip " + zipFile + " to contain R-def.txt");
            } while (!entry.getName().equals("R-def.txt"));
            SymbolTable symbolTable = SymbolIo.readRDefFromInputStream(zipFile.toString() + "/!R-def.txt", zip);
            return symbolTable;
        }
    }

    public static SymbolTable readRDefFromInputStream(String filePath, InputStream fileInputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(NonClosingStreams.nonClosing((InputStream)fileInputStream), StandardCharsets.UTF_8));){
            SymbolTable symbolTable = new SymbolIo().readWithPackage(reader.lines(), filePath, ReadConfiguration.R_DEF);
            return symbolTable;
        }
    }

    private SymbolTable readWithPackage(Stream<String> lines, String filePath, ReadConfiguration readConfiguration) throws IOException {
        Iterator<String> linesIterator = lines.iterator();
        int startLine = SymbolIo.checkFileTypeHeader(linesIterator, readConfiguration, filePath);
        if (!linesIterator.hasNext()) {
            throw new IOException("Internal error: Symbol file with package cannot be empty. File located at: " + filePath);
        }
        String tablePackage = linesIterator.next().trim();
        SymbolTable.FastBuilder table = new SymbolLineReader(readConfiguration, linesIterator, filePath, this.symbolInterner, startLine + 1).readLines();
        table.tablePackage(tablePackage);
        return table.build();
    }

    private static int checkFileTypeHeader(Iterator<String> lines, ReadConfiguration readConfiguration, String filename) throws IOException {
        if (readConfiguration.fileTypeHeader == null) {
            return 1;
        }
        if (!lines.hasNext()) {
            throw new IOException("Internal Error: Invalid symbol file '" + filename + "', cannot be empty for type '" + readConfiguration + "'");
        }
        String firstLine = lines.next();
        if (!lines.hasNext() || !readConfiguration.fileTypeHeader.equals(firstLine)) {
            throw new IOException("Internal Error: Invalid symbol file '" + filename + "', first line is incorrect for type '" + readConfiguration + "'.\n Expected '" + readConfiguration.fileTypeHeader + "' but got '" + firstLine + "'");
        }
        return 2;
    }

    private static SymbolData readAaptLine(String line) throws IOException {
        int pos = line.indexOf(32);
        String typeName = line.substring(0, pos);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String className = line.substring(pos + 1, pos2);
        ResourceType resourceType = ResourceType.fromClassName((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String name = line.substring(pos2 + 1, pos3);
        String value = line.substring(pos3 + 1).trim();
        return new SymbolData(resourceType, name, type, value);
    }

    private static SymbolData readPartialRLine(String line) throws IOException {
        int pos = line.indexOf(32);
        String accessName = line.substring(0, pos);
        ResourceVisibility accessibility = ResourceVisibility.getEnum((String)accessName);
        if (accessibility == null) {
            throw new IOException("Invalid resource access qualifier " + accessName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String typeName = line.substring(pos + 1, pos2);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String className = line.substring(pos2 + 1, pos3);
        ResourceType resourceType = ResourceType.fromClassName((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        String name = line.substring(pos3 + 1);
        return new SymbolData(accessibility, resourceType, name, type, "");
    }

    private static SymbolData readPublicTxtLine(String line) throws IOException {
        int pos = line.indexOf(32);
        String className = line.substring(0, pos);
        ResourceType resourceType = ResourceType.fromClassName((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        String typeName = resourceType == ResourceType.STYLEABLE ? "int[]" : "int";
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        String name = line.substring(pos + 1);
        return new SymbolData(ResourceVisibility.PUBLIC, resourceType, name, type, "");
    }

    private static SymbolData readSymbolListWithPackageLine(String line) throws IOException {
        ResourceType resourceType;
        int startPos = line.indexOf(32);
        boolean maybeDefinition = false;
        String typeName = line.substring(0, startPos);
        if (typeName.equals("attr?")) {
            maybeDefinition = true;
            resourceType = ResourceType.ATTR;
        } else {
            resourceType = ResourceType.fromClassName((String)typeName);
        }
        if (resourceType == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int endPos = line.indexOf(32, startPos + 1);
        if (resourceType == ResourceType.STYLEABLE && endPos > 0) {
            String name = line.substring(startPos + 1, endPos);
            startPos = endPos + 1;
            ImmutableList.Builder children = ImmutableList.builder();
            while (endPos < line.length()) {
                endPos = line.indexOf(32, startPos);
                if (endPos == -1) {
                    endPos = line.length();
                }
                String childStyleableAttr = line.substring(startPos, endPos);
                childStyleableAttr = SymbolIo.normalizeAndroidStyleablePrefix(childStyleableAttr);
                children.add((Object)childStyleableAttr);
                startPos = endPos + 1;
            }
            return new SymbolData(name, (ImmutableList<String>)children.build());
        }
        String name = line.substring(startPos + 1);
        if (resourceType == ResourceType.ATTR) {
            return new SymbolData(name, maybeDefinition);
        }
        return new SymbolData(resourceType, name);
    }

    private static String normalizeAndroidStyleablePrefix(String childStyleableName) {
        if (((String)childStyleableName).startsWith("android:") || ((String)childStyleableName).startsWith(ANDROID_DOT_PREFIX)) {
            childStyleableName = ANDROID_ATTR_PREFIX + ((String)childStyleableName).substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
        }
        return childStyleableName;
    }

    private static String computeItemName(String prefix, String name) {
        Object indexName = name.substring(prefix.length());
        if (((String)indexName).startsWith(ANDROID_ATTR_PREFIX)) {
            indexName = "android:" + ((String)indexName).substring(ANDROID_ATTR_PREFIX.length());
        }
        return indexName;
    }

    public ImmutableList<SymbolTable> loadDependenciesSymbolTables(Iterable<File> libraries) throws IOException {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (File dependency : libraries) {
            tables.add((Object)this.readSymbolListWithPackageName(dependency.toPath()));
        }
        return tables.build();
    }

    public static void writeForAar(SymbolTable table, File file) throws IOException {
        SymbolIo.writeForAar(table, file.toPath());
    }

    public static void writeForAar(SymbolTable table, Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            SymbolIo.writeForAar(table, writer);
        }
        catch (Exception e) {
            throw new IOException("Failed to write symbol file " + file.toString(), e);
        }
    }

    public static void writeForAar(SymbolTable table, Writer writer) throws IOException {
        for (ResourceType resType : ResourceType.values()) {
            List<Symbol> symbols = table.getSymbolByResourceType(resType);
            if (symbols.isEmpty()) continue;
            for (Symbol s : symbols) {
                writer.write(s.getJavaType().getTypeName());
                writer.write(32);
                writer.write(s.getResourceType().getName());
                writer.write(32);
                writer.write(s.getCanonicalName());
                writer.write(32);
                if (s.getResourceType() != ResourceType.STYLEABLE) {
                    writer.write("0x");
                    writer.write(Integer.toHexString(s.getIntValue()));
                    writer.write(10);
                    continue;
                }
                Symbol.StyleableSymbol styleable = (Symbol.StyleableSymbol)s;
                SymbolIo.writeStyleableValue(styleable, writer);
                writer.write(10);
                ImmutableList<String> children = styleable.getChildren();
                for (int i2 = 0; i2 < children.size(); ++i2) {
                    writer.write(SymbolJavaType.INT.getTypeName());
                    writer.write(32);
                    writer.write(ResourceType.STYLEABLE.getName());
                    writer.write(32);
                    writer.write(s.getCanonicalName());
                    writer.write(95);
                    writer.write(SymbolUtils.canonicalizeValueResourceName((String)children.get(i2)));
                    writer.write(32);
                    writer.write(Integer.toString(i2));
                    writer.write(10);
                }
            }
        }
    }

    private static void writeStyleableValue(Symbol.StyleableSymbol s, Writer writer) throws IOException {
        writer.write("{ ");
        ImmutableList<Integer> values = s.getValues();
        for (int i2 = 0; i2 < values.size(); ++i2) {
            if (i2 > 0) {
                writer.write(", ");
            }
            writer.write("0x");
            writer.write(Integer.toHexString((Integer)values.get(i2)));
        }
        writer.write(" }");
    }

    public static void writeRDef(SymbolTable table, Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            SymbolIo.writeRDef(table, writer);
        }
        catch (Exception e) {
            throw new IOException("Failed to write R def  file " + file.toString(), e);
        }
    }

    public static void writeRDef(SymbolTable table, OutputStream outputStream) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(NonClosingStreams.nonClosing((OutputStream)outputStream)));){
            SymbolIo.writeRDef(table, writer);
        }
    }

    private static void writeRDef(SymbolTable table, BufferedWriter writer) throws IOException {
        Preconditions.checkNotNull((Object)ReadConfiguration.R_DEF.fileTypeHeader, (Object)"Missing package for R-def file");
        writer.write(ReadConfiguration.R_DEF.fileTypeHeader);
        writer.write(10);
        writer.write(table.getTablePackage());
        writer.write(10);
        for (ResourceType resType : ResourceType.values()) {
            List<Symbol> symbols = table.getSymbolByResourceType(resType);
            if (symbols.isEmpty()) continue;
            for (Symbol s : symbols) {
                writer.write(s.getResourceType().getName());
                if (s.getResourceType() == ResourceType.ATTR && ((Symbol.AttributeSymbol)s).isMaybeDefinition()) {
                    writer.write(63);
                }
                writer.write(32);
                writer.write(s.getName());
                if (s.getResourceType() == ResourceType.STYLEABLE) {
                    ImmutableList<String> children = s.getChildren();
                    for (String child : children) {
                        writer.write(32);
                        writer.write(child);
                    }
                }
                writer.write(10);
            }
        }
    }

    public static void writePartialR(SymbolTable table, Path file) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);
        SymbolIo.generatePartialRContents(table, writer);
        writer.close();
    }

    public static String getPartialRContentsAsString(SymbolTable table) throws IOException {
        StringBuilder sb = new StringBuilder();
        SymbolIo.generatePartialRContents(table, sb);
        return sb.toString();
    }

    private static void generatePartialRContents(SymbolTable table, Appendable appendable) throws IOException {
        for (ResourceType resType : ResourceType.values()) {
            List<Symbol> symbols = table.getSymbolByResourceType(resType);
            for (Symbol s : symbols) {
                appendable.append(s.getResourceVisibility().getName());
                appendable.append(' ');
                appendable.append(s.getJavaType().getTypeName());
                appendable.append(' ');
                appendable.append(s.getResourceType().getName());
                appendable.append(' ');
                appendable.append(s.getCanonicalName());
                appendable.append('\n');
                if (s.getJavaType() != SymbolJavaType.INT_LIST) continue;
                Preconditions.checkArgument((s.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' has java type 'int[]'");
                ImmutableList<String> children = s.getChildren();
                for (String child : children) {
                    appendable.append(s.getResourceVisibility().getName());
                    appendable.append(' ');
                    appendable.append(SymbolJavaType.INT.getTypeName());
                    appendable.append(' ');
                    appendable.append(ResourceType.STYLEABLE.getName());
                    appendable.append(' ');
                    appendable.append(s.getCanonicalName());
                    appendable.append('_');
                    appendable.append(SymbolUtils.canonicalizeValueResourceName(child));
                    appendable.append('\n');
                }
            }
        }
    }

    public static void writeSymbolListWithPackageName(Path symbolTable, Path manifest, Path outputFile) throws IOException {
        String packageName;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
            packageName = AndroidManifestParser.parse(is).getPackage();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to get package name from manifest " + manifest.toAbsolutePath(), e);
        }
        SymbolIo.writeSymbolListWithPackageName(symbolTable, packageName, outputFile);
    }

    public static void writeSymbolListWithPackageName(Path symbolTable, String packageName, Path outputFile) throws IOException {
        block12: {
            try (SymbolListWithPackageNameWriter writer = new SymbolListWithPackageNameWriter(packageName, Files.newBufferedWriter(outputFile, new OpenOption[0]));){
                if (Files.exists(symbolTable, new LinkOption[0])) {
                    try (Stream<String> lines = Files.lines(symbolTable);){
                        SymbolUtils.readAarRTxt(lines.iterator(), writer);
                        break block12;
                    }
                }
                SymbolUtils.visitEmptySymbolTable(writer);
            }
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        String idModifiers = finalIds ? "public static final" : "public static";
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            writer.write("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            writer.newLine();
            writer.write(" *");
            writer.newLine();
            writer.write(" * This class was automatically generated by the");
            writer.newLine();
            writer.write(" * gradle plugin from the resource data it found. It");
            writer.newLine();
            writer.write(" * should not be modified by hand.");
            writer.newLine();
            writer.write(" */");
            writer.newLine();
            if (!table.getTablePackage().isEmpty()) {
                writer.write("package ");
                writer.write(table.getTablePackage());
                writer.write(59);
                writer.newLine();
            }
            writer.newLine();
            writer.write("public final class R {");
            writer.newLine();
            writer.write("    private R() {}");
            writer.newLine();
            writer.newLine();
            String typeName = SymbolJavaType.INT.getTypeName();
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols = table.getSymbolByResourceType(resType);
                if (symbols.isEmpty()) continue;
                writer.write("    public static final class ");
                writer.write(resType.getName());
                writer.write(" {");
                writer.newLine();
                writer.write("        private ");
                writer.write(resType.getName());
                writer.write("() {}");
                writer.newLine();
                writer.newLine();
                for (Symbol s : symbols) {
                    String name = s.getCanonicalName();
                    writer.write("        ");
                    writer.write(idModifiers);
                    writer.write(32);
                    writer.write(s.getJavaType().getTypeName());
                    writer.write(32);
                    writer.write(name);
                    writer.write(" = ");
                    if (s.getResourceType() != ResourceType.STYLEABLE) {
                        writer.write("0x");
                        writer.write(Integer.toHexString(s.getIntValue()));
                        writer.write(59);
                        writer.newLine();
                        continue;
                    }
                    Symbol.StyleableSymbol styleable = (Symbol.StyleableSymbol)s;
                    SymbolIo.writeStyleableValue(styleable, writer);
                    writer.write(59);
                    writer.newLine();
                    ImmutableList<String> children = styleable.getChildren();
                    for (int i2 = 0; i2 < children.size(); ++i2) {
                        writer.write("        ");
                        writer.write(idModifiers);
                        writer.write(32);
                        writer.write(typeName);
                        writer.write(32);
                        writer.write(name);
                        writer.write(95);
                        writer.write(SymbolUtils.canonicalizeValueResourceName((String)children.get(i2)));
                        writer.write(" = ");
                        writer.write(Integer.toString(i2));
                        writer.write(59);
                        writer.newLine();
                    }
                }
                writer.write("    }");
                writer.newLine();
            }
            writer.write(125);
            writer.newLine();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    private static enum ReadConfiguration {
        AAPT(true, false){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readAaptLine(line);
            }
        }
        ,
        AAPT_NO_VALUES(false, false, false, true, null){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readAaptLine(line);
            }
        }
        ,
        SYMBOL_LIST_WITH_PACKAGE(false, true){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readSymbolListWithPackageLine(line);
            }
        }
        ,
        R_DEF(false, true, true, false, "R_DEF: Internal format may change without notice"){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readSymbolListWithPackageLine(line);
            }
        }
        ,
        PARTIAL_FILE(false, false){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readPartialRLine(line);
            }
        }
        ,
        PUBLIC_FILE(false, true){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readPublicTxtLine(line);
            }
        };

        final boolean readValues;
        final boolean singleLineStyleable;
        final boolean rawSymbolNames;
        final boolean ignoreRogueChildren;
        final String fileTypeHeader;

        private ReadConfiguration(boolean readValues, boolean singleLineStyleable) {
            this(readValues, singleLineStyleable, false, false, null);
        }

        private ReadConfiguration(boolean readValues, boolean singleLineStyleable, boolean rawSymbolNames, boolean ignoreRogueChildren, String fileTypeHeader) {
            this.readValues = readValues;
            this.singleLineStyleable = singleLineStyleable;
            this.fileTypeHeader = fileTypeHeader;
            this.rawSymbolNames = rawSymbolNames;
            this.ignoreRogueChildren = ignoreRogueChildren;
        }

        abstract SymbolData parseLine(String var1) throws IOException;
    }

    private static class SymbolLineReader {
        private final SymbolTable.FastBuilder table;
        private final Iterator<String> lines;
        private final String filename;
        private final ReadConfiguration readConfiguration;
        private int currentLineNumber;
        private String currentLineContent;
        private final List<SymbolData> aaptStyleableChildrenCache = new ArrayList<SymbolData>(10);
        private static final Comparator<SymbolData> SYMBOL_DATA_VALUE_COMPARATOR = Comparator.comparingInt(o -> Integer.parseInt(o.value));

        SymbolLineReader(ReadConfiguration readConfiguration, Iterator<String> lines, String filename, Interner<Symbol> symbolInterner, int startLine) {
            this.table = new SymbolTable.FastBuilder(symbolInterner);
            this.readConfiguration = readConfiguration;
            this.lines = lines;
            this.filename = filename;
            this.currentLineNumber = startLine - 1;
        }

        private void readNextLine() {
            if (!this.lines.hasNext()) {
                this.currentLineContent = null;
            } else {
                this.currentLineContent = this.lines.next();
                ++this.currentLineNumber;
            }
        }

        SymbolTable.FastBuilder readLines() throws IOException {
            if (!this.lines.hasNext()) {
                return this.table;
            }
            this.readNextLine();
            try {
                while (this.currentLineContent != null) {
                    String canonicalName;
                    SymbolData data = this.readConfiguration.parseLine(this.currentLineContent);
                    if (data.resourceType == ResourceType.STYLEABLE) {
                        switch (data.javaType) {
                            case INT: {
                                if (this.readConfiguration.ignoreRogueChildren) {
                                    this.readNextLine();
                                    break;
                                }
                                throw new IOException("Unexpected styleable child " + this.currentLineContent);
                            }
                            case INT_LIST: {
                                this.readNextLine();
                                this.handleStyleable(this.table, data);
                            }
                        }
                        continue;
                    }
                    int value = 0;
                    if (this.readConfiguration.readValues) {
                        value = SymbolUtils.valueStringToInt(data.value);
                    }
                    String string = canonicalName = this.readConfiguration.rawSymbolNames ? SymbolUtils.canonicalizeValueResourceName(data.name) : data.name;
                    if (data.resourceType == ResourceType.ATTR) {
                        this.table.add(Symbol.attributeSymbol(data.name, value, data.maybeDefinition, data.accessibility, canonicalName));
                    } else {
                        this.table.add(Symbol.normalSymbol(data.resourceType, data.name, value, data.accessibility, canonicalName));
                    }
                    this.readNextLine();
                }
            }
            catch (IOException | IndexOutOfBoundsException e) {
                throw new IOException(String.format("File format error reading %1$s line %2$d: '%3$s'", this.filename, this.currentLineNumber, this.currentLineContent), e);
            }
            return this.table;
        }

        private void handleStyleable(SymbolTable.FastBuilder table, SymbolData data) throws IOException {
            ImmutableList<Integer> values;
            if (this.readConfiguration.singleLineStyleable) {
                String canonicalName = this.readConfiguration.rawSymbolNames ? SymbolUtils.canonicalizeValueResourceName(data.name) : data.name;
                table.add(Symbol.styleableSymbol(data.name, (ImmutableList<Integer>)ImmutableList.of(), data.children, data.accessibility, canonicalName));
                return;
            }
            String styleableLineContent = this.currentLineContent;
            int styleableLineIndex = this.currentLineNumber;
            String data_name = data.name + "_";
            this.aaptStyleableChildrenCache.clear();
            List<SymbolData> children = this.aaptStyleableChildrenCache;
            while (this.currentLineContent != null) {
                SymbolData subData = this.readConfiguration.parseLine(this.currentLineContent);
                if (subData.resourceType != ResourceType.STYLEABLE || subData.javaType != SymbolJavaType.INT) break;
                children.add(subData);
                this.readNextLine();
            }
            if (this.readConfiguration.readValues) {
                try {
                    children.sort(SYMBOL_DATA_VALUE_COMPARATOR);
                }
                catch (NumberFormatException e) {
                    this.currentLineContent = styleableLineContent;
                    this.currentLineNumber = styleableLineIndex;
                    throw new IOException(e);
                }
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SymbolData aaptStyleableChild : children) {
                builder.add((Object)SymbolIo.computeItemName(data_name, aaptStyleableChild.name));
            }
            ImmutableList childNames = builder.build();
            if (this.readConfiguration.readValues) {
                try {
                    values = SymbolUtils.parseArrayLiteral(childNames.size(), data.value);
                }
                catch (NumberFormatException e) {
                    this.currentLineContent = styleableLineContent;
                    this.currentLineNumber = styleableLineIndex;
                    throw new IOException("Unable to parse array literal " + data.name + " = " + data.value, e);
                }
            } else {
                values = ImmutableList.of();
            }
            String canonicalName = this.readConfiguration.rawSymbolNames ? SymbolUtils.canonicalizeValueResourceName(data.name) : data.name;
            table.add(Symbol.styleableSymbol(canonicalName, values, (ImmutableList<String>)childNames, data.accessibility, data.name));
        }
    }

    private static final class SymbolData {
        final ResourceVisibility accessibility;
        final ResourceType resourceType;
        final String name;
        final SymbolJavaType javaType;
        final String value;
        final ImmutableList<String> children;
        final boolean maybeDefinition;

        public SymbolData(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
            this.children = ImmutableList.of();
            this.maybeDefinition = false;
        }

        public SymbolData(ResourceVisibility accessibility, ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = accessibility;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
            this.children = ImmutableList.of();
            this.maybeDefinition = false;
        }

        public SymbolData(String name, ImmutableList<String> children) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.resourceType = ResourceType.STYLEABLE;
            this.name = name;
            this.javaType = SymbolJavaType.INT_LIST;
            this.value = "";
            this.children = children;
            this.maybeDefinition = false;
        }

        public SymbolData(ResourceType resourceType, String name) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = resourceType == ResourceType.STYLEABLE ? SymbolJavaType.INT_LIST : SymbolJavaType.INT;
            this.value = "";
            this.children = ImmutableList.of();
            this.maybeDefinition = false;
        }

        public SymbolData(String name, boolean maybeDefinition) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.name = name;
            this.javaType = SymbolJavaType.INT;
            this.resourceType = ResourceType.ATTR;
            this.value = "";
            this.children = ImmutableList.of();
            this.maybeDefinition = maybeDefinition;
        }
    }
}

