/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AssetFile;
import com.android.ide.common.resources.AssetItem;
import com.android.ide.common.resources.DataSet;
import com.android.ide.common.resources.MergingException;
import com.android.utils.ILogger;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AssetSet
extends DataSet<AssetItem, AssetFile> {
    public AssetSet(String configName, String aaptEnv) {
        super(configName, true, aaptEnv);
    }

    @Override
    protected DataSet<AssetItem, AssetFile> createSet(String name, String aaptEnv) {
        return new AssetSet(name, aaptEnv);
    }

    @Override
    protected AssetFile createFileAndItems(File sourceFolder, File file, ILogger logger, DocumentBuilderFactory factory) {
        return new AssetFile(file, AssetItem.create(sourceFolder, file));
    }

    @Override
    protected AssetFile createFileAndItemsFromXml(File file, Node fileNode) {
        Attr nameAttr = (Attr)fileNode.getAttributes().getNamedItem("name");
        if (nameAttr == null) {
            return null;
        }
        AssetItem item = new AssetItem(nameAttr.getValue());
        return new AssetFile(file, item);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file) {
        File parent;
        if (!super.isValidSourceFile(sourceFolder, file)) {
            return false;
        }
        for (parent = file.getParentFile(); parent != null && !parent.equals(sourceFolder); parent = parent.getParentFile()) {
            if (!this.isIgnored(parent)) continue;
            return false;
        }
        return parent != null;
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        this.readFiles(sourceFolder, sourceFolder, logger, factory);
    }

    private void readFiles(File sourceFolder, File folder, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (this.isIgnored(file)) continue;
                if (file.isFile()) {
                    this.handleNewFile(sourceFolder, file, logger, factory);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.readFiles(sourceFolder, file, logger, factory);
            }
        }
    }
}

