/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.ide.common.resources.RelativeResourceUtils;
import com.android.utils.ILogger;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/ide/common/blame/parser/aapt/Aapt2ErrorParser;", "Lcom/android/ide/common/blame/parser/aapt/AbstractAaptOutputParser;", "identifiedSourceSetMap", "", "", "(Ljava/util/Map;)V", "getIdentifiedSourceSetMap", "()Ljava/util/Map;", "parsers", "Ljava/util/ArrayList;", "Lcom/android/ide/common/blame/parser/aapt/Aapt2ErrorParser$MessageParser;", "parse", "", "line", "reader", "Lcom/android/ide/common/blame/parser/util/OutputLineReader;", "messages", "", "Lcom/android/ide/common/blame/Message;", "logger", "Lcom/android/utils/ILogger;", "MessageParser", "sdk-common"})
public final class Aapt2ErrorParser
extends AbstractAaptOutputParser {
    @NotNull
    private final Map<String, String> identifiedSourceSetMap;
    @NotNull
    private final ArrayList<MessageParser> parsers;

    public Aapt2ErrorParser(@NotNull Map<String, String> identifiedSourceSetMap) {
        Intrinsics.checkNotNullParameter(identifiedSourceSetMap, (String)"identifiedSourceSetMap");
        this.identifiedSourceSetMap = identifiedSourceSetMap;
        this.parsers = new ArrayList();
        Map<String, String> map = this.identifiedSourceSetMap;
        this.parsers.add(new MessageParser(map){

            @Override
            @NotNull
            protected String getLineNumber(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }

            @Override
            @NotNull
            protected String getColumnStart(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }

            @Override
            @NotNull
            protected String getColumnEnd(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }

            @Override
            @NotNull
            protected String getMessageText(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }
        });
        map = this.identifiedSourceSetMap;
        this.parsers.add(new MessageParser(map){

            @Override
            @NotNull
            protected String getLineNumber(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }

            @Override
            @NotNull
            protected String getColumnStart(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }

            @Override
            @NotNull
            protected String getMessageText(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }
        });
        map = this.identifiedSourceSetMap;
        this.parsers.add(new MessageParser(map){

            @Override
            @NotNull
            protected String getLineNumber(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }

            @Override
            @NotNull
            protected String getMessageText(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }
        });
        map = this.identifiedSourceSetMap;
        this.parsers.add(new MessageParser(map){

            @Override
            @NotNull
            protected String getMessageText(@NotNull Matcher m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                String string = m.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return string;
            }
        });
    }

    public /* synthetic */ Aapt2ErrorParser(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, String> getIdentifiedSourceSetMap() {
        return this.identifiedSourceSetMap;
    }

    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        for (MessageParser parser : this.parsers) {
            Message message = parser.parse(line, logger);
            if (message == null) continue;
            messages.add(message);
            return true;
        }
        return false;
    }

    public Aapt2ErrorParser() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/android/ide/common/blame/parser/aapt/Aapt2ErrorParser$MessageParser;", "", "pattern", "", "sourceSetMap", "", "(Ljava/lang/String;Ljava/util/Map;)V", "Ljava/util/regex/Pattern;", "getSourceSetMap", "()Ljava/util/Map;", "getColumnEnd", "m", "Ljava/util/regex/Matcher;", "getColumnStart", "getLineNumber", "getMessageText", "getSourcePath", "parse", "Lcom/android/ide/common/blame/Message;", "line", "logger", "Lcom/android/utils/ILogger;", "sdk-common"})
    private static abstract class MessageParser {
        @NotNull
        private final Map<String, String> sourceSetMap;
        @NotNull
        private final Pattern pattern;

        public MessageParser(@NotNull String pattern, @NotNull Map<String, String> sourceSetMap) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(sourceSetMap, (String)"sourceSetMap");
            this.sourceSetMap = sourceSetMap;
            Pattern pattern2 = Pattern.compile(pattern);
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
            this.pattern = pattern2;
        }

        @NotNull
        public final Map<String, String> getSourceSetMap() {
            return this.sourceSetMap;
        }

        @Nullable
        public final Message parse(@NotNull String line, @NotNull ILogger logger) throws ParsingFailedException {
            Message message;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Matcher m = this.pattern.matcher(line);
            if (!m.matches()) {
                message = null;
            } else {
                String string;
                Intrinsics.checkNotNull((Object)m);
                String rawSourcePath = this.getSourcePath(m);
                if (RelativeResourceUtils.isRelativeSourceSetResource(rawSourcePath) && MapsKt.any(this.sourceSetMap)) {
                    FileSystem fileSystem = FileSystems.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault(...)");
                    string = RelativeResourceUtils.relativeResourcePathToAbsolutePath(rawSourcePath, this.sourceSetMap, fileSystem);
                } else {
                    string = rawSourcePath;
                }
                String userReadableSourcePath = string;
                message = AbstractAaptOutputParser.createMessage(Message.Kind.ERROR, this.getMessageText(m), userReadableSourcePath, this.getLineNumber(m), this.getColumnStart(m), this.getColumnEnd(m), "", logger);
            }
            return message;
        }

        @NotNull
        protected abstract String getMessageText(@NotNull Matcher var1);

        @NotNull
        protected String getSourcePath(@NotNull Matcher m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            String string = m.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            return string;
        }

        @Nullable
        protected String getLineNumber(@NotNull Matcher m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return null;
        }

        @Nullable
        protected String getColumnStart(@NotNull Matcher m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return null;
        }

        @Nullable
        protected String getColumnEnd(@NotNull Matcher m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return null;
        }
    }
}

