/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.vectordrawable.PathBuilder;
import com.android.ide.common.vectordrawable.SvgClipPathNode;
import com.android.ide.common.vectordrawable.SvgGradientNode;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Svg2Vector {
    private static final Logger logger = Logger.getLogger(Svg2Vector.class.getSimpleName());
    private static final String SVG_DEFS = "defs";
    private static final String SVG_USE = "use";
    static final String SVG_HREF = "href";
    static final String SVG_XLINK_HREF = "xlink:href";
    public static final String SVG_POLYGON = "polygon";
    public static final String SVG_POLYLINE = "polyline";
    public static final String SVG_RECT = "rect";
    public static final String SVG_CIRCLE = "circle";
    public static final String SVG_LINE = "line";
    public static final String SVG_PATH = "path";
    public static final String SVG_ELLIPSE = "ellipse";
    public static final String SVG_GROUP = "g";
    public static final String SVG_STYLE = "style";
    public static final String SVG_DISPLAY = "display";
    public static final String SVG_CLIP_PATH_ELEMENT = "clipPath";
    public static final String SVG_D = "d";
    public static final String SVG_CLIP = "clip";
    public static final String SVG_CLIP_PATH = "clip-path";
    public static final String SVG_CLIP_RULE = "clip-rule";
    public static final String SVG_FILL = "fill";
    public static final String SVG_FILL_OPACITY = "fill-opacity";
    public static final String SVG_FILL_RULE = "fill-rule";
    public static final String SVG_OPACITY = "opacity";
    public static final String SVG_PAINT_ORDER = "paint-order";
    public static final String SVG_STROKE = "stroke";
    public static final String SVG_STROKE_LINECAP = "stroke-linecap";
    public static final String SVG_STROKE_LINEJOIN = "stroke-linejoin";
    public static final String SVG_STROKE_OPACITY = "stroke-opacity";
    public static final String SVG_STROKE_WIDTH = "stroke-width";
    public static final String SVG_MASK = "mask";
    public static final String SVG_POINTS = "points";
    public static final ImmutableMap<String, String> presentationMap = ImmutableMap.builder().put((Object)"clip", (Object)"android:clip").put((Object)"clip-rule", (Object)"").put((Object)"fill", (Object)"android:fillColor").put((Object)"fill-opacity", (Object)"android:fillAlpha").put((Object)"fill-rule", (Object)"android:fillType").put((Object)"opacity", (Object)"").put((Object)"paint-order", (Object)"").put((Object)"stroke", (Object)"android:strokeColor").put((Object)"stroke-linecap", (Object)"android:strokeLineCap").put((Object)"stroke-linejoin", (Object)"android:strokeLineJoin").put((Object)"stroke-opacity", (Object)"android:strokeAlpha").put((Object)"stroke-width", (Object)"android:strokeWidth").build();
    public static final ImmutableMap<String, String> gradientMap = ImmutableMap.builder().put((Object)"x1", (Object)"android:startX").put((Object)"y1", (Object)"android:startY").put((Object)"x2", (Object)"android:endX").put((Object)"y2", (Object)"android:endY").put((Object)"cx", (Object)"android:centerX").put((Object)"cy", (Object)"android:centerY").put((Object)"r", (Object)"android:gradientRadius").put((Object)"spreadMethod", (Object)"android:tileMode").put((Object)"gradientUnits", (Object)"").put((Object)"gradientTransform", (Object)"").put((Object)"gradientType", (Object)"android:type").build();
    private static final Set<String> unsupportedSvgNodes = ImmutableSet.of((Object)"animate", (Object)"animateColor", (Object)"animateMotion", (Object)"animateTransform", (Object)"mpath", (Object)"set", (Object[])new String[]{"a", "marker", "missing-glyph", "pattern", "switch", "feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "feSpecularLighting", "feTile", "feTurbulence", "font", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "hkern", "vkern", "stop", "ellipse", "image", "feDistantLight", "fePointLight", "feSpotLight", "symbol", "altGlyphDef", "altGlyphItem", "glyph", "glyphRef", "text", "altGlyph", "textPath", "tref", "tspan", "color-profile", "cursor", "filter", "foreignObject", "script", "view"});
    private static final Pattern SPACE_OR_COMMA = Pattern.compile("[\\s,]+");

    private static SvgTree parse(Path file) throws IOException {
        SvgTree svgTree = new SvgTree();
        ArrayList<String> parseErrors = new ArrayList<String>();
        Document doc = svgTree.parse(file, parseErrors);
        for (String error : parseErrors) {
            svgTree.logError(error, null);
        }
        NodeList svgNodes = doc.getElementsByTagName("svg");
        if (svgNodes.getLength() != 1) {
            String message = svgNodes.getLength() == 0 ? "No <svg> tags found." : "Multiple <svg> tags are not supported.";
            throw new IllegalStateException(message);
        }
        Element rootElement = (Element)svgNodes.item(0);
        svgTree.parseDimension(rootElement);
        if (svgTree.getViewBox() == null) {
            svgTree.logError("Missing \"viewBox\" in <svg> element", rootElement);
            return svgTree;
        }
        SvgGroupNode root = new SvgGroupNode(svgTree, rootElement, "root");
        svgTree.setRoot(root);
        Svg2Vector.traverseSvgAndExtract(svgTree, root, rootElement);
        Svg2Vector.resolveUseNodes(svgTree);
        Svg2Vector.resolveGradientReferences(svgTree);
        for (Map.Entry<String, Set<SvgNode>> entry : svgTree.getStyleAffectedNodes()) {
            for (SvgNode n : entry.getValue()) {
                Svg2Vector.addStyleToPath(n, svgTree.getStyleClassAttr(entry.getKey()));
            }
        }
        for (Map.Entry<Object, Set<SvgNode>> entry : svgTree.getClipPathAffectedNodesSet()) {
            Svg2Vector.handleClipPath(svgTree, (SvgNode)entry.getKey(), (SvgGroupNode)((Pair)entry.getValue()).getFirst(), (String)((Pair)entry.getValue()).getSecond());
        }
        svgTree.flatten();
        svgTree.validate();
        svgTree.dump();
        return svgTree;
    }

    private static void resolveUseNodes(SvgTree svgTree) {
        Set<SvgGroupNode> nodes = svgTree.getPendingUseSet();
        HashSet<SvgGroupNode> pendingUseSet = new HashSet<SvgGroupNode>(nodes);
        while (!nodes.isEmpty()) {
            if (nodes.removeIf(node -> node.resolveHref(svgTree))) continue;
            Svg2Vector.reportCycles(svgTree, nodes);
            return;
        }
        List<SvgGroupNode> ordering = Svg2Vector.getUseNodeTopologicalOrdering(svgTree, pendingUseSet);
        ordering.forEach(SvgGroupNode::handleUse);
    }

    @NotNull
    private static List<SvgGroupNode> getUseNodeTopologicalOrdering(SvgTree svgTree, Set<SvgGroupNode> pendingUseSet) {
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        HashMap reverseGraph = new HashMap();
        HashMap<Object, Integer> inDegrees = new HashMap<Object, Integer>();
        SvgGroupNode root = svgTree.getRoot();
        queue.add(root);
        reverseGraph.put(root, new HashSet());
        inDegrees.put(root, 0);
        while (!queue.isEmpty()) {
            SvgNode current = (SvgNode)queue.removeFirst();
            if (!(current instanceof SvgGroupNode)) continue;
            SvgGroupNode groupNode = (SvgGroupNode)current;
            for (SvgNode child : groupNode.mChildren) {
                reverseGraph.putIfAbsent(child, new HashSet());
                ((Set)reverseGraph.get(child)).add(current);
                if (inDegrees.containsKey(child)) continue;
                queue.addLast(child);
                inDegrees.put(child, 0);
            }
            SvgNode useRefNode = groupNode.mUseReferenceNode;
            if (useRefNode == null) continue;
            reverseGraph.putIfAbsent(useRefNode, new HashSet());
            ((Set)reverseGraph.get(useRefNode)).add(current);
            if (inDegrees.containsKey(useRefNode)) continue;
            queue.addLast(useRefNode);
            inDegrees.put(useRefNode, 0);
        }
        for (SvgNode node : reverseGraph.keySet()) {
            for (SvgNode child : (Set)reverseGraph.get(node)) {
                inDegrees.put(child, (Integer)inDegrees.get(child) + 1);
            }
        }
        for (SvgNode node : inDegrees.keySet()) {
            if ((Integer)inDegrees.get(node) != 0) continue;
            queue.add(node);
        }
        ArrayList<SvgGroupNode> topologicalOrdering = new ArrayList<SvgGroupNode>();
        while (!queue.isEmpty()) {
            SvgNode current = (SvgNode)queue.removeFirst();
            if (current instanceof SvgGroupNode) {
                SvgGroupNode groupNode = (SvgGroupNode)current;
                if (groupNode.mUseReferenceNode != null) {
                    topologicalOrdering.add(groupNode);
                    pendingUseSet.remove(groupNode);
                }
            }
            for (SvgNode child : (Set)reverseGraph.get(current)) {
                inDegrees.put(child, (Integer)inDegrees.get(child) - 1);
                if ((Integer)inDegrees.get(child) != 0) continue;
                queue.add(child);
            }
        }
        topologicalOrdering.addAll(pendingUseSet);
        return topologicalOrdering;
    }

    private static void resolveGradientReferences(SvgTree svgTree) {
        Set<SvgGradientNode> nodes = svgTree.getPendingGradientRefSet();
        while (!nodes.isEmpty()) {
            if (nodes.removeIf(node -> node.resolveHref(svgTree))) continue;
            Svg2Vector.reportCycles(svgTree, nodes);
            break;
        }
    }

    private static <T extends SvgNode> void reportCycles(SvgTree svgTree, Set<T> svgNodes) {
        HashMap<String, String> edges = new HashMap<String, String>();
        HashMap<String, Node> nodesById = new HashMap<String, Node>();
        for (SvgNode svgNode : svgNodes) {
            String targetId;
            Element element = svgNode.getDocumentElement();
            String id = element.getAttribute("id");
            if (id.isEmpty() || (targetId = svgNode.getHrefId()).isEmpty()) continue;
            edges.put(id, targetId);
            nodesById.put(id, element);
        }
        while (!edges.isEmpty()) {
            HashSet<String> visited = new HashSet<String>();
            Map.Entry entry = edges.entrySet().iterator().next();
            String id = (String)entry.getKey();
            String targetId = (String)entry.getValue();
            while (targetId != null && visited.add(id)) {
                id = targetId;
                targetId = (String)edges.get(id);
            }
            if (targetId != null) {
                Node node = (Node)nodesById.get(id);
                String cycle = Svg2Vector.getCycleStartingAt(id, edges, nodesById);
                svgTree.logError("Circular dependency of <use> nodes: " + cycle, node);
            }
            edges.keySet().removeAll(visited);
        }
    }

    private static String getCycleStartingAt(String startId, Map<String, String> edges, Map<String, Node> nodesById) {
        StringBuilder buf = new StringBuilder(startId);
        String id = startId;
        while (true) {
            id = edges.get(id);
            buf.append(" -> ").append(id);
            if (id.equals(startId)) break;
            buf.append(" (line ").append(SvgTree.getStartLine(nodesById.get(id))).append(")");
        }
        return buf.toString();
    }

    private static void traverseSvgAndExtract(SvgTree svgTree, SvgGroupNode currentGroup, Element item) {
        NodeList childNodes = item.getChildNodes();
        block27: for (int i = 0; i < childNodes.getLength(); ++i) {
            String tagName;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childNode.hasChildNodes() && !childNode.hasAttributes()) continue;
            Element childElement = (Element)childNode;
            switch (tagName = childElement.getTagName()) {
                case "path": 
                case "rect": 
                case "circle": 
                case "ellipse": 
                case "polygon": 
                case "polyline": 
                case "line": {
                    SvgLeafNode child = new SvgLeafNode(svgTree, childElement, tagName + i);
                    Svg2Vector.processIdName(svgTree, child);
                    currentGroup.addChild(child);
                    Svg2Vector.extractAllItemsAs(svgTree, child, childElement, currentGroup);
                    svgTree.setHasLeafNode(true);
                    continue block27;
                }
                case "g": {
                    SvgGroupNode childGroup = new SvgGroupNode(svgTree, childElement, "child" + i);
                    currentGroup.addChild(childGroup);
                    Svg2Vector.processIdName(svgTree, childGroup);
                    Svg2Vector.extractGroupNode(svgTree, childGroup, currentGroup);
                    Svg2Vector.traverseSvgAndExtract(svgTree, childGroup, childElement);
                    continue block27;
                }
                case "use": {
                    SvgGroupNode childGroup = new SvgGroupNode(svgTree, childElement, "child" + i);
                    Svg2Vector.processIdName(svgTree, childGroup);
                    currentGroup.addChild(childGroup);
                    svgTree.addToPendingUseSet(childGroup);
                    continue block27;
                }
                case "defs": {
                    SvgGroupNode childGroup = new SvgGroupNode(svgTree, childElement, "child" + i);
                    Svg2Vector.traverseSvgAndExtract(svgTree, childGroup, childElement);
                    continue block27;
                }
                case "clipPath": 
                case "mask": {
                    SvgClipPathNode clipPath = new SvgClipPathNode(svgTree, childElement, tagName + i);
                    Svg2Vector.processIdName(svgTree, clipPath);
                    Svg2Vector.traverseSvgAndExtract(svgTree, clipPath, childElement);
                    continue block27;
                }
                case "style": {
                    Svg2Vector.extractStyleNode(svgTree, childElement);
                    continue block27;
                }
                case "linearGradient": {
                    SvgGradientNode gradientNode = new SvgGradientNode(svgTree, childElement, tagName + i);
                    Svg2Vector.processIdName(svgTree, gradientNode);
                    Svg2Vector.extractGradientNode(svgTree, gradientNode);
                    gradientNode.fillPresentationAttributes("gradientType", "linear");
                    svgTree.setHasGradient(true);
                    continue block27;
                }
                case "radialGradient": {
                    SvgGradientNode gradientNode = new SvgGradientNode(svgTree, childElement, tagName + i);
                    Svg2Vector.processIdName(svgTree, gradientNode);
                    Svg2Vector.extractGradientNode(svgTree, gradientNode);
                    gradientNode.fillPresentationAttributes("gradientType", "radial");
                    svgTree.setHasGradient(true);
                    continue block27;
                }
                default: {
                    String id = childElement.getAttribute("id");
                    if (!id.isEmpty()) {
                        svgTree.addIgnoredId(id);
                    }
                    if (unsupportedSvgNodes.contains(tagName)) {
                        svgTree.logError("<" + tagName + "> is not supported", childElement);
                    }
                    Svg2Vector.traverseSvgAndExtract(svgTree, currentGroup, childElement);
                }
            }
        }
    }

    private static void extractGradientNode(SvgTree svg, SvgGradientNode gradientNode) {
        Element element = gradientNode.getDocumentElement();
        NamedNodeMap attrs = element.getAttributes();
        if (attrs.getNamedItem(SVG_HREF) != null || attrs.getNamedItem(SVG_XLINK_HREF) != null) {
            svg.addToPendingGradientRefSet(gradientNode);
        }
        int len = attrs.getLength();
        for (int j = 0; j < len; ++j) {
            Node n = attrs.item(j);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            if (!gradientMap.containsKey((Object)name)) continue;
            gradientNode.fillPresentationAttributes(name, value);
        }
        NodeList gradientChildren = element.getChildNodes();
        double greatestOffset = 0.0;
        for (int i = 0; i < gradientChildren.getLength(); ++i) {
            Node node = gradientChildren.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("stop")) continue;
            NamedNodeMap stopAttr = node.getAttributes();
            String color = "rgb(0,0,0)";
            String opacity = "1";
            for (int k = 0; k < stopAttr.getLength(); ++k) {
                Node stopItem = stopAttr.item(k);
                String name = stopItem.getNodeName();
                String value = stopItem.getNodeValue();
                try {
                    switch (name) {
                        case "offset": {
                            greatestOffset = Svg2Vector.extractOffset(value, greatestOffset);
                            break;
                        }
                        case "stop-color": {
                            color = value;
                            break;
                        }
                        case "stop-opacity": {
                            opacity = value;
                            break;
                        }
                        case "style": {
                            String[] parts;
                            for (String attr : parts = value.split(";")) {
                                String[] splitAttribute = attr.split(":");
                                if (splitAttribute.length != 2) continue;
                                if (attr.startsWith("stop-color")) {
                                    color = splitAttribute[1];
                                    continue;
                                }
                                if (!attr.startsWith("stop-opacity")) continue;
                                opacity = splitAttribute[1];
                            }
                            break;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    String msg = String.format("Invalid attribute value: %s=\"%s\"", name, value);
                    svg.logError(msg, node);
                }
            }
            String offset = svg.formatCoordinate(greatestOffset);
            String vdColor = gradientNode.colorSvg2Vd(color, "#000000");
            if (vdColor != null) {
                color = vdColor;
            }
            gradientNode.addGradientStop(color, offset, opacity);
        }
    }

    private static double extractOffset(String offset, double greatestOffset) {
        double x = offset.endsWith("%") ? Double.parseDouble(offset.substring(0, offset.length() - 1)) / 100.0 : Double.parseDouble(offset);
        x = Math.min(1.0, Math.max(x, 0.0));
        return Math.max(x, greatestOffset);
    }

    private static void extractGroupNode(SvgTree svgTree, SvgGroupNode childGroup, SvgGroupNode currentGroup) {
        NamedNodeMap a = childGroup.getDocumentElement().getAttributes();
        int len = a.getLength();
        for (int j = 0; j < len; ++j) {
            Node n = a.item(j);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                if (value.isEmpty()) continue;
                svgTree.addClipPathAffectedNode(childGroup, currentGroup, value);
                continue;
            }
            if (!name.equals("class") || value.isEmpty()) continue;
            svgTree.addAffectedNodeToStyleClass("." + value, childGroup);
        }
    }

    private static void extractStyleNode(SvgTree svgTree, Node currentNode) {
        NodeList a = currentNode.getChildNodes();
        int len = a.getLength();
        String styleData = "";
        for (int j = 0; j < len; ++j) {
            Node n = a.item(j);
            if (n.getNodeType() != 4 && len != 1) continue;
            styleData = n.getNodeValue();
        }
        if (!styleData.isEmpty()) {
            String[] classData;
            for (String aClassData : classData = styleData.split("}")) {
                String[] splitClassNames;
                String[] splitClassData = aClassData.split("\\{");
                if (splitClassData.length < 2) continue;
                String className = splitClassData[0].trim();
                String styleAttr = splitClassData[1].trim();
                for (String splitClassName : splitClassNames = className.split(",")) {
                    Object styleAttrTemp = styleAttr;
                    className = splitClassName.trim();
                    String existing = svgTree.getStyleClassAttr(className);
                    if (existing != null) {
                        styleAttrTemp = (String)styleAttrTemp + ";" + existing;
                    }
                    svgTree.addStyleClassToTree(className, (String)styleAttrTemp);
                }
            }
        }
    }

    private static void processIdName(SvgTree svgTree, SvgNode node) {
        String id = node.getAttributeValue("id");
        if (!id.isEmpty()) {
            svgTree.addIdToMap(id, node);
        }
    }

    private static void handleClipPath(SvgTree svg, SvgNode child, SvgGroupNode currentGroup, String value) {
        if (currentGroup == null || value == null) {
            return;
        }
        String clipName = Svg2Vector.getClipPathName(value);
        if (clipName == null) {
            return;
        }
        SvgNode clipNode = svg.getSvgNodeFromId(clipName);
        if (clipNode == null) {
            return;
        }
        SvgClipPathNode clipCopy = ((SvgClipPathNode)clipNode).deepCopy();
        currentGroup.replaceChild(child, clipCopy);
        clipCopy.addAffectedNode(child);
        clipCopy.setClipPathNodeAttributes();
    }

    private static String getClipPathName(String s) {
        if (s == null) {
            return null;
        }
        int startPos = s.indexOf(35);
        int endPos = s.indexOf(41, startPos + 1);
        if (endPos < 0) {
            endPos = s.length();
        }
        return s.substring(startPos + 1, endPos).trim();
    }

    private static void extractAllItemsAs(SvgTree svg, SvgLeafNode child, Node currentItem, SvgGroupNode currentGroup) {
        boolean hasNodeAttr = false;
        String styleContent = "";
        StringBuilder styleContentBuilder = new StringBuilder();
        boolean nothingToDisplay = false;
        for (Node parentNode = currentItem.getParentNode(); parentNode != null && parentNode.getNodeName().equals(SVG_GROUP); parentNode = parentNode.getParentNode()) {
            Node displayAttr;
            logger.log(Level.FINE, "Printing current parent");
            Svg2Vector.printlnCommon(parentNode);
            NamedNodeMap attr = parentNode.getAttributes();
            Node nodeAttr = attr.getNamedItem(SVG_STYLE);
            if (nodeAttr != null) {
                styleContentBuilder.append(nodeAttr.getTextContent());
                styleContentBuilder.append(';');
                styleContent = styleContentBuilder.toString();
                logger.log(Level.FINE, "styleContent is :" + styleContent + "at number group ");
                if (styleContent.contains("display:none")) {
                    logger.log(Level.FINE, "Found none style, skip the whole group");
                    nothingToDisplay = true;
                    break;
                }
                hasNodeAttr = true;
            }
            if ((displayAttr = attr.getNamedItem(SVG_DISPLAY)) == null || !"none".equals(displayAttr.getNodeValue())) continue;
            logger.log(Level.FINE, "Found display:none style, skip the whole group");
            nothingToDisplay = true;
            break;
        }
        if (nothingToDisplay) {
            return;
        }
        logger.log(Level.FINE, "Print current item");
        Svg2Vector.printlnCommon(currentItem);
        if (hasNodeAttr && !styleContent.isEmpty()) {
            Svg2Vector.addStyleToPath(child, styleContent);
        }
        if (SVG_PATH.equals(currentItem.getNodeName())) {
            Svg2Vector.extractPathItem(svg, child, currentItem, currentGroup);
        }
        if (SVG_RECT.equals(currentItem.getNodeName())) {
            Svg2Vector.extractRectItem(svg, child, currentItem, currentGroup);
        }
        if (SVG_CIRCLE.equals(currentItem.getNodeName())) {
            Svg2Vector.extractCircleItem(svg, child, currentItem, currentGroup);
        }
        if (SVG_POLYGON.equals(currentItem.getNodeName()) || SVG_POLYLINE.equals(currentItem.getNodeName())) {
            Svg2Vector.extractPolyItem(svg, child, currentItem, currentGroup);
        }
        if (SVG_LINE.equals(currentItem.getNodeName())) {
            Svg2Vector.extractLineItem(svg, child, currentItem, currentGroup);
        }
        if (SVG_ELLIPSE.equals(currentItem.getNodeName())) {
            Svg2Vector.extractEllipseItem(svg, child, currentItem, currentGroup);
        }
        svg.addAffectedNodeToStyleClass(currentItem.getNodeName(), child);
    }

    private static void printlnCommon(Node n) {
        logger.log(Level.FINE, " nodeName=\"" + n.getNodeName() + "\"");
        String val = n.getNamespaceURI();
        if (val != null) {
            logger.log(Level.FINE, " uri=\"" + val + "\"");
        }
        if ((val = n.getPrefix()) != null) {
            logger.log(Level.FINE, " pre=\"" + val + "\"");
        }
        if ((val = n.getLocalName()) != null) {
            logger.log(Level.FINE, " local=\"" + val + "\"");
        }
        if ((val = n.getNodeValue()) != null) {
            logger.log(Level.FINE, " nodeValue=");
            if (val.trim().isEmpty()) {
                logger.log(Level.FINE, "[WS]");
            } else {
                logger.log(Level.FINE, "\"" + n.getNodeValue() + "\"");
            }
        }
    }

    private static void extractPolyItem(SvgTree svgTree, SvgLeafNode child, Node currentGroupNode, SvgGroupNode currentGroup) {
        logger.log(Level.FINE, "Polyline or Polygon found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            NamedNodeMap attributes = currentGroupNode.getAttributes();
            int len = attributes.getLength();
            for (int itemIndex = 0; itemIndex < len; ++itemIndex) {
                Node n = attributes.item(itemIndex);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                try {
                    if (name.equals(SVG_STYLE)) {
                        Svg2Vector.addStyleToPath(child, value);
                        continue;
                    }
                    if (presentationMap.containsKey((Object)name)) {
                        child.fillPresentationAttributes(name, value);
                        continue;
                    }
                    if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                        svgTree.addClipPathAffectedNode(child, currentGroup, value);
                        continue;
                    }
                    if (name.equals(SVG_POINTS)) {
                        PathBuilder builder = new PathBuilder();
                        String[] split = SPACE_OR_COMMA.split(value);
                        float baseX = Float.parseFloat(split[0]);
                        float baseY = Float.parseFloat(split[1]);
                        builder.absoluteMoveTo(baseX, baseY);
                        for (int j = 2; j < split.length; j += 2) {
                            float x = Float.parseFloat(split[j]);
                            float y = Float.parseFloat(split[j + 1]);
                            builder.relativeLineTo(x - baseX, y - baseY);
                            baseX = x;
                            baseY = y;
                        }
                        if (SVG_POLYGON.equals(currentGroupNode.getNodeName())) {
                            builder.relativeClose();
                        }
                        child.setPathData(builder.toString());
                        continue;
                    }
                    if (!name.equals("class")) continue;
                    svgTree.addAffectedNodeToStyleClass("." + value, child);
                    svgTree.addAffectedNodeToStyleClass(currentGroupNode.getNodeName() + "." + value, child);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    svgTree.logError("Invalid value of \"" + name + "\" attribute", n);
                }
            }
        }
    }

    private static void extractRectItem(SvgTree svg, SvgLeafNode child, Node currentGroupNode, SvgGroupNode currentGroup) {
        logger.log(Level.FINE, "Rect found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            double x = 0.0;
            double y = 0.0;
            double width = Double.NaN;
            double height = Double.NaN;
            double rx = 0.0;
            double ry = 0.0;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                try {
                    if (name.equals(SVG_STYLE)) {
                        Svg2Vector.addStyleToPath(child, value);
                        if (!value.contains("opacity:0;")) continue;
                        pureTransparent = true;
                        continue;
                    }
                    if (presentationMap.containsKey((Object)name)) {
                        child.fillPresentationAttributes(name, value);
                        continue;
                    }
                    if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                        svg.addClipPathAffectedNode(child, currentGroup, value);
                        continue;
                    }
                    if (name.equals("x")) {
                        x = svg.parseXValue(value);
                        continue;
                    }
                    if (name.equals("y")) {
                        y = svg.parseYValue(value);
                        continue;
                    }
                    if (name.equals("rx")) {
                        rx = svg.parseXValue(value);
                        continue;
                    }
                    if (name.equals("ry")) {
                        ry = svg.parseYValue(value);
                        continue;
                    }
                    if (name.equals("width")) {
                        width = svg.parseXValue(value);
                        continue;
                    }
                    if (name.equals("height")) {
                        height = svg.parseYValue(value);
                        continue;
                    }
                    if (!name.equals("class")) continue;
                    svg.addAffectedNodeToStyleClass("rect." + value, child);
                    svg.addAffectedNodeToStyleClass("." + value, child);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    String msg = String.format("Invalid attribute value: %s=\"%s\"", name, value);
                    svg.logError(msg, currentGroupNode);
                }
            }
            if (!(pureTransparent || Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(width) || Double.isNaN(height))) {
                PathBuilder builder = new PathBuilder();
                if (rx <= 0.0 && ry <= 0.0) {
                    builder.absoluteMoveTo(x, y);
                    builder.relativeHorizontalTo(width);
                    builder.relativeVerticalTo(height);
                    builder.relativeHorizontalTo(-width);
                } else {
                    assert (rx > 0.0 || ry > 0.0);
                    if (ry == 0.0) {
                        ry = rx;
                    } else if (rx == 0.0) {
                        rx = ry;
                    }
                    if (rx > width / 2.0) {
                        rx = width / 2.0;
                    }
                    if (ry > height / 2.0) {
                        ry = height / 2.0;
                    }
                    builder.absoluteMoveTo(x + rx, y);
                    builder.absoluteLineTo(x + width - rx, y);
                    builder.absoluteArcTo(rx, ry, false, false, true, x + width, y + ry);
                    builder.absoluteLineTo(x + width, y + height - ry);
                    builder.absoluteArcTo(rx, ry, false, false, true, x + width - rx, y + height);
                    builder.absoluteLineTo(x + rx, y + height);
                    builder.absoluteArcTo(rx, ry, false, false, true, x, y + height - ry);
                    builder.absoluteLineTo(x, y + ry);
                    builder.absoluteArcTo(rx, ry, false, false, true, x + rx, y);
                }
                builder.relativeClose();
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractCircleItem(SvgTree svg, SvgLeafNode child, Node currentGroupNode, SvgGroupNode currentGroup) {
        logger.log(Level.FINE, "circle found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            float cx = 0.0f;
            float cy = 0.0f;
            float radius = 0.0f;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    if (!value.contains("opacity:0;")) continue;
                    pureTransparent = true;
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                    svg.addClipPathAffectedNode(child, currentGroup, value);
                    continue;
                }
                if (name.equals("cx")) {
                    cx = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("cy")) {
                    cy = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("r")) {
                    radius = Float.parseFloat(value);
                    continue;
                }
                if (!name.equals("class")) continue;
                svg.addAffectedNodeToStyleClass("circle." + value, child);
                svg.addAffectedNodeToStyleClass("." + value, child);
            }
            if (!(pureTransparent || Float.isNaN(cx) || Float.isNaN(cy))) {
                PathBuilder builder = new PathBuilder();
                builder.absoluteMoveTo(cx, cy);
                builder.relativeMoveTo(-radius, 0.0);
                builder.relativeArcTo(radius, radius, false, true, true, 2.0f * radius, 0.0);
                builder.relativeArcTo(radius, radius, false, true, true, -2.0f * radius, 0.0);
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractEllipseItem(SvgTree svg, SvgLeafNode child, Node currentGroupNode, SvgGroupNode currentGroup) {
        logger.log(Level.FINE, "ellipse found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            float cx = 0.0f;
            float cy = 0.0f;
            float rx = 0.0f;
            float ry = 0.0f;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    if (!value.contains("opacity:0;")) continue;
                    pureTransparent = true;
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                    svg.addClipPathAffectedNode(child, currentGroup, value);
                    continue;
                }
                if (name.equals("cx")) {
                    cx = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("cy")) {
                    cy = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("rx")) {
                    rx = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("ry")) {
                    ry = Float.parseFloat(value);
                    continue;
                }
                if (!name.equals("class")) continue;
                svg.addAffectedNodeToStyleClass("ellipse." + value, child);
                svg.addAffectedNodeToStyleClass("." + value, child);
            }
            if (!pureTransparent && !Float.isNaN(cx) && !Float.isNaN(cy) && rx > 0.0f && ry > 0.0f) {
                PathBuilder builder = new PathBuilder();
                builder.absoluteMoveTo(cx - rx, cy);
                builder.relativeArcTo(rx, ry, false, true, false, 2.0f * rx, 0.0);
                builder.relativeArcTo(rx, ry, false, true, false, -2.0f * rx, 0.0);
                builder.relativeClose();
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractLineItem(SvgTree svg, SvgLeafNode child, Node currentGroupNode, SvgGroupNode currentGroup) {
        logger.log(Level.FINE, "line found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 0.0f;
            float y2 = 0.0f;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    if (!value.contains("opacity:0;")) continue;
                    pureTransparent = true;
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                    svg.addClipPathAffectedNode(child, currentGroup, value);
                    continue;
                }
                if (name.equals("x1")) {
                    x1 = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("y1")) {
                    y1 = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("x2")) {
                    x2 = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("y2")) {
                    y2 = Float.parseFloat(value);
                    continue;
                }
                if (!name.equals("class")) continue;
                svg.addAffectedNodeToStyleClass("line." + value, child);
                svg.addAffectedNodeToStyleClass("." + value, child);
            }
            if (!(pureTransparent || Float.isNaN(x1) || Float.isNaN(y1) || Float.isNaN(x2) || Float.isNaN(y2))) {
                PathBuilder builder = new PathBuilder();
                builder.absoluteMoveTo(x1, y1);
                builder.absoluteLineTo(x2, y2);
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractPathItem(SvgTree svg, SvgLeafNode child, Node currentGroupNode, SvgGroupNode currentGroup) {
        logger.log(Level.FINE, "Path found " + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals(SVG_CLIP_PATH) || name.equals(SVG_MASK)) {
                    svg.addClipPathAffectedNode(child, currentGroup, value);
                    continue;
                }
                if (name.equals(SVG_D)) {
                    String pathData = Pattern.compile("(\\d)-").matcher(value).replaceAll("$1,-");
                    child.setPathData(pathData);
                    continue;
                }
                if (!name.equals("class")) continue;
                svg.addAffectedNodeToStyleClass("path." + value, child);
                svg.addAffectedNodeToStyleClass("." + value, child);
            }
        }
    }

    private static void addStyleToPath(SvgNode path, String value) {
        logger.log(Level.FINE, "Style found is " + value);
        if (value != null) {
            String[] parts = value.split(";");
            int k = parts.length;
            while (--k >= 0) {
                SvgGroupNode parentNode;
                String subStyle = parts[k];
                String[] nameValue = subStyle.split(":");
                if (nameValue.length != 2 || nameValue[0] == null || nameValue[1] == null) continue;
                String attr = nameValue[0].trim();
                String val = nameValue[1].trim();
                if (presentationMap.containsKey((Object)attr)) {
                    path.fillPresentationAttributes(attr, val);
                } else if (attr.equals(SVG_OPACITY)) {
                    path.fillPresentationAttributes(SVG_FILL_OPACITY, nameValue[1]);
                }
                if (!attr.equals(SVG_CLIP_PATH) && !attr.equals(SVG_MASK) || (parentNode = path.getTree().findParent(path)) == null) continue;
                path.getTree().addClipPathAffectedNode(path, parentNode, val);
            }
        }
    }

    static float parseFloatOrDefault(String value, float defaultValue) {
        if (!value.isEmpty()) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static void writeFile(OutputStream outStream, SvgTree svgTree) throws IOException {
        svgTree.writeXml(outStream);
    }

    @Slow
    public static String parseSvgToXml(Path inputSvg, OutputStream outStream) throws IOException {
        SvgTree svgTree = Svg2Vector.parse(inputSvg);
        if (svgTree.getHasLeafNode()) {
            Svg2Vector.writeFile(outStream, svgTree);
        }
        return svgTree.getErrorMessage();
    }
}

