/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AndroidAaptIgnore;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000eR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/ide/common/resources/PatternBasedFileFilter;", "", "androidAaptIgnore", "Lcom/android/ide/common/resources/AndroidAaptIgnore;", "(Lcom/android/ide/common/resources/AndroidAaptIgnore;)V", "aaptStyleIgnoredPattern", "", "(Ljava/lang/String;)V", "ignoredPatterns", "", "(Ljava/util/List;)V", "getAaptStyleIgnoredPattern", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "isIgnored", "file", "Ljava/io/File;", "filePath", "isDirectory", "sdk-common"})
public final class PatternBasedFileFilter {
    @NotNull
    private final List<String> ignoredPatterns;

    @NotNull
    public final String getAaptStyleIgnoredPattern() {
        String string = Joiner.on((char)':').join((Iterable)this.ignoredPatterns);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    public PatternBasedFileFilter(@NotNull AndroidAaptIgnore androidAaptIgnore) {
        Intrinsics.checkNotNullParameter((Object)androidAaptIgnore, (String)"androidAaptIgnore");
        String patterns = androidAaptIgnore.getAaptIgnoreValue();
        if (patterns == null || ((CharSequence)patterns).length() == 0) {
            patterns = "!.svn:!.git:!.ds_store:!*.scc:.*:<dir>_*:!CVS:!thumbs.db:!picasa.ini:!*~";
        }
        List list = Splitter.on((char)':').splitToList((CharSequence)patterns);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitToList(...)");
        this.ignoredPatterns = list;
    }

    public PatternBasedFileFilter(@NotNull String aaptStyleIgnoredPattern) {
        Intrinsics.checkNotNullParameter((Object)aaptStyleIgnoredPattern, (String)"aaptStyleIgnoredPattern");
        List list = Splitter.on((char)':').splitToList((CharSequence)aaptStyleIgnoredPattern);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitToList(...)");
        this.ignoredPatterns = list;
    }

    public PatternBasedFileFilter(@NotNull List<String> ignoredPatterns) {
        Intrinsics.checkNotNullParameter(ignoredPatterns, (String)"ignoredPatterns");
        this.ignoredPatterns = CollectionsKt.toList((Iterable)ignoredPatterns);
    }

    public final boolean isIgnored(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String filePath = file.getPath();
        if (Intrinsics.areEqual((Object)filePath, (Object)".") || Intrinsics.areEqual((Object)filePath, (Object)"..")) {
            return true;
        }
        boolean isDirectory = file.isDirectory();
        Intrinsics.checkNotNull((Object)filePath);
        return this.isIgnored(filePath, isDirectory);
    }

    public final boolean isIgnored(@NotNull String filePath, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (Intrinsics.areEqual((Object)filePath, (Object)".") || Intrinsics.areEqual((Object)filePath, (Object)"..")) {
            return true;
        }
        boolean ignore = false;
        int nameIndex = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null) + 1;
        int nameLength = filePath.length() - nameIndex;
        for (String token : this.ignoredPatterns) {
            if (((CharSequence)token).length() == 0) continue;
            int tokenIndex = 0;
            if (token.charAt(tokenIndex) == '!') {
                ++tokenIndex;
            }
            if (StringsKt.regionMatches$default((String)token, (int)tokenIndex, (String)"<dir>", (int)0, (int)5, (boolean)false, (int)16, null)) {
                if (!isDirectory) continue;
                tokenIndex += 5;
            }
            if (StringsKt.regionMatches$default((String)token, (int)tokenIndex, (String)"<file>", (int)0, (int)6, (boolean)false, (int)16, null)) {
                if (isDirectory) continue;
                tokenIndex += 6;
            }
            int n = token.length() - tokenIndex;
            if (token.charAt(tokenIndex) == '*') {
                ++tokenIndex;
                if (--n <= nameLength) {
                    ignore = StringsKt.regionMatches((String)token, (int)tokenIndex, (String)filePath, (int)(nameIndex + nameLength - n), (int)n, (boolean)true);
                }
            } else if (n > 1 && token.charAt(token.length() - 1) == '*') {
                ignore = StringsKt.regionMatches((String)token, (int)tokenIndex, (String)filePath, (int)nameIndex, (int)(n - 1), (boolean)true);
            } else {
                boolean bl = ignore = token.length() - tokenIndex == filePath.length() - nameIndex && StringsKt.regionMatches((String)token, (int)tokenIndex, (String)filePath, (int)nameIndex, (int)(filePath.length() - nameIndex), (boolean)true);
            }
            if (!ignore) continue;
            break;
        }
        return ignore;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        PatternBasedFileFilter otherFilter = (PatternBasedFileFilter)other;
        return Intrinsics.areEqual(this.ignoredPatterns, otherFilter.ignoredPatterns);
    }

    public int hashCode() {
        return ((Object)this.ignoredPatterns).hashCode();
    }
}

