/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002'(B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0019J\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0019H\u0086\u0002J\u0013\u0010 \u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0003H\u0016J\u001e\u0010#\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J8\u0010#\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\fJ\u001e\u0010%\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\b\u0010&\u001a\u00020\u0019H\u0016R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/android/ide/common/repository/AgpVersion;", "", "major", "", "minor", "micro", "(III)V", "previewKind", "Lcom/android/ide/common/repository/AgpVersion$PreviewKind;", "preview", "(IIILcom/android/ide/common/repository/AgpVersion$PreviewKind;Ljava/lang/Integer;)V", "isPreview", "", "()Z", "isSnapshot", "getMajor", "()I", "getMicro", "getMinor", "getPreview", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPreviewKind", "()Lcom/android/ide/common/repository/AgpVersion$PreviewKind;", "previewType", "", "getPreviewType", "()Ljava/lang/String;", "compareIgnoringQualifiers", "other", "value", "compareTo", "equals", "", "hashCode", "isAtLeast", "previewVersion", "isAtLeastIncludingPreviews", "toString", "Companion", "PreviewKind", "sdk-common"})
public final class AgpVersion
implements Comparable<AgpVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int micro;
    @NotNull
    private final PreviewKind previewKind;
    @Nullable
    private final Integer preview;
    @NotNull
    private static final Regex VERSION_REGEX;
    @NotNull
    private static final Regex STABLE_VERSION_REGEX;

    private AgpVersion(int major, int minor, int micro, PreviewKind previewKind, Integer preview) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.previewKind = previewKind;
        this.preview = preview;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    @NotNull
    public final PreviewKind getPreviewKind() {
        return this.previewKind;
    }

    @Nullable
    public final Integer getPreview() {
        return this.preview;
    }

    @Nullable
    public final String getPreviewType() {
        return this.previewKind.toPreviewType();
    }

    public final boolean isPreview() {
        return PreviewKind.NONE != this.previewKind;
    }

    public final boolean isSnapshot() {
        return this.previewKind.toIsSnapshot();
    }

    @JvmOverloads
    public AgpVersion(int major, int minor, int micro) {
        this(major, minor, micro, PreviewKind.NONE, null);
    }

    public /* synthetic */ AgpVersion(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        AgpVersion that = (AgpVersion)other;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.major, this.minor, this.micro, this.previewKind, this.preview};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    public int compareTo(@NotNull AgpVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.major != other.major ? this.major - other.major : (this.minor != other.minor ? this.minor - other.minor : (this.micro != other.micro ? this.micro - other.micro : (this.previewKind != other.previewKind ? this.previewKind.ordinal() - other.previewKind.ordinal() : (this.preview != null && other.preview != null ? this.preview - other.preview : 0))));
    }

    @Override
    public final int compareTo(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.compareTo(Companion.parse(value));
    }

    public final int compareIgnoringQualifiers(@NotNull AgpVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        AgpVersion thisWithoutQualifiers = new AgpVersion(this.major, this.minor, this.micro);
        AgpVersion otherWithoutQualifiers = new AgpVersion(other.major, other.minor, other.micro);
        return thisWithoutQualifiers.compareTo(otherWithoutQualifiers);
    }

    public final int compareIgnoringQualifiers(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.compareIgnoringQualifiers(Companion.parse(value));
    }

    public final boolean isAtLeast(int major, int minor, int micro) {
        return this.compareTo(new AgpVersion(major, minor, micro)) >= 0;
    }

    public final boolean isAtLeastIncludingPreviews(int major, int minor, int micro) {
        AgpVersion thisWithoutQualifiers = new AgpVersion(this.major, this.minor, this.micro);
        return thisWithoutQualifiers.compareTo(new AgpVersion(major, minor, micro)) >= 0;
    }

    public final boolean isAtLeast(int major, int minor, int micro, @Nullable String previewType, int previewVersion, boolean isSnapshot) {
        PreviewKind previewKind = PreviewKind.Companion.fromPreviewTypeAndIsSnapshot(previewType, isSnapshot);
        AgpVersion other = new AgpVersion(major, minor, micro, previewKind, previewVersion);
        return this.compareTo(other) >= 0;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Locale locale = Locale.US;
        String string = "%d.%d.%d%s";
        Object[] objectArray = new Object[]{this.major, this.minor, this.micro, this.previewKind};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        sb.append(string2);
        if (this.preview != null) {
            if (AgpVersion.Companion.isTwoDigitPreviewFormat(this.major, this.minor, this.micro, this.previewKind)) {
                locale = Locale.US;
                string = "%02d";
                objectArray = new Object[]{this.preview};
                String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                sb.append(string3);
            } else {
                locale = Locale.US;
                string = "%d";
                objectArray = new Object[]{this.preview};
                String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                sb.append(string4);
            }
        }
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return string5;
    }

    @JvmOverloads
    public AgpVersion(int major, int minor) {
        this(major, minor, 0, 4, null);
    }

    @JvmStatic
    @Nullable
    public static final AgpVersion tryParse(@NotNull String value) {
        return Companion.tryParse(value);
    }

    @JvmStatic
    @NotNull
    public static final AgpVersion parse(@NotNull String value) {
        return Companion.parse(value);
    }

    @JvmStatic
    @Nullable
    public static final AgpVersion tryParseStable(@NotNull String value) {
        return Companion.tryParseStable(value);
    }

    @JvmStatic
    @NotNull
    public static final AgpVersion parseStable(@NotNull String value) {
        return Companion.parseStable(value);
    }

    public /* synthetic */ AgpVersion(int major, int minor, int micro, PreviewKind previewKind, Integer preview, DefaultConstructorMarker $constructor_marker) {
        this(major, minor, micro, previewKind, preview);
    }

    static {
        String digit = "[0-9]";
        String num = "(?:0|[1-9]" + digit + "*)";
        String previewKind = "-(?:alpha|beta|rc)";
        String dot = Regex.Companion.escape(".");
        String dev = "-dev";
        String pattern = "(" + num + ")" + dot + "(" + num + ")" + dot + "(" + num + ")(?:(" + previewKind + ")(" + digit + digit + "?)|(" + dev + "))?";
        VERSION_REGEX = new Regex(pattern);
        digit = "[0-9]";
        num = "(?:0|[1-9]" + digit + "*)";
        String dot2 = Regex.Companion.escape(".");
        String pattern2 = "(" + num + ")" + dot2 + "(" + num + ")" + dot2 + "(" + num + ")";
        STABLE_VERSION_REGEX = new Regex(pattern2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/ide/common/repository/AgpVersion$Companion;", "", "()V", "STABLE_VERSION_REGEX", "Lkotlin/text/Regex;", "VERSION_REGEX", "isTwoDigitPreviewFormat", "", "major", "", "minor", "micro", "previewKind", "Lcom/android/ide/common/repository/AgpVersion$PreviewKind;", "parse", "Lcom/android/ide/common/repository/AgpVersion;", "value", "", "parsePreviewString", "previewString", "parseStable", "tryParse", "tryParseStable", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTwoDigitPreviewFormat(int major, int minor, int micro, PreviewKind previewKind) {
            return major > 3 || major == 3 && minor > 1 || major == 3 && minor == 1 && micro == 0 && previewKind != PreviewKind.BETA;
        }

        private final int parsePreviewString(int major, int minor, int micro, PreviewKind previewKind, String previewString) {
            if (this.isTwoDigitPreviewFormat(major, minor, micro, previewKind) && previewString.length() != 2) {
                throw new NumberFormatException("AgpVersion " + major + "." + minor + "." + micro + previewKind + " requires a two digit preview, but received \"" + previewString + "\".");
            }
            if (!this.isTwoDigitPreviewFormat(major, minor, micro, previewKind) && StringsKt.startsWith$default((String)previewString, (String)"0", (boolean)false, (int)2, null)) {
                throw new NumberFormatException("AgpVersion " + major + "." + minor + "." + micro + previewKind + " requires no zero-padding, but received \"" + previewString + "\".");
            }
            return Integer.parseInt(previewString);
        }

        @JvmStatic
        @Nullable
        public final AgpVersion tryParse(@NotNull String value) {
            AgpVersion agpVersion;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            MatchResult matchResult = VERSION_REGEX.matchEntire((CharSequence)value);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            List matchList = matchResult2.getDestructured().toList();
            try {
                Integer n;
                int major = Integer.parseInt((String)matchList.get(0));
                int minor = Integer.parseInt((String)matchList.get(1));
                int micro = Integer.parseInt((String)matchList.get(2));
                PreviewKind previewKind = Intrinsics.areEqual((Object)"-alpha", matchList.get(3)) ? PreviewKind.ALPHA : (Intrinsics.areEqual((Object)"-beta", matchList.get(3)) ? PreviewKind.BETA : (Intrinsics.areEqual((Object)"-rc", matchList.get(3)) ? PreviewKind.RC : (Intrinsics.areEqual((Object)"-dev", matchList.get(5)) ? PreviewKind.DEV : PreviewKind.NONE)));
                switch (WhenMappings.$EnumSwitchMapping$0[previewKind.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        n = this.parsePreviewString(major, minor, micro, previewKind, (String)matchList.get(4));
                        break;
                    }
                    default: {
                        n = null;
                    }
                }
                Integer preview = n;
                agpVersion = new AgpVersion(major, minor, micro, previewKind, preview, null);
            }
            catch (NumberFormatException e) {
                agpVersion = null;
            }
            return agpVersion;
        }

        @JvmStatic
        @NotNull
        public final AgpVersion parse(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            AgpVersion agpVersion = this.tryParse(value);
            if (agpVersion == null) {
                throw new IllegalArgumentException(value + " is not a valid AGP version string.");
            }
            return agpVersion;
        }

        @JvmStatic
        @Nullable
        public final AgpVersion tryParseStable(@NotNull String value) {
            AgpVersion agpVersion;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            MatchResult matchResult = STABLE_VERSION_REGEX.matchEntire((CharSequence)value);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            List matchList = matchResult2.getDestructured().toList();
            try {
                int major = Integer.parseInt((String)matchList.get(0));
                int minor = Integer.parseInt((String)matchList.get(1));
                int micro = Integer.parseInt((String)matchList.get(2));
                agpVersion = new AgpVersion(major, minor, micro);
            }
            catch (NumberFormatException e) {
                agpVersion = null;
            }
            return agpVersion;
        }

        @JvmStatic
        @NotNull
        public final AgpVersion parseStable(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            AgpVersion agpVersion = this.tryParseStable(value);
            if (agpVersion == null) {
                throw new IllegalArgumentException(value + " is not a valid stable AGP version string.");
            }
            return agpVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PreviewKind.values().length];
                try {
                    nArray[PreviewKind.ALPHA.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PreviewKind.BETA.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PreviewKind.RC.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0016j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/android/ide/common/repository/AgpVersion$PreviewKind;", "", "(Ljava/lang/String;I)V", "toIsSnapshot", "", "toPreviewType", "", "toString", "ALPHA", "BETA", "RC", "DEV", "NONE", "Companion", "sdk-common"})
    public static final class PreviewKind
    extends Enum<PreviewKind> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ PreviewKind ALPHA;
        public static final /* enum */ PreviewKind BETA;
        public static final /* enum */ PreviewKind RC;
        public static final /* enum */ PreviewKind DEV;
        public static final /* enum */ PreviewKind NONE;
        private static final /* synthetic */ PreviewKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String toString() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = "-alpha";
                    break;
                }
                case 2: {
                    string = "-beta";
                    break;
                }
                case 3: {
                    string = "-rc";
                    break;
                }
                case 4: {
                    string = "-dev";
                    break;
                }
                case 5: {
                    string = "";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Nullable
        public final String toPreviewType() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = "alpha";
                    break;
                }
                case 2: {
                    string = "beta";
                    break;
                }
                case 3: {
                    string = "rc";
                    break;
                }
                case 4: 
                case 5: {
                    string = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public final boolean toIsSnapshot() {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    bl = false;
                    break;
                }
                case 4: {
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        public static PreviewKind[] values() {
            return (PreviewKind[])$VALUES.clone();
        }

        public static PreviewKind valueOf(String value) {
            return Enum.valueOf(PreviewKind.class, value);
        }

        @NotNull
        public static EnumEntries<PreviewKind> getEntries() {
            return $ENTRIES;
        }

        static {
            ALPHA = new PreviewKind();
            BETA = new PreviewKind();
            RC = new PreviewKind();
            DEV = new PreviewKind();
            NONE = new PreviewKind();
            $VALUES = previewKindArray = new PreviewKind[]{PreviewKind.ALPHA, PreviewKind.BETA, PreviewKind.RC, PreviewKind.DEV, PreviewKind.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/ide/common/repository/AgpVersion$PreviewKind$Companion;", "", "()V", "fromPreviewTypeAndIsSnapshot", "Lcom/android/ide/common/repository/AgpVersion$PreviewKind;", "value", "", "isSnapshot", "", "sdk-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PreviewKind fromPreviewTypeAndIsSnapshot(@Nullable String value, boolean isSnapshot) {
                PreviewKind previewKind;
                if (Intrinsics.areEqual((Object)"alpha", (Object)value)) {
                    previewKind = ALPHA;
                } else if (Intrinsics.areEqual((Object)"beta", (Object)value)) {
                    previewKind = BETA;
                } else if (Intrinsics.areEqual((Object)"rc", (Object)value)) {
                    previewKind = RC;
                } else if (value == null && isSnapshot) {
                    previewKind = DEV;
                } else if (value == null && !isSnapshot) {
                    previewKind = NONE;
                } else {
                    throw new IllegalArgumentException(value + " is not a PreviewKind");
                }
                return previewKind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PreviewKind.values().length];
                try {
                    nArray[PreviewKind.ALPHA.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PreviewKind.BETA.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PreviewKind.RC.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PreviewKind.DEV.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PreviewKind.NONE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

