/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

class SvgGroupNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    protected final ArrayList<SvgNode> mChildren = new ArrayList();

    SvgGroupNode(SvgTree svgTree, Element docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    public SvgGroupNode deepCopy() {
        SvgGroupNode newInstance = new SvgGroupNode(this.getTree(), this.mDocumentElement, this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    @Override
    protected <T extends SvgGroupNode> void copyFrom(T from) {
        super.copyFrom(from);
        for (SvgNode child : from.mChildren) {
            this.addChild(child.deepCopy());
        }
    }

    boolean resolveHref(SvgTree svgTree) {
        SvgNode referencedNode;
        String id = this.getHrefId();
        SvgNode svgNode = referencedNode = id.isEmpty() ? null : svgTree.getSvgNodeFromId(id);
        if (referencedNode == null) {
            if (id.isEmpty() || !svgTree.isIdIgnored(id)) {
                svgTree.logError("Referenced id not found", this.mDocumentElement);
            }
        } else {
            if (svgTree.getPendingUseSet().contains(referencedNode)) {
                return false;
            }
            SvgNode copiedNode = referencedNode.deepCopy();
            this.addChild(copiedNode);
            for (Map.Entry entry : this.mVdAttributesMap.entrySet()) {
                String key = (String)entry.getKey();
                copiedNode.fillPresentationAttributes(key, (String)entry.getValue());
            }
            this.fillEmptyAttributes(this.mVdAttributesMap);
            float x = Svg2Vector.parseFloatOrDefault(this.mDocumentElement.getAttribute("x"), 0.0f);
            float y = Svg2Vector.parseFloatOrDefault(this.mDocumentElement.getAttribute("y"), 0.0f);
            this.transformIfNeeded(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y));
        }
        return true;
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void replaceChild(SvgNode oldChild, SvgNode newChild) {
        int index = this.mChildren.indexOf(oldChild);
        if (index < 0) {
            throw new IllegalArgumentException("The child being replaced doesn't belong to this group");
        }
        this.mChildren.set(index, newChild);
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "group: " + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + "  ");
        }
    }

    public SvgGroupNode findParent(SvgNode node) {
        for (SvgNode n : this.mChildren) {
            SvgGroupNode parent;
            if (n == node) {
                return this;
            }
            if (!n.isGroupNode() || (parent = ((SvgGroupNode)n).findParent(node)) == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void flatten(AffineTransform transform) {
        for (SvgNode node : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            node.flatten(this.mStackedTransform);
        }
    }

    @Override
    public void validate() {
        for (SvgNode node : this.mChildren) {
            node.validate();
        }
    }

    @Override
    public void writeXml(OutputStreamWriter writer, String indent) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXml(writer, indent);
        }
    }

    @Override
    public SvgNode.VisitResult accept(SvgNode.Visitor visitor) {
        SvgNode.VisitResult result2 = visitor.visit(this);
        if (result2 == SvgNode.VisitResult.CONTINUE) {
            for (SvgNode node : this.mChildren) {
                if (node.accept(visitor) != SvgNode.VisitResult.ABORT) continue;
                return SvgNode.VisitResult.ABORT;
            }
        }
        return result2 == SvgNode.VisitResult.SKIP_CHILDREN ? SvgNode.VisitResult.CONTINUE : result2;
    }

    @Override
    public void fillPresentationAttributes(String name, String value) {
        super.fillPresentationAttributes(name, value);
        for (SvgNode n : this.mChildren) {
            if (n.mVdAttributesMap.containsKey(name)) continue;
            n.fillPresentationAttributes(name, value);
        }
    }
}

