/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdUtil;
import com.google.common.collect.Iterables;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

class SvgClipPathNode
extends SvgGroupNode {
    private final ArrayList<SvgNode> mAffectedNodes = new ArrayList();

    SvgClipPathNode(SvgTree svgTree, Element element, String name) {
        super(svgTree, element, name);
    }

    @Override
    public SvgClipPathNode deepCopy() {
        SvgClipPathNode newInstance = new SvgClipPathNode(this.getTree(), this.mDocumentElement, this.mName);
        newInstance.copyFrom(this);
        return newInstance;
    }

    protected void copyFrom(SvgClipPathNode from) {
        super.copyFrom(from);
        for (SvgNode node : from.mAffectedNodes) {
            this.addAffectedNode(node);
        }
    }

    @Override
    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void addAffectedNode(SvgNode child) {
        this.mAffectedNodes.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    @Override
    public void flatten(AffineTransform transform) {
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
        this.mStackedTransform.setTransform(transform);
        for (SvgNode n : this.mAffectedNodes) {
            n.flatten(this.mStackedTransform);
        }
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() & 6) != 0) {
            this.logWarning("Scaling of the stroke width is ignored");
        }
    }

    @Override
    public void validate() {
        super.validate();
        for (SvgNode n : this.mChildren) {
            n.validate();
        }
        for (SvgNode n : this.mAffectedNodes) {
            n.validate();
        }
        if (this.mDocumentElement.getTagName().equals("mask") && !this.isWhiteFill()) {
            this.logError("Semitransparent mask cannot be represented by a vector drawable");
        }
    }

    private boolean isWhiteFill() {
        String fillColor = (String)this.mVdAttributesMap.get("fill");
        if (fillColor == null) {
            return false;
        }
        if ((fillColor = this.colorSvg2Vd(fillColor, "#000")) == null) {
            return false;
        }
        return VdUtil.parseColorValue(fillColor) == -1;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : Iterables.concat((Iterable)this.mChildren, this.mAffectedNodes)) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void writeXml(OutputStreamWriter writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<group>");
        writer.write(System.lineSeparator());
        String incrementedIndent = indent + "  ";
        EnumMap clipPaths = new EnumMap(SvgNode.ClipRule.class);
        SvgNode.Visitor clipPathCollector = node -> {
            String pathData;
            if (node instanceof SvgLeafNode && (pathData = ((SvgLeafNode)node).getPathData()) != null && !pathData.isEmpty()) {
                SvgNode.ClipRule clipRule = "evenOdd".equals(node.mVdAttributesMap.get("clip-rule")) ? SvgNode.ClipRule.EVEN_ODD : SvgNode.ClipRule.NON_ZERO;
                List paths = clipPaths.computeIfAbsent(clipRule, key -> new ArrayList());
                paths.add(pathData);
            }
            return SvgNode.VisitResult.CONTINUE;
        };
        for (SvgNode svgNode : this.mChildren) {
            svgNode.accept(clipPathCollector);
        }
        for (Map.Entry entry : clipPaths.entrySet()) {
            SvgNode.ClipRule clipRule = (SvgNode.ClipRule)((Object)entry.getKey());
            List pathData = (List)entry.getValue();
            writer.write(incrementedIndent);
            writer.write(60);
            writer.write("clip-path");
            writer.write(System.lineSeparator());
            writer.write(incrementedIndent);
            writer.write("  ");
            writer.write("  ");
            writer.write("android:pathData=\"");
            for (int i = 0; i < pathData.size(); ++i) {
                String path = (String)pathData.get(i);
                if (i > 0 && !path.startsWith("M")) {
                    writer.write("M 0,0");
                }
                writer.write(path);
            }
            writer.write(34);
            if (clipRule == SvgNode.ClipRule.EVEN_ODD) {
                writer.write(System.lineSeparator());
                writer.write(incrementedIndent);
                writer.write("  ");
                writer.write("  ");
                writer.write("android:fillType=\"evenOdd\"");
            }
            writer.write("/>");
            writer.write(System.lineSeparator());
        }
        for (SvgNode svgNode : this.mAffectedNodes) {
            svgNode.writeXml(writer, incrementedIndent);
        }
        writer.write(indent);
        writer.write("</group>");
        writer.write(System.lineSeparator());
    }

    public void setClipPathNodeAttributes() {
        for (SvgNode n : this.mAffectedNodes) {
            this.mLocalTransform.concatenate(n.mLocalTransform);
        }
    }
}

