/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStringUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00130\u0012\u001a.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\""}, d2={"RESOURCE_PROTOCOLS", "", "", "[Ljava/lang/String;", "colorToString", "color", "Ljava/awt/Color;", "colorToStringWithAlpha", "extend", "", "nibble", "fileNameToResourceName", "fileName", "findUnusedResources", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resources", "rootsConsumer", "Lkotlin/Function1;", "", "Ljava/util/function/Consumer;", "isInvalidResourceFieldNameCharacter", "", "c", "", "parseColor", "s", "resourceNameToFieldName", "resourceName", "stripPrefixFromId", "id", "toFileResourcePathString", "Lcom/android/ide/common/util/PathString;", "resourcePath", "sdk-common"})
@JvmName(name="ResourcesUtil")
@SourceDebugExtension(value={"SMAP\nResourcesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesUtil.kt\ncom/android/ide/common/resources/ResourcesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n766#2:244\n857#2,2:245\n1855#2,2:247\n1855#2,2:249\n*S KotlinDebug\n*F\n+ 1 ResourcesUtil.kt\ncom/android/ide/common/resources/ResourcesUtil\n*L\n128#1:244\n128#1:245,2\n130#1:247,2\n125#1:249,2\n*E\n"})
public final class ResourcesUtil {
    @NotNull
    private static final String[] RESOURCE_PROTOCOLS;

    @NotNull
    public static final String resourceNameToFieldName(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        int n = resourceName.length();
        for (int i = 0; i < n; ++i) {
            char c = resourceName.charAt(i);
            if (!ResourcesUtil.isInvalidResourceFieldNameCharacter(c)) continue;
            char[] buffer = new char[resourceName.length()];
            String string = resourceName;
            int n2 = 0;
            int n3 = 0;
            string.getChars(n3, i, buffer, n2);
            buffer[i] = 95;
            for (int j = i + 1; j < n; ++j) {
                c = resourceName.charAt(j);
                buffer[j] = ResourcesUtil.isInvalidResourceFieldNameCharacter(c) ? 95 : (int)c;
            }
            return new String(buffer);
        }
        return resourceName;
    }

    public static final boolean isInvalidResourceFieldNameCharacter(char c) {
        return c == ':' || c == '.' || c == '-';
    }

    @NotNull
    public static final String fileNameToResourceName(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int lastExtension = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastExtension <= 0) {
            string = fileName;
        } else if (StringsKt.endsWith((String)fileName, (String)".9.png", (boolean)true)) {
            if (fileName.length() > 6) {
                String string2 = fileName.substring(0, fileName.length() - 6);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = fileName;
            }
        } else {
            String string3 = fileName.substring(0, lastExtension);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        return string;
    }

    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Consumer<List<ResourceUsageModel.Resource>> rootsConsumer) {
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(rootsConsumer, (String)"rootsConsumer");
        return ResourcesUtil.findUnusedResources(resources, (Function1<? super List<? extends ResourceUsageModel.Resource>, Unit>)((Function1)new Function1<List<? extends ResourceUsageModel.Resource>, Unit>(rootsConsumer){
            final /* synthetic */ Consumer<List<ResourceUsageModel.Resource>> $rootsConsumer;
            {
                this.$rootsConsumer = $rootsConsumer;
                super(1);
            }

            public final void invoke(@NotNull List<? extends ResourceUsageModel.Resource> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$rootsConsumer.accept(it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Function1<? super List<? extends ResourceUsageModel.Resource>, Unit> rootsConsumer) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(rootsConsumer, (String)"rootsConsumer");
        Set<ResourceUsageModel.Resource> seen = Collections.newSetFromMap(new IdentityHashMap());
        Iterable $this$filter$iv = resources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv$iv;
            boolean bl = false;
            if (!(it.isReachable() || it.isKeep() || it.isPublic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        rootsConsumer.invoke((Object)roots);
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            ResourcesUtil.findUnusedResources$visit(seen, it);
        }
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)resources), (Function1)findUnusedResources.3.INSTANCE), (Function1)findUnusedResources.4.INSTANCE), (Function1)findUnusedResources.5.INSTANCE), (Function1)findUnusedResources.6.INSTANCE));
    }

    @Nullable
    public static final PathString toFileResourcePathString(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        for (String protocol : RESOURCE_PROTOCOLS) {
            if (!StringsKt.startsWith$default((String)resourcePath, (String)protocol, (boolean)false, (int)2, null) || resourcePath.length() <= protocol.length() || resourcePath.charAt(protocol.length()) != ':') continue;
            int prefixLength = protocol.length() + 1;
            if (StringsKt.startsWith$default((String)resourcePath, (String)"//", (int)prefixLength, (boolean)false, (int)4, null)) {
                prefixLength += 2;
            }
            String string = resourcePath.substring(prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return new PathString(protocol, string);
        }
        File file = new File(resourcePath);
        return file.isFile() ? PathStringUtil.toPathString(file) : null;
    }

    @Deprecated(message="Use `ResourceUrl.parse` instead and handle wrong resource type, invalid name, trailing whitespace etc.", replaceWith=@ReplaceWith(expression="ResourceUrl.parse(id)?.name ?: id", imports={"com.android.resources.ResourceUrl"}))
    @NotNull
    public static final String stripPrefixFromId(@NotNull String id) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string2 = id.substring(5);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
            String string3 = id.substring(4);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = id;
        }
        return string;
    }

    @NotNull
    public static final String colorToString(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            String string = "#%08X";
            Object[] objectArray = new Object[]{longColor |= (long)color.getAlpha() << 24};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        String string = "#%06X";
        Object[] objectArray = new Object[]{longColor};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public static final String colorToStringWithAlpha(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        String string = "0x%08X";
        Object[] objectArray = new Object[]{(long)(color.getRed() << 16 | color.getGreen() << 8 | color.getBlue()) | (long)color.getAlpha() << 24};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Nullable
    public static final Color parseColor(@Nullable String s) {
        String string = s;
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return null;
        }
        String trimmed = string;
        if (((CharSequence)trimmed).length() == 0) {
            return null;
        }
        if (trimmed.charAt(0) == '#') {
            String string2 = trimmed.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            Long l = StringsKt.toLongOrNull((String)string2, (int)16);
            if (l == null) {
                return null;
            }
            long longColor = l;
            if (trimmed.length() == 4 || trimmed.length() == 5) {
                long a = trimmed.length() == 4 ? 255L : ResourcesUtil.extend((longColor & 0xF000L) >> 12);
                long r = ResourcesUtil.extend((longColor & 0xF00L) >> 8);
                long g = ResourcesUtil.extend((longColor & 0xF0L) >> 4);
                long b = ResourcesUtil.extend(longColor & 0xFL);
                longColor = a << 24 | r << 16 | g << 8 | b;
                return new Color((int)longColor, true);
            }
            if (trimmed.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (trimmed.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    private static final long extend(long nibble) {
        return nibble | nibble << 4;
    }

    private static final void findUnusedResources$visit(Set<ResourceUsageModel.Resource> seen, ResourceUsageModel.Resource resource) {
        block2: {
            if (seen.contains(resource)) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(seen, (String)"seen");
            ((Collection)seen).add(resource);
            resource.setReachable(true);
            List<ResourceUsageModel.Resource> list = resource.references;
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ResourcesUtil.findUnusedResources$visit(seen, it);
            }
        }
    }

    static {
        String[] stringArray = new String[]{"apk", "jar", "file"};
        RESOURCE_PROTOCOLS = stringArray;
    }
}

