/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractResourceRepository
implements ResourceRepository {
    protected abstract ListMultimap<String, ResourceItem> getResourcesInternal(ResourceNamespace var1, ResourceType var2);

    @Override
    public List<ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType, String resourceName) {
        ListMultimap<String, ResourceItem> map = this.getResourcesInternal(namespace, resourceType);
        List items = map.get((Object)resourceName);
        return items.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf((Collection)items);
    }

    @Override
    public List<ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType, Predicate<ResourceItem> filter2) {
        ArrayList<ResourceItem> result2 = null;
        ListMultimap<String, ResourceItem> map = this.getResourcesInternal(namespace, resourceType);
        for (ResourceItem item : map.values()) {
            if (!filter2.test(item)) continue;
            if (result2 == null) {
                result2 = new ArrayList<ResourceItem>();
            }
            result2.add(item);
        }
        return result2 == null ? ImmutableList.of() : result2;
    }

    @Override
    public ListMultimap<String, ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType) {
        ListMultimap<String, ResourceItem> map = this.getResourcesInternal(namespace, resourceType);
        return ImmutableListMultimap.copyOf(map);
    }

    @Override
    public boolean hasResources(ResourceNamespace namespace, ResourceType resourceType, String resourceName) {
        ListMultimap<String, ResourceItem> map = this.getResourcesInternal(namespace, resourceType);
        List items = map.get((Object)resourceName);
        return !items.isEmpty();
    }

    @Override
    public boolean hasResources(ResourceNamespace namespace, ResourceType resourceType) {
        ListMultimap<String, ResourceItem> map = this.getResourcesInternal(namespace, resourceType);
        return !map.isEmpty();
    }

    @Override
    public Set<ResourceType> getResourceTypes(ResourceNamespace namespace) {
        EnumSet<ResourceType> result2 = EnumSet.noneOf(ResourceType.class);
        for (ResourceType resourceType : ResourceType.values()) {
            if (!this.hasResources(namespace, resourceType)) continue;
            result2.add(resourceType);
        }
        return Sets.immutableEnumSet(result2);
    }

    protected static ResourceVisitor.VisitResult acceptByResources(Map<ResourceType, ListMultimap<String, ResourceItem>> map, ResourceVisitor visitor) {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : map.entrySet()) {
            if (!visitor.shouldVisitResourceType(entry.getKey())) continue;
            for (ResourceItem item : entry.getValue().values()) {
                if (visitor.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                return ResourceVisitor.VisitResult.ABORT;
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }
}

