/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.repository.AliasStyle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a$\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\f\u0010\u0017\u001a\u00020\u0011*\u00020\fH\u0002\u001a\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0001H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u0001H\u0001\u00a8\u0006\u001b"}, d2={"cutDomainPrefix", "", "group", "generateWithSuffix", "prefix", "reserved", "", "getAliasStyle", "Lcom/android/ide/common/repository/AliasStyle;", "reservedAliases", "getGroupPrefix", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "maybeLowCamelTransform", "name", "pickLibraryVariableName", "includeVersionInKey", "", "caseSensitiveReserved", "pickPluginVariableName", "pluginId", "pickPluginVersionVariableName", "pickVersionVariableName", "isAndroidX", "isCommonDomain", "toSafeHyphenKey", "toSafeKey", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogNamingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,349:1\n1747#2,3:350\n1064#3,2:353\n*S KotlinDebug\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n*L\n54#1:350,3\n146#1:353,2\n*E\n"})
public final class VersionCatalogNamingUtilKt {
    private static final boolean isAndroidX(Dependency $this$isAndroidX) {
        String string = $this$isAndroidX.getGroup();
        return string != null ? StringsKt.startsWith$default((String)string, (String)"androidx.", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public static final String pickLibraryVariableName(@NotNull Dependency dependency, boolean includeVersionInKey, @NotNull Set<String> caseSensitiveReserved) {
        String name;
        String groupId;
        String full;
        String artifactId;
        String artifactKey;
        String versionSuffix;
        TreeSet reserved;
        block16: {
            String key;
            block17: {
                boolean bl;
                block15: {
                    String string;
                    CharSequence charSequence;
                    Regex regex;
                    Object object;
                    String string2;
                    RichVersion richVersion;
                    Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
                    Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
                    reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                    reserved.addAll(caseSensitiveReserved);
                    Object object2 = includeVersionInKey ? "-v" + (String)((richVersion = dependency.getVersion()) != null && (string2 = richVersion.toIdentifier()) != null && (object = (regex = new Regex("[^A-Za-z0-9]")).replace(charSequence = (CharSequence)string2, string = "")) != null && (charSequence = VersionCatalogNamingUtilKt.toSafeKey((String)object)) != null ? charSequence : "") : (versionSuffix = "");
                    if (!VersionCatalogNamingUtilKt.isAndroidX(dependency)) break block16;
                    if (reserved.isEmpty()) break block17;
                    Iterable $this$any$iv = reserved;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)"androidx-", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block16;
            }
            if (!reserved.contains(key = "androidx-" + VersionCatalogNamingUtilKt.toSafeKey(dependency.getName()) + versionSuffix)) {
                return key;
            }
        }
        if (!reserved.contains(artifactKey = (artifactId = VersionCatalogNamingUtilKt.toSafeKey(dependency.getName())) + versionSuffix)) {
            return artifactKey;
        }
        String string = dependency.getGroup();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null || (string = VersionCatalogNamingUtilKt.toSafeKey(string)) == null) {
            string = "nogroup";
        }
        String groupSuffix = string;
        String withGroupSuffix = groupSuffix + "-" + artifactId + versionSuffix;
        if (!StringsKt.startsWith$default((String)artifactId, (String)groupSuffix, (boolean)false, (int)2, null) && !reserved.contains(withGroupSuffix)) {
            return withGroupSuffix;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(dependency);
        String withGroupPrefix = groupPrefix + "-" + artifactId + versionSuffix;
        if (!reserved.contains(withGroupPrefix)) {
            return withGroupPrefix;
        }
        String string3 = dependency.getGroup();
        if (string3 == null || (string3 = VersionCatalogNamingUtilKt.toSafeKey(string3)) == null) {
            string3 = "nogroup";
        }
        if (!reserved.contains(full = (groupId = string3) + "-" + artifactId + versionSuffix)) {
            return full;
        }
        int id = 2;
        while (reserved.contains(name = full + (((CharSequence)versionSuffix).length() > 0 ? "-x" : "") + id++)) {
        }
        return name;
    }

    @NotNull
    public static final String pickPluginVariableName(@NotNull String pluginId, @NotNull Set<String> caseSensitiveReserved) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        String plugin = VersionCatalogNamingUtilKt.cutDomainPrefix(pluginId);
        String shortSafeKey = VersionCatalogNamingUtilKt.toSafeHyphenKey(plugin);
        String shortName = VersionCatalogNamingUtilKt.maybeLowCamelTransform(shortSafeKey);
        if (!reserved.contains(shortName)) {
            return shortName;
        }
        String fullSafeKey = VersionCatalogNamingUtilKt.toSafeHyphenKey(pluginId);
        String fullName = VersionCatalogNamingUtilKt.maybeLowCamelTransform(fullSafeKey);
        if (!reserved.contains(fullName)) {
            return fullName;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(fullName + "X", reserved);
    }

    private static final String maybeLowCamelTransform(String name) {
        String string;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"-", (boolean)false, (int)2, null)) {
            String string2 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name)");
        } else {
            string = name;
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String toSafeKey(@NotNull String $this$toSafeKey) {
        boolean bl;
        int n;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$toSafeKey, (String)"<this>");
            CharSequence $this$all$iv = $this$toSafeKey;
            boolean $i$f$all = false;
            for (n = 0; n < $this$all$iv.length(); ++n) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl2 = false;
                if (Character.isLetterOrDigit(it) || it == '-' || it == '_') continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return $this$toSafeKey;
        }
        StringBuilder sb = new StringBuilder();
        n = $this$toSafeKey.length();
        for (int i = 0; i < n; ++i) {
            int c = $this$toSafeKey.charAt(i);
            sb.append((char)(Character.isLetterOrDigit((char)c) || c == 45 ? c : (c == 46 ? 45 : 95)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String toSafeHyphenKey(@NotNull String $this$toSafeHyphenKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toSafeHyphenKey, (String)"<this>");
        return StringsKt.replace$default((String)VersionCatalogNamingUtilKt.toSafeKey($this$toSafeHyphenKey), (String)"_", (String)"-", (boolean)false, (int)4, null);
    }

    private static final String getGroupPrefix(Dependency dependency) {
        String string = dependency.getGroup();
        if (string == null) {
            return "nogroup";
        }
        String group = string;
        String groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)group, (char)'.', null, (int)2, null));
        if (VersionCatalogNamingUtilKt.isCommonDomain(groupPrefix)) {
            return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)group, (char)'.', null, (int)2, null), (char)'.', null, (int)2, null));
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    private static final boolean isCommonDomain(String $this$isCommonDomain) {
        return Intrinsics.areEqual((Object)$this$isCommonDomain, (Object)"com") || Intrinsics.areEqual((Object)$this$isCommonDomain, (Object)"org") || Intrinsics.areEqual((Object)$this$isCommonDomain, (Object)"io");
    }

    private static final String cutDomainPrefix(String group) {
        String groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)group, (char)'.', null, (int)2, null));
        if (VersionCatalogNamingUtilKt.isCommonDomain(groupPrefix)) {
            return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringAfter$default((String)group, (char)'.', null, (int)2, null));
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    @NotNull
    public static final String pickVersionVariableName(@NotNull Dependency dependency, @NotNull Set<String> caseSensitiveReserved) {
        String groupId;
        String withGroupId;
        String withGroupIdPrefixVersion;
        String withVersion;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        String artifact = VersionCatalogNamingUtilKt.toSafeKey(dependency.getName());
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        if (reserved.isEmpty()) {
            return artifact;
        }
        AliasStyle aliasStyle = VersionCatalogNamingUtilKt.getAliasStyle(reserved);
        boolean haveCamelCase = aliasStyle.component1();
        boolean haveHyphen = aliasStyle.component2();
        String artifactCamel = StringsKt.contains$default((CharSequence)artifact, (char)'-', (boolean)false, (int)2, null) ? CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, artifact) : artifact;
        String artifactName = haveCamelCase ? artifactCamel : artifact;
        if (!((Collection)reserved).isEmpty()) {
            Object e = reserved.first();
            Intrinsics.checkNotNullExpressionValue(e, (String)"reserved.first()");
            if (StringsKt.endsWith$default((String)((String)e), (String)"Version", (boolean)false, (int)2, null) && !reserved.contains(withVersion = artifactCamel + "Version")) {
                return withVersion;
            }
        }
        if (!reserved.contains(artifactName)) {
            Intrinsics.checkNotNullExpressionValue((Object)artifactName, (String)"artifactName");
            return artifactName;
        }
        if (!haveHyphen && !reserved.contains(withVersion = artifactCamel + "Version")) {
            return withVersion;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(dependency);
        String withGroupIdPrefix = groupPrefix + "-" + artifactName;
        if (!reserved.contains(withGroupIdPrefix)) {
            return withGroupIdPrefix;
        }
        if (!haveHyphen && !reserved.contains(withGroupIdPrefixVersion = groupPrefix + "-" + artifactCamel + "Version")) {
            return withGroupIdPrefixVersion;
        }
        String string = dependency.getGroup();
        if (string == null || (string = VersionCatalogNamingUtilKt.toSafeKey(string)) == null) {
            string = "nogroup";
        }
        if (!reserved.contains(withGroupId = (groupId = string) + "-" + artifactName)) {
            return withGroupId;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(withGroupId, reserved);
    }

    private static final AliasStyle getAliasStyle(Set<String> reservedAliases) {
        boolean haveCamelCase = false;
        boolean haveHyphen = false;
        for (String name : reservedAliases) {
            int n = name.length();
            for (int i = 0; i < n; ++i) {
                char c = name.charAt(i);
                if (c == '-') {
                    haveHyphen = true;
                    continue;
                }
                if (i <= 0 || !Character.isUpperCase(c) || !Character.isLowerCase(name.charAt(i - 1)) || !Character.isLowerCase(name.charAt(0))) continue;
                haveCamelCase = true;
            }
        }
        return new AliasStyle(haveCamelCase, haveHyphen);
    }

    private static final String generateWithSuffix(String prefix, Set<String> reserved) {
        String name;
        int id = 2;
        while (reserved.contains(name = prefix + id++)) {
        }
        return name;
    }

    @NotNull
    public static final String pickPluginVersionVariableName(@NotNull String pluginId, @NotNull Set<String> caseSensitiveReserved) {
        String withVersion;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        String plugin = VersionCatalogNamingUtilKt.cutDomainPrefix(pluginId);
        String safeKey = VersionCatalogNamingUtilKt.toSafeHyphenKey(plugin);
        if (reserved.isEmpty()) {
            return safeKey;
        }
        AliasStyle aliasStyle = VersionCatalogNamingUtilKt.getAliasStyle(reserved);
        boolean haveCamelCase = aliasStyle.component1();
        boolean haveHyphen = aliasStyle.component2();
        String pluginCamel = VersionCatalogNamingUtilKt.maybeLowCamelTransform(plugin);
        String pluginName = haveCamelCase ? pluginCamel : plugin;
        if (!((Collection)reserved).isEmpty()) {
            Object e = reserved.first();
            Intrinsics.checkNotNullExpressionValue(e, (String)"reserved.first()");
            if (StringsKt.endsWith$default((String)((String)e), (String)"Version", (boolean)false, (int)2, null) && !reserved.contains(withVersion = pluginCamel + "Version")) {
                return withVersion;
            }
        }
        if (!reserved.contains(pluginName)) {
            return pluginName;
        }
        if (!haveHyphen && !reserved.contains(withVersion = pluginCamel + "Version")) {
            return withVersion;
        }
        String fullName = VersionCatalogNamingUtilKt.toSafeKey(pluginId);
        if (!reserved.contains(fullName)) {
            return fullName;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(fullName, reserved);
    }
}

