/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.Module;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.MavenRepositories;
import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public enum SdkMavenRepository {
    ANDROID("android"),
    GOOGLE("google");

    private final String mDir;

    private SdkMavenRepository(String dir) {
        this.mDir = dir;
    }

    public Path getRepositoryLocation(Path sdkHome, boolean requireExists) {
        if (sdkHome != null) {
            Path dir = sdkHome.resolve("extras" + File.separator + this.mDir + File.separator + "m2repository");
            if (!requireExists || CancellableFileIo.isDirectory((Path)dir, (LinkOption[])new LinkOption[0])) {
                return dir;
            }
        }
        return null;
    }

    public boolean isInstalled(Path sdkHome) {
        return this.getRepositoryLocation(sdkHome, true) != null;
    }

    public boolean isInstalled(AndroidSdkHandler sdkHandler) {
        if (sdkHandler != null) {
            ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
            RepoManager mgr = sdkHandler.getSdkManager((ProgressIndicator)progress);
            return mgr.getPackages().getLocalPackages().containsKey(this.getPackageId());
        }
        return false;
    }

    public String getPackageId() {
        return String.format("extras;%s;%s", this.mDir, "m2repository");
    }

    public static SdkMavenRepository find(Path sdkLocation, String groupId, String artifactId) {
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            Path artifactIdDirectory;
            Path repositoryLocation = repository.getRepositoryLocation(sdkLocation, true);
            if (repositoryLocation == null || !CancellableFileIo.exists((Path)(artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repositoryLocation, groupId, artifactId)), (LinkOption[])new LinkOption[0])) continue;
            return repository;
        }
        return null;
    }

    public String getDirName() {
        return this.mDir;
    }

    public static Component getComponentFromSdkPath(String path) {
        String prefix = String.join((CharSequence)Character.toString(';'), "extras", "m2repository", "");
        if (!path.startsWith(prefix)) {
            return null;
        }
        ArrayList directories = Lists.newArrayList((Object[])path.split(Character.toString(';')));
        String version = (String)directories.remove(directories.size() - 1);
        String name = (String)directories.remove(directories.size() - 1);
        String group = String.join((CharSequence)".", directories.subList(2, directories.size()));
        return new Component(group, name, Version.Companion.parse(version));
    }

    public static RepoPackage findBestPackageMatching(Dependency dependency, Collection<? extends RepoPackage> packages) {
        RepoPackage result2 = null;
        RichVersion richVersion = dependency.getVersion();
        Component component = null;
        for (RepoPackage repoPackage : packages) {
            Component test = SdkMavenRepository.getComponentFromSdkPath(repoPackage.getPath());
            if (test == null || !test.getGroup().equals(dependency.getGroup()) || !test.getName().equals(dependency.getName()) || richVersion != null && !richVersion.contains(test.getVersion()) || component != null && test.getVersion().compareTo(component.getVersion()) <= 0) continue;
            component = test;
            result2 = repoPackage;
        }
        return result2;
    }

    public static LocalPackage findLatestLocalVersion(Module module, boolean allowPreview, AndroidSdkHandler sdkHandler, Predicate<Version> filter2, ProgressIndicator progress) {
        String prefix = DetailsTypes.MavenType.getRepositoryPath((String)module.getGroup(), (String)module.getName(), null);
        Predicate<Revision> revisionFilter = filter2 == null ? null : revision -> filter2.test(SdkMavenRepository.revisionToVersion(revision));
        return sdkHandler.getLatestLocalPackageForPrefix(prefix, revisionFilter, allowPreview, Version.Companion::parse, progress);
    }

    @Deprecated
    public static LocalPackage findLatestLocalVersion(Dependency dependency, AndroidSdkHandler sdkHandler, Predicate<Version> filter2, ProgressIndicator progress) {
        Module module = dependency.getModule();
        if (module == null) {
            return null;
        }
        return SdkMavenRepository.findLatestLocalVersion(module, dependency.getExplicitlyIncludesPreview(), sdkHandler, filter2, progress);
    }

    private static Version revisionToVersion(Revision revision) {
        return Version.Companion.parse(revision.toString("-"));
    }

    public static RemotePackage findLatestRemoteVersion(Module module, boolean allowPreview, AndroidSdkHandler sdkHandler, Predicate<Version> filter2, ProgressIndicator progress) {
        String prefix = DetailsTypes.MavenType.getRepositoryPath((String)module.getGroup(), (String)module.getName(), null);
        Predicate<Revision> revisionFilter = filter2 == null ? null : revision -> filter2.test(SdkMavenRepository.revisionToVersion(revision));
        return sdkHandler.getLatestRemotePackageForPrefix(prefix, revisionFilter, allowPreview, Version.Companion::parse, progress);
    }

    @Deprecated
    public static RemotePackage findLatestRemoteVersion(Dependency dependency, AndroidSdkHandler sdkHandler, Predicate<Version> filter2, ProgressIndicator progress) {
        Module module = dependency.getModule();
        if (module == null) {
            return null;
        }
        return SdkMavenRepository.findLatestRemoteVersion(module, dependency.getExplicitlyIncludesPreview(), sdkHandler, filter2, progress);
    }

    public static RepoPackage findLatestVersion(Module module, boolean allowPreview, AndroidSdkHandler sdkHandler, Predicate<Version> filter2, ProgressIndicator progress) {
        LocalPackage local = SdkMavenRepository.findLatestLocalVersion(module, allowPreview, sdkHandler, filter2, progress);
        RemotePackage remote = SdkMavenRepository.findLatestRemoteVersion(module, allowPreview, sdkHandler, filter2, progress);
        if (local == null) {
            return remote;
        }
        if (remote == null) {
            return local;
        }
        Component localComponent = SdkMavenRepository.getComponentFromSdkPath(local.getPath());
        Component remoteComponent = SdkMavenRepository.getComponentFromSdkPath(remote.getPath());
        if (localComponent == null) {
            return remote;
        }
        if (remoteComponent == null) {
            return local;
        }
        if (localComponent.getVersion().compareTo(remoteComponent.getVersion()) < 0) {
            return remote;
        }
        return local;
    }

    @Deprecated
    public static RepoPackage findLatestVersion(Dependency dependency, AndroidSdkHandler sdkHandler, Predicate<Version> filter2, ProgressIndicator progress) {
        Module module = dependency.getModule();
        if (module == null) {
            return null;
        }
        return SdkMavenRepository.findLatestVersion(module, dependency.getExplicitlyIncludesPreview(), sdkHandler, filter2, progress);
    }
}

