/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.utils;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatReceiverTask;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class LogcatService {
    private final IDevice myDevice;
    private final LogCatReceiverTask myLogCatReceiverTask;

    public LogcatService(IDevice device) {
        this.myDevice = device;
        this.myLogCatReceiverTask = new LogCatReceiverTask(device);
    }

    public void startListening(Listener listener) {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("logcat-" + this.myDevice.getName()).build();
        ExecutorService executor = Executors.newSingleThreadExecutor(factory);
        this.myLogCatReceiverTask.addLogCatListener(msgList -> {
            for (LogCatMessage message : msgList) {
                listener.onLogLineReceived(message);
            }
        });
        executor.execute((Runnable)this.myLogCatReceiverTask);
    }

    public void stopListening() {
        this.myLogCatReceiverTask.stop();
    }

    public static interface Listener {
        public void onLogLineReceived(LogCatMessage var1);
    }
}

