/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LocaleManager {
    private static final String[] ISO_639_2_CODES = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "afa", "afh", "afr", "ain", "aka", "akk", "ale", "alg", "alt", "amh", "ang", "anp", "apa", "ara", "arc", "arg", "arn", "arp", "art", "arw", "asm", "ast", "ath", "aus", "ava", "ave", "awa", "aym", "aze", "bad", "bai", "bak", "bal", "bam", "ban", "bas", "bat", "bej", "bel", "bem", "ben", "ber", "bho", "bih", "bik", "bin", "bis", "bla", "bnt", "bod", "bos", "bra", "bre", "btk", "bua", "bug", "bul", "byn", "cad", "cai", "car", "cat", "cau", "ceb", "cel", "ces", "cha", "chb", "che", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chu", "chv", "chy", "cmc", "cnr", "cop", "cor", "cos", "cpe", "cpf", "cpp", "cre", "crh", "crp", "csb", "cus", "cym", "dak", "dan", "dar", "day", "del", "den", "deu", "dgr", "din", "div", "doi", "dra", "dsb", "dua", "dum", "dyu", "dzo", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "est", "eus", "ewe", "ewo", "fan", "fao", "fas", "fat", "fij", "fil", "fin", "fiu", "fon", "fra", "frm", "fro", "frr", "frs", "fry", "ful", "fur", "gaa", "gay", "gba", "gem", "gez", "gil", "gla", "gle", "glg", "glv", "gmh", "goh", "gon", "gor", "got", "grb", "grc", "grn", "gsw", "guj", "gwi", "hai", "hat", "hau", "haw", "heb", "her", "hil", "him", "hin", "hit", "hmn", "hmo", "hrv", "hsb", "hun", "hup", "hye", "iba", "ibo", "ido", "iii", "ijo", "iku", "ile", "ilo", "ina", "inc", "ind", "ine", "inh", "ipk", "ira", "iro", "isl", "ita", "jav", "jbo", "jpn", "jpr", "jrb", "kaa", "kab", "kac", "kal", "kam", "kan", "kar", "kas", "kat", "kau", "kaw", "kaz", "kbd", "kgp", "kha", "khi", "khm", "kho", "kik", "kin", "kir", "kmb", "kok", "kom", "kon", "kor", "kos", "kpe", "krc", "krl", "kro", "kru", "kua", "kum", "kur", "kut", "lad", "lah", "lam", "lao", "lat", "lav", "lez", "lim", "lin", "lit", "lol", "loz", "lrc", "ltz", "lua", "lub", "lug", "lui", "lun", "luo", "lus", "mad", "mag", "mah", "mai", "mak", "mal", "man", "map", "mar", "mas", "mdf", "mdr", "men", "mga", "mic", "min", "mis", "mkd", "mkh", "mlg", "mlt", "mnc", "mni", "mno", "moh", "mon", "mos", "mri", "msa", "mul", "mun", "mus", "mwl", "mwr", "mya", "myn", "myv", "mzn", "nah", "nai", "nap", "nau", "nav", "nbl", "nde", "ndo", "nds", "nep", "new", "nia", "nic", "niu", "nld", "nno", "nob", "nog", "non", "nor", "nqo", "nso", "nub", "nwc", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "ori", "orm", "osa", "oss", "ota", "oto", "paa", "pag", "pal", "pam", "pan", "pap", "pau", "pcm", "peo", "phi", "phn", "pli", "pol", "pon", "por", "pra", "pro", "pus", "que", "raj", "rap", "rar", "roa", "roh", "rom", "ron", "run", "rup", "rus", "sad", "sag", "sah", "sai", "sal", "sam", "san", "sas", "sat", "scn", "sco", "sel", "sem", "sga", "sgn", "shn", "sid", "sin", "sio", "sit", "sla", "slk", "slv", "sma", "sme", "smi", "smj", "smn", "smo", "sms", "sna", "snd", "snk", "sog", "som", "son", "sot", "spa", "sqi", "srd", "srn", "srp", "srr", "ssa", "ssw", "suk", "sun", "sus", "sux", "swa", "swe", "syc", "syr", "tah", "tai", "tam", "tat", "tel", "tem", "ter", "tet", "tgk", "tgl", "tha", "tig", "tir", "tiv", "tkl", "tlh", "tli", "tmh", "tog", "ton", "tpi", "tsi", "tsn", "tso", "tuk", "tum", "tup", "tur", "tut", "tvl", "twi", "tyv", "udm", "uga", "uig", "ukr", "umb", "und", "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "wak", "wal", "war", "was", "wen", "wln", "wol", "xal", "xho", "yao", "yap", "yid", "yor", "ypk", "yrl", "zap", "zbl", "zen", "zgh", "zha", "zho", "znd", "zul", "zun", "zza"};
    private static final String[] ISO_639_2_NAMES = new String[]{"Afar", "Abkhazian", "Achinese", "Acoli", "Adangme", "Adyghe; Adygei", "Afro-Asiatic languages", "Afrihili", "Afrikaans", "Ainu", "Akan", "Akkadian", "Aleut", "Algonquian languages", "Southern Altai", "Amharic", "English, Old (ca.450-1100)", "Angika", "Apache languages", "Arabic", "Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)", "Aragonese", "Mapudungun; Mapuche", "Arapaho", "Artificial languages", "Arawak", "Assamese", "Asturian; Bable; Leonese; Asturleonese", "Athapascan languages", "Australian languages", "Avaric", "Avestan", "Awadhi", "Aymara", "Azerbaijani", "Banda languages", "Bamileke languages", "Bashkir", "Baluchi", "Bambara", "Balinese", "Basa", "Baltic languages", "Beja; Bedawiyet", "Belarusian", "Bemba", "Bangla", "Berber languages", "Bhojpuri", "Bihari languages", "Bikol", "Bini; Edo", "Bislama", "Siksika", "Bantu languages", "Tibetan", "Bosnian", "Braj", "Breton", "Batak languages", "Buriat", "Buginese", "Bulgarian", "Blin; Bilin", "Caddo", "Central American Indian languages", "Galibi Carib", "Catalan", "Caucasian languages", "Cebuano", "Celtic languages", "Czech", "Chamorro", "Chibcha", "Chechen", "Chagatai", "Chuukese", "Mari", "Chinook jargon", "Choctaw", "Chipewyan; Dene Suline", "Cherokee", "Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic", "Chuvash", "Cheyenne", "Chamic languages", "Montenegrin", "Coptic", "Cornish", "Corsican", "Creoles and pidgins, English based", "Creoles and pidgins, French-based", "Creoles and pidgins, Portuguese-based", "Cree", "Crimean Tatar; Crimean Turkish", "Creoles and pidgins", "Kashubian", "Cushitic languages", "Welsh", "Dakota", "Danish", "Dargwa", "Land Dayak languages", "Delaware", "Slave (Athapascan)", "German", "Dogrib", "Dinka", "Divehi; Dhivehi; Maldivian", "Dogri", "Dravidian languages", "Lower Sorbian", "Duala", "Dutch, Middle (ca.1050-1350)", "Dyula", "Dzongkha", "Efik", "Egyptian (Ancient)", "Ekajuk", "Greek", "Elamite", "English", "English, Middle (1100-1500)", "Esperanto", "Estonian", "Basque", "Ewe", "Ewondo", "Fang", "Faroese", "Persian", "Fanti", "Fijian", "Filipino; Pilipino", "Finnish", "Finno-Ugrian languages", "Fon", "French", "French, Middle (ca.1400-1600)", "French, Old (842-ca.1400)", "Northern Frisian", "Eastern Frisian", "Western Frisian", "Fulah", "Friulian", "Ga", "Gayo", "Gbaya", "Germanic languages", "Geez", "Gilbertese", "Scottish Gaelic", "Irish", "Galician", "Manx", "German, Middle High (ca.1050-1500)", "German, Old High (ca.750-1050)", "Gondi", "Gorontalo", "Gothic", "Grebo", "Greek, Ancient (to 1453)", "Guarani", "Swiss German; Alemannic; Alsatian", "Gujarati", "Gwich'in", "Haida", "Haitian; Haitian Creole", "Hausa", "Hawaiian", "Hebrew", "Herero", "Hiligaynon", "Himachali languages; Western Pahari languages", "Hindi", "Hittite", "Hmong; Mong", "Hiri Motu", "Croatian", "Upper Sorbian", "Hungarian", "Hupa", "Armenian", "Iban", "Igbo", "Ido", "Sichuan Yi", "Ijo languages", "Inuktitut", "Interlingue; Occidental", "Iloko", "Interlingua", "Indic languages", "Indonesian", "Indo-European languages", "Ingush", "Inupiaq", "Iranian languages", "Iroquoian languages", "Icelandic", "Italian", "Javanese", "Lojban", "Japanese", "Judeo-Persian", "Judeo-Arabic", "Kara-Kalpak", "Kabyle", "Kachin; Jingpho", "Kalaallisut", "Kamba", "Kannada", "Karen languages", "Kashmiri", "Georgian", "Kanuri", "Kawi", "Kazakh", "Kabardian", "Kaingang", "Khasi", "Khoisan languages", "Khmer", "Khotanese; Sakan", "Kikuyu", "Kinyarwanda", "Kyrgyz", "Kimbundu", "Konkani", "Komi", "Kongo", "Korean", "Kosraean", "Kpelle", "Karachay-Balkar", "Karelian", "Kru languages", "Kurukh", "Kuanyama; Kwanyama", "Kumyk", "Kurdish", "Kutenai", "Ladino", "Lahnda", "Lamba", "Lao", "Latin", "Latvian", "Lezghian", "Limburgan; Limburger; Limburgish", "Lingala", "Lithuanian", "Mongo", "Lozi", "Northern Luri", "Luxembourgish", "Luba-Lulua", "Luba-Katanga", "Ganda", "Luiseno", "Lunda", "Luo (Kenya and Tanzania)", "Lushai", "Madurese", "Magahi", "Marshallese", "Maithili", "Makasar", "Malayalam", "Mandingo", "Austronesian languages", "Marathi", "Masai", "Moksha", "Mandar", "Mende", "Irish, Middle (900-1200)", "Mi'kmaq; Micmac", "Minangkabau", "Uncoded languages", "Macedonian", "Mon-Khmer languages", "Malagasy", "Maltese", "Manchu", "Manipuri", "Manobo languages", "Mohawk", "Mongolian", "Mossi", "M\u0101ori", "Malay", "Multiple languages", "Munda languages", "Creek", "Mirandese", "Marwari", "Burmese", "Mayan languages", "Erzya", "Mazanderani", "Nahuatl languages", "North American Indian languages", "Neapolitan", "Nauru", "Navajo; Navaho", "Ndebele, South; South Ndebele", "North Ndebele", "Ndonga", "Low German; Low Saxon; German, Low; Saxon, Low", "Nepali", "Nepal Bhasa; Newari", "Nias", "Niger-Kordofanian languages", "Niuean", "Dutch", "Norwegian Nynorsk", "Norwegian Bokm\u00e5l", "Nogai", "Norse, Old", "Norwegian", "N'Ko", "Pedi; Sepedi; Northern Sotho", "Nubian languages", "Classical Newari; Old Newari; Classical Nepal Bhasa", "Chichewa; Chewa; Nyanja", "Nyamwezi", "Nyankole", "Nyoro", "Nzima", "Occitan (post 1500)", "Ojibwa", "Odia", "Oromo", "Osage", "Ossetic", "Turkish, Ottoman (1500-1928)", "Otomian languages", "Papuan languages", "Pangasinan", "Pahlavi", "Pampanga; Kapampangan", "Punjabi", "Papiamento", "Palauan", "Nigerian Pidgin", "Persian, Old (ca.600-400 B.C.)", "Philippine languages", "Phoenician", "Pali", "Polish", "Pohnpeian", "Portuguese", "Prakrit languages", "Proven\u00e7al, Old (to 1500); Occitan, Old (to 1500)", "Pashto", "Quechua", "Rajasthani", "Rapanui", "Rarotongan; Cook Islands Maori", "Romance languages", "Romansh", "Romany", "Romanian", "Rundi", "Aromanian; Arumanian; Macedo-Romanian", "Russian", "Sandawe", "Sango", "Yakut", "South American Indian languages", "Salishan languages", "Samaritan Aramaic", "Sanskrit", "Sasak", "Santali", "Sicilian", "Scots", "Selkup", "Semitic languages", "Irish, Old (to 900)", "Sign Languages", "Shan", "Sidamo", "Sinhala", "Siouan languages", "Sino-Tibetan languages", "Slavic languages", "Slovak", "Slovenian", "Southern Sami", "Northern Sami", "Sami languages", "Lule Sami", "Inari Sami", "Samoan", "Skolt Sami", "Shona", "Sindhi", "Soninke", "Sogdian", "Somali", "Songhai languages", "Sotho, Southern", "Spanish", "Albanian", "Sardinian", "Sranan Tongo", "Serbian", "Serer", "Nilo-Saharan languages", "Swati", "Sukuma", "Sundanese", "Susu", "Sumerian", "Swahili", "Swedish", "Classical Syriac", "Syriac", "Tahitian", "Tai languages", "Tamil", "Tatar", "Telugu", "Timne", "Tereno", "Tetum", "Tajik", "Tagalog", "Thai", "Tigre", "Tigrinya", "Tiv", "Tokelau", "Klingon; tlhIngan-Hol", "Tlingit", "Tamashek", "Tonga (Nyasa)", "Tongan", "Tok Pisin", "Tsimshian", "Tswana", "Tsonga", "Turkmen", "Tumbuka", "Tupi languages", "Turkish", "Altaic languages", "Tuvalu", "Twi", "Tuvinian", "Udmurt", "Ugaritic", "Uyghur", "Ukrainian", "Umbundu", "Undetermined", "Urdu", "Uzbek", "Vai", "Venda", "Vietnamese", "Volap\u00fck", "Votic", "Wakashan languages", "Wolaitta; Wolaytta", "Waray", "Washo", "Sorbian languages", "Walloon", "Wolof", "Kalmyk; Oirat", "Xhosa", "Yao", "Yapese", "Yiddish", "Yoruba", "Yupik languages", "Nheengatu", "Zapotec", "Blissymbols; Blissymbolics; Bliss", "Zenaga", "Standard Moroccan Tamazight", "Zhuang; Chuang", "Chinese", "Zande languages", "Zulu", "Zuni", "Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki"};
    private static final String[] ISO_639_1_CODES = new String[]{"aa", "ab", "ae", "af", "ak", "am", "an", "ar", "as", "av", "ay", "az", "ba", "be", "bg", "bh", "bi", "bm", "bn", "bo", "br", "bs", "ca", "ce", "ch", "co", "cr", "cs", "cu", "cv", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "gv", "ha", "he", "hi", "ho", "hr", "ht", "hu", "hy", "hz", "ia", "id", "ie", "ig", "ii", "ik", "in", "io", "is", "it", "iu", "iw", "ja", "ji", "jv", "ka", "kg", "ki", "kj", "kk", "kl", "km", "kn", "ko", "kr", "ks", "ku", "kv", "kw", "ky", "la", "lb", "lg", "li", "ln", "lo", "lt", "lu", "lv", "mg", "mh", "mi", "mk", "ml", "mn", "mr", "ms", "mt", "my", "na", "nb", "nd", "ne", "ng", "nl", "nn", "no", "nr", "nv", "ny", "oc", "oj", "om", "or", "os", "pa", "pi", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sc", "sd", "se", "sg", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ty", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
    private static final int[] ISO_639_1_TO_2 = new int[]{0, 1, 31, 8, 10, 15, 21, 19, 26, 30, 33, 34, 37, 44, 62, 49, 52, 39, 46, 55, 58, 56, 67, 74, 72, 89, 93, 71, 82, 83, 98, 100, 105, 108, 115, 126, 119, 121, 123, 404, 124, 125, 130, 143, 134, 132, 129, 137, 142, 152, 151, 153, 162, 164, 154, 168, 170, 174, 177, 178, 167, 180, 182, 171, 191, 193, 189, 184, 186, 196, 193, 185, 199, 200, 188, 170, 203, 476, 201, 214, 230, 224, 238, 217, 209, 222, 211, 231, 215, 213, 240, 229, 88, 226, 246, 255, 258, 249, 250, 245, 251, 257, 247, 282, 265, 290, 280, 268, 288, 271, 291, 283, 297, 304, 317, 307, 310, 308, 315, 316, 320, 306, 305, 325, 330, 331, 333, 332, 335, 342, 349, 350, 355, 352, 356, 361, 364, 363, 366, 225, 373, 406, 398, 391, 368, 384, 388, 389, 395, 397, 401, 405, 408, 411, 403, 413, 417, 416, 422, 424, 428, 430, 432, 444, 429, 442, 439, 447, 443, 423, 450, 420, 454, 455, 458, 459, 461, 462, 463, 470, 471, 473, 476, 477, 484, 485, 487};
    private static final int[] ISO_639_2_TO_1 = new int[]{0, 1, -1, -1, -1, -1, -1, -1, 3, -1, 4, -1, -1, -1, -1, 5, -1, -1, -1, 7, -1, 6, -1, -1, -1, -1, 8, -1, -1, -1, 9, 2, -1, 10, 11, -1, -1, 12, -1, 17, -1, -1, -1, -1, 13, -1, 18, -1, -1, 15, -1, -1, 16, -1, -1, 19, 21, -1, 20, -1, -1, -1, 14, -1, -1, -1, -1, 22, -1, -1, -1, 27, 24, -1, 23, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, 92, 25, -1, -1, -1, 26, -1, -1, -1, -1, 30, -1, 31, -1, -1, -1, -1, 32, -1, -1, 33, -1, -1, -1, -1, -1, -1, 34, -1, -1, -1, 36, -1, 37, -1, 38, 40, 41, 35, -1, -1, 46, 42, -1, 45, -1, 44, -1, -1, 47, -1, -1, -1, -1, 48, 43, -1, -1, -1, -1, -1, -1, -1, 50, 49, 51, 54, -1, -1, -1, -1, -1, -1, -1, 52, -1, 53, -1, -1, 60, 55, -1, 75, 63, -1, -1, 57, -1, -1, 58, 59, -1, 61, -1, 62, -1, 67, 71, 68, -1, 74, 66, -1, 64, -1, 70, -1, -1, 69, -1, -1, 72, 73, 78, -1, 76, -1, -1, -1, -1, -1, 84, -1, 86, -1, 89, 79, 88, -1, 83, -1, -1, -1, -1, 85, -1, 81, 139, 93, -1, -1, 91, 80, 87, -1, -1, -1, -1, -1, -1, 82, -1, 90, -1, -1, -1, -1, 99, 94, 102, -1, 97, 98, 100, -1, -1, -1, 95, -1, 101, 96, -1, -1, -1, -1, -1, -1, 104, -1, -1, 107, -1, -1, 109, -1, -1, -1, -1, -1, -1, -1, -1, 106, -1, 103, 111, -1, -1, -1, -1, 108, -1, 105, 110, -1, -1, -1, -1, -1, 112, -1, -1, -1, -1, -1, -1, 113, 122, 121, 115, 117, -1, 116, -1, -1, -1, -1, 118, 119, 114, -1, -1, 120, -1, -1, -1, -1, 123, -1, -1, -1, -1, 124, 125, 127, 126, -1, 128, -1, -1, -1, -1, -1, -1, 129, -1, -1, -1, -1, -1, -1, 130, 131, -1, 133, -1, -1, 132, 134, -1, -1, -1, -1, 135, -1, 137, 136, -1, 138, -1, 144, -1, -1, -1, -1, 140, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, -1, -1, -1, 146, 147, -1, 143, -1, -1, -1, 148, -1, 149, 142, -1, -1, 150, -1, 154, 39, 151, 141, -1, 152, -1, -1, 153, -1, 155, -1, -1, 157, 156, -1, -1, 171, -1, 158, 169, 159, -1, -1, -1, 160, 164, 161, -1, 162, -1, -1, -1, -1, -1, -1, 166, -1, -1, 165, 168, 163, -1, -1, 167, -1, -1, 170, -1, -1, -1, 172, 173, -1, -1, 174, 175, -1, 176, 177, 178, -1, -1, -1, -1, -1, -1, 179, 180, -1, 181, -1, -1, 77, 183, -1, -1, -1, -1, -1, -1, 184, 185, -1, 186, -1, -1};
    private static final String[] ISO_3166_2_CODES = new String[]{"ABW", "AFG", "AGO", "AIA", "ALA", "ALB", "AND", "ARE", "ARG", "ARM", "ASM", "ATA", "ATF", "ATG", "AUS", "AUT", "AZE", "BDI", "BEL", "BEN", "BES", "BFA", "BGD", "BGR", "BHR", "BHS", "BIH", "BLM", "BLR", "BLZ", "BMU", "BOL", "BRA", "BRB", "BRN", "BTN", "BVT", "BWA", "CAF", "CAN", "CCK", "CHE", "CHL", "CHN", "CIV", "CMR", "COD", "COG", "COK", "COL", "COM", "CPV", "CRI", "CUB", "CUW", "CXR", "CYM", "CYP", "CZE", "DEU", "DGA", "DJI", "DMA", "DNK", "DOM", "DZA", "ECU", "EGY", "ERI", "ESH", "ESP", "EST", "ETH", "FIN", "FJI", "FLK", "FRA", "FRO", "FSM", "GAB", "GBR", "GEO", "GGY", "GHA", "GIB", "GIN", "GLP", "GMB", "GNB", "GNQ", "GRC", "GRD", "GRL", "GTM", "GUF", "GUM", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IMN", "IND", "IOT", "IRL", "IRN", "IRQ", "ISL", "ISR", "ITA", "JAM", "JEY", "JOR", "JPN", "KAZ", "KEN", "KGZ", "KHM", "KIR", "KNA", "KOR", "KWT", "LAO", "LBN", "LBR", "LBY", "LCA", "LIE", "LKA", "LSO", "LTU", "LUX", "LVA", "MAC", "MAF", "MAR", "MCO", "MDA", "MDG", "MDV", "MEX", "MHL", "MKD", "MLI", "MLT", "MMR", "MNE", "MNG", "MNP", "MOZ", "MRT", "MSR", "MTQ", "MUS", "MWI", "MYS", "MYT", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NIU", "NLD", "NOR", "NPL", "NRU", "NZL", "OMN", "PAK", "PAN", "PCN", "PER", "PHL", "PLW", "PNG", "POL", "PRI", "PRK", "PRT", "PRY", "PSE", "PYF", "QAT", "REU", "ROU", "RUS", "RWA", "SAU", "SDN", "SEN", "SGP", "SGS", "SHN", "SJM", "SLB", "SLE", "SLV", "SMR", "SOM", "SPM", "SRB", "SSD", "STP", "SUR", "SVK", "SVN", "SWE", "SWZ", "SXM", "SYC", "SYR", "TCA", "TCD", "TGO", "THA", "TJK", "TKL", "TKM", "TLS", "TON", "TTO", "TUN", "TUR", "TUV", "TWN", "TZA", "UGA", "UKR", "UMI", "URY", "USA", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "XEA", "XIC", "XKK", "YEM", "ZAF", "ZMB", "ZWE"};
    private static final String[] ISO_3166_2_NAMES = new String[]{"Aruba", "Afghanistan", "Angola", "Anguilla", "\u00c5land Islands", "Albania", "Andorra", "United Arab Emirates", "Argentina", "Armenia", "American Samoa", "Antarctica", "French Southern Territories (the)", "Antigua & Barbuda", "Australia", "Austria", "Azerbaijan", "Burundi", "Belgium", "Benin", "Caribbean Netherlands", "Burkina Faso", "Bangladesh", "Bulgaria", "Bahrain", "Bahamas", "Bosnia & Herzegovina", "St. Barth\u00e9lemy", "Belarus", "Belize", "Bermuda", "Bolivia", "Brazil", "Barbados", "Brunei", "Bhutan", "Bouvet Island", "Botswana", "Central African Republic", "Canada", "Cocos (Keeling) Islands", "Switzerland", "Chile", "China", "C\u00f4te d\u2019Ivoire", "Cameroon", "Congo - Kinshasa", "Congo - Brazzaville", "Cook Islands", "Colombia", "Comoros", "Cape Verde", "Costa Rica", "Cuba", "Cura\u00e7ao", "Christmas Island", "Cayman Islands", "Cyprus", "Czechia", "Germany", "Diego Garcia", "Djibouti", "Dominica", "Denmark", "Dominican Republic", "Algeria", "Ecuador", "Egypt", "Eritrea", "Western Sahara", "Spain", "Estonia", "Ethiopia", "Finland", "Fiji", "Falkland Islands", "France", "Faroe Islands", "Micronesia", "Gabon", "United Kingdom", "Georgia", "Guernsey", "Ghana", "Gibraltar", "Guinea", "Guadeloupe", "Gambia", "Guinea-Bissau", "Equatorial Guinea", "Greece", "Grenada", "Greenland", "Guatemala", "French Guiana", "Guam", "Guyana", "Hong Kong SAR China", "Heard Island and McDonald Islands", "Honduras", "Croatia", "Haiti", "Hungary", "Indonesia", "Isle of Man", "India", "British Indian Ocean Territory", "Ireland", "Iran", "Iraq", "Iceland", "Israel", "Italy", "Jamaica", "Jersey", "Jordan", "Japan", "Kazakhstan", "Kenya", "Kyrgyzstan", "Cambodia", "Kiribati", "St. Kitts & Nevis", "South Korea", "Kuwait", "Laos", "Lebanon", "Liberia", "Libya", "St. Lucia", "Liechtenstein", "Sri Lanka", "Lesotho", "Lithuania", "Luxembourg", "Latvia", "Macao SAR China", "St. Martin", "Morocco", "Monaco", "Moldova", "Madagascar", "Maldives", "Mexico", "Marshall Islands", "North Macedonia", "Mali", "Malta", "Myanmar (Burma)", "Montenegro", "Mongolia", "Northern Mariana Islands", "Mozambique", "Mauritania", "Montserrat", "Martinique", "Mauritius", "Malawi", "Malaysia", "Mayotte", "Namibia", "New Caledonia", "Niger", "Norfolk Island", "Nigeria", "Nicaragua", "Niue", "Netherlands", "Norway", "Nepal", "Nauru", "New Zealand", "Oman", "Pakistan", "Panama", "Pitcairn Islands", "Peru", "Philippines", "Palau", "Papua New Guinea", "Poland", "Puerto Rico", "North Korea", "Portugal", "Paraguay", "Palestinian Territories", "French Polynesia", "Qatar", "R\u00e9union", "Romania", "Russia", "Rwanda", "Saudi Arabia", "Sudan", "Senegal", "Singapore", "South Georgia and the South Sandwich Islands", "St. Helena", "Svalbard & Jan Mayen", "Solomon Islands", "Sierra Leone", "El Salvador", "San Marino", "Somalia", "St. Pierre & Miquelon", "Serbia", "South Sudan", "S\u00e3o Tom\u00e9 & Pr\u00edncipe", "Suriname", "Slovakia", "Slovenia", "Sweden", "Eswatini", "Sint Maarten", "Seychelles", "Syria", "Turks & Caicos Islands", "Chad", "Togo", "Thailand", "Tajikistan", "Tokelau", "Turkmenistan", "Timor-Leste", "Tonga", "Trinidad & Tobago", "Tunisia", "Turkey", "Tuvalu", "Taiwan", "Tanzania", "Uganda", "Ukraine", "U.S. Outlying Islands", "Uruguay", "United States", "Uzbekistan", "Vatican City", "St. Vincent & Grenadines", "Venezuela", "British Virgin Islands", "U.S. Virgin Islands", "Vietnam", "Vanuatu", "Wallis & Futuna", "Samoa", "Ceuta & Melilla", "Canary Islands", "Kosovo", "Yemen", "South Africa", "Zambia", "Zimbabwe"};
    private static final String[] ISO_3166_1_CODES = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX", "CY", "CZ", "DE", "DG", "DJ", "DK", "DM", "DO", "DZ", "EA", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "IC", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "XK", "YE", "YT", "ZA", "ZM", "ZW"};
    private static final int[] ISO_3166_1_TO_2 = new int[]{6, 7, 1, 13, 3, 5, 9, 2, 11, 8, 10, 15, 14, 0, 4, 16, 26, 33, 22, 18, 21, 23, 24, 17, 19, 27, 30, 34, 31, 20, 32, 25, 35, 36, 37, 28, 29, 39, 40, 46, 38, 47, 41, 44, 48, 42, 45, 43, 49, 52, 53, 51, 54, 55, 57, 58, 59, 60, 61, 63, 62, 64, 65, 246, 66, 71, 67, 69, 68, 70, 72, 73, 74, 75, 78, 77, 76, 79, 80, 91, 81, 94, 82, 83, 84, 92, 87, 85, 86, 89, 90, 196, 93, 95, 88, 96, 97, 98, 99, 100, 101, 102, 247, 103, 107, 111, 104, 105, 106, 109, 108, 110, 112, 114, 113, 115, 116, 118, 119, 120, 121, 50, 122, 182, 123, 124, 56, 117, 125, 126, 129, 130, 131, 127, 132, 133, 134, 135, 128, 138, 139, 140, 149, 137, 141, 144, 145, 146, 148, 150, 136, 151, 155, 153, 154, 147, 156, 142, 157, 143, 158, 152, 160, 161, 162, 163, 164, 165, 167, 168, 169, 170, 166, 171, 172, 174, 176, 186, 179, 177, 173, 180, 204, 175, 181, 185, 183, 178, 184, 187, 188, 189, 205, 190, 191, 192, 199, 214, 193, 211, 195, 197, 210, 198, 209, 200, 202, 194, 203, 208, 206, 207, 201, 213, 215, 212, 216, 217, 12, 218, 219, 220, 221, 223, 222, 226, 224, 227, 225, 228, 229, 230, 232, 231, 233, 235, 234, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 248, 249, 159, 250, 251, 252};
    private static final int[] ISO_3166_2_TO_1 = new int[]{13, 2, 7, 4, 14, 5, 0, 1, 9, 6, 10, 8, 218, 3, 12, 11, 15, 23, 19, 24, 29, 20, 18, 21, 22, 31, 16, 25, 35, 36, 26, 28, 30, 17, 27, 32, 33, 34, 40, 37, 38, 42, 45, 47, 43, 46, 39, 41, 44, 48, 121, 51, 49, 50, 52, 53, 126, 54, 55, 56, 57, 58, 60, 59, 61, 62, 64, 66, 68, 67, 69, 65, 70, 71, 72, 73, 76, 75, 74, 77, 78, 80, 82, 83, 84, 87, 88, 86, 94, 89, 90, 79, 85, 92, 81, 93, 95, 96, 97, 98, 99, 100, 101, 103, 106, 107, 108, 104, 110, 109, 111, 105, 112, 114, 113, 115, 116, 127, 117, 118, 119, 120, 122, 124, 125, 128, 129, 133, 138, 130, 131, 132, 134, 135, 136, 137, 150, 143, 139, 140, 141, 144, 157, 159, 145, 146, 147, 155, 148, 142, 149, 151, 161, 153, 154, 152, 156, 158, 160, 249, 162, 163, 164, 165, 166, 167, 172, 168, 169, 170, 171, 173, 174, 180, 175, 183, 176, 179, 187, 178, 181, 184, 123, 186, 188, 185, 177, 189, 190, 191, 193, 194, 195, 198, 207, 200, 91, 201, 203, 196, 205, 212, 206, 208, 182, 192, 210, 211, 209, 204, 202, 199, 215, 213, 197, 214, 216, 217, 219, 220, 221, 222, 224, 223, 226, 228, 225, 227, 229, 230, 231, 233, 232, 234, 236, 235, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 63, 102, 247, 248, 250, 251, 252};
    private static final int[] REGIONS_AFR = new int[]{160, 250};
    private static final int[] REGIONS_ARA = new int[]{7, 24, 50, 61, 65, 67, 68, 69, 109, 111, 115, 124, 126, 128, 138, 153, 172, 185, 187, 192, 193, 203, 206, 215, 217, 226, 249};
    private static final int[] REGIONS_BEN = new int[]{22, 105};
    private static final int[] REGIONS_BOD = new int[]{43, 105};
    private static final int[] REGIONS_CAT = new int[]{6, 70, 76, 112};
    private static final int[] REGIONS_DAN = new int[]{63, 92};
    private static final int[] REGIONS_DEU = new int[]{59, 15, 18, 41, 112, 130, 134};
    private static final int[] REGIONS_ELL = new int[]{57, 90};
    private static final int[] REGIONS_ENG = new int[]{3, 7, 10, 13, 14, 15, 17, 18, 25, 29, 30, 33, 37, 39, 40, 41, 45, 48, 55, 56, 57, 59, 60, 62, 63, 68, 73, 74, 75, 78, 80, 82, 83, 84, 87, 91, 95, 96, 97, 104, 105, 106, 107, 111, 113, 114, 118, 121, 122, 127, 129, 132, 136, 141, 142, 144, 147, 151, 154, 156, 157, 158, 160, 163, 164, 166, 167, 170, 171, 173, 175, 177, 178, 179, 181, 191, 193, 195, 197, 199, 200, 206, 210, 211, 212, 213, 214, 216, 221, 224, 225, 228, 230, 231, 233, 235, 238, 240, 241, 243, 245, 250, 251, 252};
    private static final int[] REGIONS_EWE = new int[]{83, 218};
    private static final int[] REGIONS_FAO = new int[]{63, 77};
    private static final int[] REGIONS_FAS = new int[]{1, 108};
    private static final int[] REGIONS_FRA = new int[]{76, 17, 18, 19, 21, 27, 38, 39, 41, 44, 45, 46, 47, 50, 61, 65, 79, 85, 86, 89, 94, 101, 134, 137, 138, 139, 141, 146, 153, 155, 156, 159, 161, 162, 186, 188, 191, 194, 204, 214, 215, 217, 218, 226, 243, 244};
    private static final int[] REGIONS_FUL = new int[]{21, 45, 83, 85, 87, 88, 127, 153, 162, 164, 194, 200};
    private static final int[] REGIONS_GLE = new int[]{80, 107};
    private static final int[] REGIONS_HAU = new int[]{83, 162, 164};
    private static final int[] REGIONS_HRV = new int[]{100, 26};
    private static final int[] REGIONS_ITA = new int[]{112, 41, 202, 237};
    private static final int[] REGIONS_KOR = new int[]{123, 182};
    private static final int[] REGIONS_LIN = new int[]{2, 38, 46, 47};
    private static final int[] REGIONS_LRC = new int[]{108, 109};
    private static final int[] REGIONS_MSA = new int[]{34, 103, 158, 195};
    private static final int[] REGIONS_NEP = new int[]{105, 169};
    private static final int[] REGIONS_NLD = new int[]{167, 0, 18, 20, 54, 208, 213};
    private static final int[] REGIONS_NOB = new int[]{168, 198};
    private static final int[] REGIONS_ORM = new int[]{72, 118};
    private static final int[] REGIONS_OSS = new int[]{81, 190};
    private static final int[] REGIONS_PAN = new int[]{105, 173};
    private static final int[] REGIONS_POR = new int[]{2, 32, 41, 51, 88, 89, 134, 136, 152, 183, 207, 223};
    private static final int[] REGIONS_PUS = new int[]{1, 173};
    private static final int[] REGIONS_QUE = new int[]{31, 66, 176};
    private static final int[] REGIONS_RON = new int[]{140, 189};
    private static final int[] REGIONS_RUS = new int[]{190, 28, 117, 119, 140, 232};
    private static final int[] REGIONS_SME = new int[]{73, 168, 211};
    private static final int[] REGIONS_SND = new int[]{105, 173};
    private static final int[] REGIONS_SOM = new int[]{203, 61, 72, 118};
    private static final int[] REGIONS_SPA = new int[]{8, 29, 31, 32, 42, 49, 52, 53, 64, 66, 70, 89, 93, 99, 143, 165, 174, 176, 177, 181, 184, 201, 234, 235, 239, 246, 247};
    private static final int[] REGIONS_SQI = new int[]{5, 145, 248};
    private static final int[] REGIONS_SRP = new int[]{26, 149, 205, 248};
    private static final int[] REGIONS_SWA = new int[]{46, 118, 230, 231};
    private static final int[] REGIONS_SWE = new int[]{211, 4, 73};
    private static final int[] REGIONS_TAM = new int[]{105, 131, 158, 195};
    private static final int[] REGIONS_TIR = new int[]{68, 72};
    private static final int[] REGIONS_TUR = new int[]{227, 57};
    private static final int[] REGIONS_URD = new int[]{105, 173};
    private static final int[] REGIONS_UZB = new int[]{236, 1};
    private static final int[] REGIONS_YOR = new int[]{19, 164};
    private static final int[] REGIONS_YRL = new int[]{32, 49, 239};
    private static final int[] REGIONS_ZHO = new int[]{43, 97, 136, 195, 229};
    private static final int[][] LANGUAGE_REGIONS = new int[][]{null, null, null, null, null, null, null, null, REGIONS_AFR, null, null, null, null, null, null, null, null, null, null, REGIONS_ARA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_BEN, null, null, null, null, null, null, null, null, REGIONS_BOD, null, null, null, null, null, null, null, null, null, null, null, REGIONS_CAT, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_DAN, null, null, null, null, REGIONS_DEU, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ELL, null, REGIONS_ENG, null, null, null, null, REGIONS_EWE, null, null, REGIONS_FAO, REGIONS_FAS, null, null, null, null, null, null, REGIONS_FRA, null, null, null, null, null, REGIONS_FUL, null, null, null, null, null, null, null, null, REGIONS_GLE, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_HAU, null, null, null, null, null, null, null, null, null, REGIONS_HRV, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ITA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_KOR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_LIN, null, null, null, REGIONS_LRC, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_MSA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_NEP, null, null, null, null, REGIONS_NLD, null, REGIONS_NOB, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ORM, null, REGIONS_OSS, null, null, null, null, null, null, REGIONS_PAN, null, null, null, null, null, null, null, null, null, REGIONS_POR, null, null, REGIONS_PUS, REGIONS_QUE, null, null, null, null, null, null, REGIONS_RON, null, null, REGIONS_RUS, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_SME, null, null, null, null, null, null, REGIONS_SND, null, null, REGIONS_SOM, null, null, REGIONS_SPA, REGIONS_SQI, null, null, REGIONS_SRP, null, null, null, null, null, null, null, REGIONS_SWA, REGIONS_SWE, null, null, null, null, REGIONS_TAM, null, null, null, null, null, null, null, null, null, REGIONS_TIR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_TUR, null, null, null, null, null, null, null, null, null, null, REGIONS_URD, REGIONS_UZB, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_YOR, null, REGIONS_YRL, null, null, null, null, null, REGIONS_ZHO, null, null, null, null};
    private static final int[] LANGUAGE_REGION = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 160, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, -1, -1, -1, -1, -1, -1, -1, -1, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, -1, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57, -1, 3, -1, -1, -1, -1, 83, -1, -1, 63, 1, -1, -1, -1, -1, -1, -1, 76, -1, -1, -1, -1, -1, 21, -1, -1, -1, -1, -1, -1, -1, -1, 80, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 83, -1, -1, -1, -1, -1, -1, -1, -1, -1, 100, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 112, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, -1, -1, -1, 108, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 34, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 105, -1, -1, -1, -1, 167, -1, 168, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 72, -1, 81, -1, -1, -1, -1, -1, -1, 105, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, -1, -1, 1, 31, -1, -1, -1, -1, -1, -1, 140, -1, -1, 190, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 73, -1, -1, -1, -1, -1, -1, 105, -1, -1, 203, -1, -1, 8, 5, -1, -1, 26, -1, -1, -1, -1, -1, -1, -1, 46, 211, -1, -1, -1, -1, 105, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 227, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 105, 236, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19, -1, 32, -1, -1, -1, -1, -1, 43, -1, -1, -1, -1};

    private LocaleManager() {
    }

    public static String getRegionName(String regionCode) {
        if (regionCode.length() == 2) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1))) : regionCode;
            int index = Arrays.binarySearch(ISO_3166_1_CODES, regionCode);
            if (index < 0 || index >= ISO_3166_1_TO_2.length) {
                return null;
            }
            return ISO_3166_2_NAMES[ISO_3166_1_TO_2[index]];
        }
        if (regionCode.length() == 3) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1)) && Character.isUpperCase(regionCode.charAt(2))) : regionCode;
            int index = Arrays.binarySearch(ISO_3166_2_CODES, regionCode);
            if (index < 0) {
                return null;
            }
            return ISO_3166_2_NAMES[index];
        }
        return null;
    }

    public static String getLanguageName(String languageCode) {
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
            if (index < 0 || index >= ISO_639_1_TO_2.length) {
                return null;
            }
            return ISO_639_2_NAMES[ISO_639_1_TO_2[index]];
        }
        if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
            if (index < 0) {
                return null;
            }
            return ISO_639_2_NAMES[index];
        }
        return null;
    }

    public static List<String> getLanguageCodes() {
        return LocaleManager.getLanguageCodes(false);
    }

    public static List<String> getLanguageCodes(boolean include3) {
        if (!include3) {
            return Arrays.asList(ISO_639_1_CODES);
        }
        ArrayList<String> codes = new ArrayList<String>(ISO_639_2_CODES.length);
        for (int i = 0; i < ISO_639_2_TO_1.length; ++i) {
            int iso2 = ISO_639_2_TO_1[i];
            if (iso2 != -1) {
                codes.add(ISO_639_1_CODES[iso2]);
                continue;
            }
            codes.add(ISO_639_2_CODES[i]);
        }
        return codes;
    }

    public static List<String> getRegionCodes() {
        return LocaleManager.getRegionCodes(false);
    }

    public static List<String> getRegionCodes(boolean include3) {
        if (!include3) {
            return Arrays.asList(ISO_3166_1_CODES);
        }
        ArrayList<String> codes = new ArrayList<String>(ISO_3166_2_CODES.length);
        for (int i = 0; i < ISO_3166_2_TO_1.length; ++i) {
            int iso2 = ISO_3166_2_TO_1[i];
            if (iso2 != -1) {
                codes.add(ISO_3166_1_CODES[iso2]);
                continue;
            }
            codes.add(ISO_3166_2_CODES[i]);
        }
        return codes;
    }

    public static boolean isValidLanguageCode(String languageCode) {
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            return Arrays.binarySearch(ISO_639_1_CODES, languageCode) >= 0;
        }
        if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            return Arrays.binarySearch(ISO_639_2_CODES, languageCode) >= 0;
        }
        return false;
    }

    public static boolean isValidRegionCode(String regionCode) {
        if (regionCode.length() == 2) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1))) : regionCode;
            return Arrays.binarySearch(ISO_3166_1_CODES, regionCode) >= 0;
        }
        if (regionCode.length() == 3) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1)) && Character.isUpperCase(regionCode.charAt(2))) : regionCode;
            return Arrays.binarySearch(ISO_3166_2_CODES, regionCode) >= 0;
        }
        return false;
    }

    public static String getDefaultLanguageRegion(String languageCode) {
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
            if (index < 0 || index >= ISO_639_1_TO_2.length) {
                return null;
            }
            int regionIndex = LANGUAGE_REGION[ISO_639_1_TO_2[index]];
            if (regionIndex != -1) {
                int twoLetterIndex = ISO_3166_2_TO_1[regionIndex];
                if (twoLetterIndex != -1) {
                    return ISO_3166_1_CODES[twoLetterIndex];
                }
                return ISO_3166_2_CODES[regionIndex];
            }
            return null;
        }
        if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
            if (index < 0) {
                return null;
            }
            return LocaleManager.getRegionCode(LANGUAGE_REGION[index]);
        }
        assert (false) : languageCode;
        return null;
    }

    private static String getRegionCode(int index) {
        if (index != -1) {
            int twoLetterIndex = ISO_3166_2_TO_1[index];
            if (twoLetterIndex != -1) {
                return ISO_3166_1_CODES[twoLetterIndex];
            }
            return ISO_3166_2_CODES[index];
        }
        return null;
    }

    public static List<String> getRelevantRegions(String languageCode) {
        int languageIndex;
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
            if (index < 0 || index >= ISO_639_1_TO_2.length) {
                return Collections.emptyList();
            }
            languageIndex = ISO_639_1_TO_2[index];
        } else if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            languageIndex = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
            if (languageIndex < 0) {
                return Collections.emptyList();
            }
        } else {
            assert (false) : languageCode;
            return Collections.emptyList();
        }
        int[] regionIndices = LANGUAGE_REGIONS[languageIndex];
        if (regionIndices == null) {
            String regionCode = LocaleManager.getRegionCode(LANGUAGE_REGION[languageIndex]);
            return regionCode != null ? Collections.singletonList(regionCode) : Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>(regionIndices.length);
        for (int regionIndex : regionIndices) {
            String regionCode = LocaleManager.getRegionCode(regionIndex);
            if (regionCode == null) continue;
            result2.add(regionCode);
        }
        return result2;
    }

    public static String getLanguageAlpha2(String languageCode) {
        assert (languageCode.length() == 3) : languageCode;
        assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
        int index = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_639_2_TO_1[index];
        if (alpha2 != -1) {
            return ISO_639_1_CODES[alpha2];
        }
        return null;
    }

    public static String getLanguageAlpha3(String languageCode) {
        assert (languageCode.length() == 2) : languageCode;
        assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
        int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_639_1_TO_2[index];
        if (alpha2 != -1) {
            return ISO_639_2_CODES[alpha2];
        }
        return null;
    }

    public static String getRegionAlpha2(String regionCode) {
        assert (regionCode.length() == 3) : regionCode;
        assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1)) && Character.isUpperCase(regionCode.charAt(2))) : regionCode;
        int index = Arrays.binarySearch(ISO_3166_2_CODES, regionCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_3166_2_TO_1[index];
        if (alpha2 != -1) {
            return ISO_3166_1_CODES[alpha2];
        }
        return null;
    }

    public static String getRegionAlpha3(String regionCode) {
        assert (regionCode.length() == 2) : regionCode;
        assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1))) : regionCode;
        int index = Arrays.binarySearch(ISO_3166_1_CODES, regionCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_3166_1_TO_2[index];
        if (alpha2 != -1) {
            return ISO_3166_2_CODES[alpha2];
        }
        return null;
    }

    /*
     * Opcode count of 18080 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        assert (ISO_639_2_CODES.length == 490);
        assert (ISO_639_2_NAMES.length == 490);
        assert (ISO_639_2_TO_1.length == 490);
        assert (ISO_639_1_CODES.length == 187);
        assert (ISO_639_1_TO_2.length == 187);
        assert (ISO_3166_2_CODES.length == 253);
        assert (ISO_3166_2_NAMES.length == 253);
        assert (ISO_3166_2_TO_1.length == 253);
        assert (ISO_3166_1_CODES.length == 253);
        assert (ISO_3166_1_TO_2.length == 253);
        assert (LANGUAGE_REGION.length == 490);
        assert (LANGUAGE_REGIONS.length == 490);
    }
}

